/*
 * Decompiled with CFR 0.152.
 */
package com.bumptech.glide.annotation.compiler;

import com.bumptech.glide.annotation.GlideExtension;
import com.bumptech.glide.annotation.GlideOption;
import com.bumptech.glide.annotation.compiler.GlideAnnotationProcessor;
import com.bumptech.glide.repackaged.com.google.common.base.Function;
import com.bumptech.glide.repackaged.com.google.common.base.Joiner;
import com.bumptech.glide.repackaged.com.google.common.base.Predicate;
import com.bumptech.glide.repackaged.com.google.common.collect.FluentIterable;
import com.bumptech.glide.repackaged.com.google.common.collect.Lists;
import com.bumptech.glide.repackaged.com.squareup.javapoet.AnnotationSpec;
import com.bumptech.glide.repackaged.com.squareup.javapoet.ClassName;
import com.bumptech.glide.repackaged.com.squareup.javapoet.CodeBlock;
import com.bumptech.glide.repackaged.com.squareup.javapoet.JavaFile;
import com.bumptech.glide.repackaged.com.squareup.javapoet.MethodSpec;
import com.bumptech.glide.repackaged.com.squareup.javapoet.ParameterSpec;
import com.bumptech.glide.repackaged.com.squareup.javapoet.TypeName;
import com.bumptech.glide.repackaged.com.squareup.javapoet.TypeSpec;
import com.bumptech.glide.repackaged.com.squareup.javapoet.TypeVariableName;
import com.sun.tools.javac.code.Attribute;
import com.sun.tools.javac.code.Type;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.Name;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.TypeParameterElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.TypeVariable;
import javax.lang.model.util.ElementFilter;
import javax.lang.model.util.Types;
import javax.tools.Diagnostic;

final class ProcessorUtil {
    private static final String COMPILER_PACKAGE_NAME = GlideAnnotationProcessor.class.getPackage().getName();
    private final ProcessingEnvironment processingEnv;
    private final TypeElement appGlideModuleType;
    private final TypeElement libraryGlideModuleType;
    private int round;

    ProcessorUtil(ProcessingEnvironment processingEnv) {
        this.processingEnv = processingEnv;
        this.appGlideModuleType = processingEnv.getElementUtils().getTypeElement("com.bumptech.glide.module.AppGlideModule");
        this.libraryGlideModuleType = processingEnv.getElementUtils().getTypeElement("com.bumptech.glide.module.LibraryGlideModule");
    }

    void process() {
        ++this.round;
    }

    boolean isAppGlideModule(TypeElement element) {
        return this.processingEnv.getTypeUtils().isAssignable(element.asType(), this.appGlideModuleType.asType());
    }

    boolean isLibraryGlideModule(TypeElement element) {
        return this.processingEnv.getTypeUtils().isAssignable(element.asType(), this.libraryGlideModuleType.asType());
    }

    boolean isExtension(TypeElement element) {
        return element.getAnnotation(GlideExtension.class) != null;
    }

    int getOverrideType(ExecutableElement element) {
        GlideOption glideOption = element.getAnnotation(GlideOption.class);
        return glideOption.override();
    }

    void writeIndexer(TypeSpec indexer) {
        this.writeClass(COMPILER_PACKAGE_NAME, indexer);
    }

    void writeClass(String packageName, TypeSpec clazz) {
        try {
            this.debugLog("Writing class:\n" + clazz);
            JavaFile.builder(packageName, clazz).build().writeTo(this.processingEnv.getFiler());
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    List<ExecutableElement> findAnnotatedElementsInClasses(Set<String> classNames, Class<? extends Annotation> annotationClass) {
        ArrayList<ExecutableElement> result = new ArrayList<ExecutableElement>();
        for (String glideExtensionClassName : classNames) {
            TypeElement glideExtension = this.processingEnv.getElementUtils().getTypeElement(glideExtensionClassName);
            for (Element element : glideExtension.getEnclosedElements()) {
                if (element.getAnnotation(annotationClass) == null) continue;
                result.add((ExecutableElement)element);
            }
        }
        return result;
    }

    List<TypeElement> getElementsFor(Class<? extends Annotation> clazz, RoundEnvironment env) {
        Set<? extends Element> annotatedElements = env.getElementsAnnotatedWith(clazz);
        return ElementFilter.typesIn(annotatedElements);
    }

    CodeBlock generateSeeMethodJavadoc(ExecutableElement method) {
        return this.generateSeeMethodJavadoc(this.getJavadocSafeName(method.getEnclosingElement()), method.getSimpleName().toString(), method.getParameters());
    }

    CodeBlock generateSeeMethodJavadoc(TypeName nameOfClassContainingMethod, String methodSimpleName, List<? extends VariableElement> methodParameters) {
        return this.generateSeeMethodJavadocInternal(nameOfClassContainingMethod, methodSimpleName, Lists.transform(methodParameters, new Function<VariableElement, Object>(){

            @Override
            public Object apply(VariableElement input) {
                return ProcessorUtil.this.getJavadocSafeName(input);
            }
        }));
    }

    CodeBlock generateSeeMethodJavadoc(TypeName nameOfClassContainingMethod, MethodSpec methodSpec) {
        return this.generateSeeMethodJavadocInternal(nameOfClassContainingMethod, methodSpec.name, Lists.transform(methodSpec.parameters, new Function<ParameterSpec, Object>(){

            @Override
            public Object apply(ParameterSpec input) {
                return input.type;
            }
        }));
    }

    private CodeBlock generateSeeMethodJavadocInternal(TypeName nameOfClassContainingMethod, String methodName, List<Object> safeParameterNames) {
        StringBuilder javadocString = new StringBuilder("@see $T#$L(");
        ArrayList<Object> javadocArgs = new ArrayList<Object>();
        javadocArgs.add(nameOfClassContainingMethod);
        javadocArgs.add(methodName);
        for (Object param : safeParameterNames) {
            javadocString.append("$T, ");
            javadocArgs.add(param);
        }
        if (javadocArgs.size() > 2) {
            javadocString = new StringBuilder(javadocString.substring(0, javadocString.length() - 2));
        }
        javadocString.append(")\n");
        return CodeBlock.of(javadocString.toString(), javadocArgs.toArray(new Object[0]));
    }

    private TypeName getJavadocSafeName(Element element) {
        TypeMirror type;
        Types typeUtils = this.processingEnv.getTypeUtils();
        if (typeUtils.asElement(type = element.asType()) == null) {
            return ClassName.get(element.asType());
        }
        Name simpleName = typeUtils.asElement(type).getSimpleName();
        return ClassName.bestGuess(simpleName.toString());
    }

    void debugLog(String toLog) {
    }

    void infoLog(String toLog) {
        this.processingEnv.getMessager().printMessage(Diagnostic.Kind.NOTE, "[" + this.round + "] " + toLog);
    }

    void warnLog(String toLog) {
        this.processingEnv.getMessager().printMessage(Diagnostic.Kind.WARNING, toLog);
    }

    static CodeBlock generateCastingSuperCall(TypeName toReturn, ExecutableElement method) {
        return CodeBlock.builder().add("return ($T) super.$N(", toReturn, method.getSimpleName()).add(FluentIterable.from(method.getParameters()).transform(new Function<VariableElement, String>(){

            @Override
            public String apply(VariableElement input) {
                return input.getSimpleName().toString();
            }
        }).join(Joiner.on(",")), new Object[0]).add(");\n", new Object[0]).build();
    }

    static MethodSpec.Builder overriding(ExecutableElement method) {
        String methodName = method.getSimpleName().toString();
        MethodSpec.Builder builder = MethodSpec.methodBuilder(methodName).addAnnotation(Override.class);
        Set<Modifier> modifiers = method.getModifiers();
        modifiers = new LinkedHashSet<Modifier>(modifiers);
        modifiers.remove((Object)Modifier.ABSTRACT);
        Modifier defaultModifier = null;
        try {
            defaultModifier = Modifier.valueOf("DEFAULT");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        modifiers.remove((Object)defaultModifier);
        builder = builder.addModifiers(modifiers);
        for (TypeParameterElement typeParameterElement : method.getTypeParameters()) {
            TypeVariable var = (TypeVariable)typeParameterElement.asType();
            builder = builder.addTypeVariable(TypeVariableName.get(var));
        }
        builder = builder.returns(TypeName.get(method.getReturnType())).addParameters(ProcessorUtil.getParameters(method)).varargs(method.isVarArgs());
        for (TypeMirror typeMirror : method.getThrownTypes()) {
            builder = builder.addException(TypeName.get(typeMirror));
        }
        return builder;
    }

    static List<ParameterSpec> getParameters(ExecutableElement method) {
        return ProcessorUtil.getParameters(method.getParameters());
    }

    static List<ParameterSpec> getParameters(List<? extends VariableElement> parameters) {
        ArrayList<ParameterSpec> result = new ArrayList<ParameterSpec>();
        for (VariableElement variableElement : parameters) {
            result.add(ProcessorUtil.getParameter(variableElement));
        }
        return result;
    }

    private static ParameterSpec getParameter(VariableElement method) {
        TypeName type = TypeName.get(method.asType());
        String name = method.getSimpleName().toString();
        return ParameterSpec.builder(type, name, new Modifier[0]).addModifiers(method.getModifiers()).addAnnotations(ProcessorUtil.getAnnotations(method)).build();
    }

    private static List<AnnotationSpec> getAnnotations(VariableElement element) {
        ArrayList<AnnotationSpec> result = new ArrayList<AnnotationSpec>();
        for (AnnotationMirror annotationMirror : element.getAnnotationMirrors()) {
            result.add(AnnotationSpec.get(annotationMirror));
        }
        return result;
    }

    List<ExecutableElement> findInstanceMethodsReturning(TypeElement clazz, TypeMirror returnType) {
        return FluentIterable.from(clazz.getEnclosedElements()).filter(new FilterPublicMethods(returnType, MethodType.INSTANCE)).transform(new ToMethod()).toList();
    }

    List<ExecutableElement> findInstanceMethodsReturning(TypeElement clazz, TypeElement returnType) {
        return FluentIterable.from(clazz.getEnclosedElements()).filter(new FilterPublicMethods(returnType, MethodType.INSTANCE)).transform(new ToMethod()).toList();
    }

    List<ExecutableElement> findStaticMethodsReturning(TypeElement clazz, TypeElement returnType) {
        return FluentIterable.from(clazz.getEnclosedElements()).filter(new FilterPublicMethods(returnType, MethodType.STATIC)).transform(new ToMethod()).toList();
    }

    List<ExecutableElement> findStaticMethods(TypeElement clazz) {
        return FluentIterable.from(clazz.getEnclosedElements()).filter(new FilterPublicMethods((TypeMirror)null, MethodType.STATIC)).transform(new ToMethod()).toList();
    }

    Set<String> findClassValuesFromAnnotationOnClassAsNames(Element clazz, Class<? extends Annotation> annotationClass) {
        String annotationClassName = annotationClass.getName();
        AnnotationValue excludedModuleAnnotationValue = null;
        for (AnnotationMirror annotationMirror : clazz.getAnnotationMirrors()) {
            if (!annotationClassName.equals(annotationMirror.getAnnotationType().toString())) continue;
            Set<Map.Entry<? extends ExecutableElement, ? extends AnnotationValue>> values = annotationMirror.getElementValues().entrySet();
            if (values.size() != 1) {
                throw new IllegalArgumentException("Expected single value, but found: " + values);
            }
            excludedModuleAnnotationValue = values.iterator().next().getValue();
            if (excludedModuleAnnotationValue != null && !(excludedModuleAnnotationValue instanceof Attribute.UnresolvedClass)) continue;
            throw new IllegalArgumentException("Failed to find value for: " + annotationClass + " from mirrors: " + clazz.getAnnotationMirrors());
        }
        if (excludedModuleAnnotationValue == null) {
            return Collections.emptySet();
        }
        Object value = excludedModuleAnnotationValue.getValue();
        if (value instanceof List) {
            List list = (List)value;
            HashSet<String> result = new HashSet<String>(list.size());
            for (Object current : list) {
                result.add(ProcessorUtil.getExcludedModuleClassFromAnnotationAttribute(clazz, current));
            }
            return result;
        }
        Type.ClassType classType = (Type.ClassType)value;
        return Collections.singleton(classType.toString());
    }

    private static String getExcludedModuleClassFromAnnotationAttribute(Element clazz, Object attribute) {
        if (attribute.getClass().getSimpleName().equals("UnresolvedClass")) {
            throw new IllegalArgumentException("Failed to parse @Excludes for: " + clazz + ", one or more excluded Modules could not be found at compile time. Ensure that allexcluded Modules are included in your classpath.");
        }
        Method[] methods = attribute.getClass().getDeclaredMethods();
        if (methods == null || methods.length == 0) {
            throw new IllegalArgumentException("Failed to parse @Excludes for: " + clazz + ", invalid exclude: " + attribute);
        }
        for (Method method : methods) {
            if (!method.getName().equals("getValue")) continue;
            try {
                return method.invoke(attribute, new Object[0]).toString();
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                throw new IllegalArgumentException("Failed to parse @Excludes for: " + clazz, e);
            }
        }
        throw new IllegalArgumentException("Failed to parse @Excludes for: " + clazz);
    }

    boolean isReturnValueTypeMatching(ExecutableElement method, TypeElement expectedReturnType) {
        return this.isReturnValueTypeMatching(method, expectedReturnType.asType());
    }

    private boolean isReturnValueTypeMatching(ExecutableElement method, TypeMirror expectedReturnType) {
        return this.processingEnv.getTypeUtils().isAssignable(method.getReturnType(), expectedReturnType);
    }

    private static final class ToMethod
    implements Function<Element, ExecutableElement> {
        private ToMethod() {
        }

        @Override
        public ExecutableElement apply(Element input) {
            return (ExecutableElement)input;
        }
    }

    private final class FilterPublicMethods
    implements Predicate<Element> {
        private final TypeMirror returnType;
        private final MethodType methodType;

        FilterPublicMethods(TypeMirror returnType, MethodType methodType) {
            this.returnType = returnType;
            this.methodType = methodType;
        }

        FilterPublicMethods(TypeElement returnType, MethodType methodType) {
            this(returnType != null ? returnType.asType() : null, methodType);
        }

        @Override
        public boolean apply(Element input) {
            if (input == null || input.getKind() != ElementKind.METHOD || !input.getModifiers().contains((Object)Modifier.PUBLIC)) {
                return false;
            }
            boolean isStatic = input.getModifiers().contains((Object)Modifier.STATIC);
            if (this.methodType == MethodType.STATIC && !isStatic) {
                return false;
            }
            if (this.methodType == MethodType.INSTANCE && isStatic) {
                return false;
            }
            ExecutableElement method = (ExecutableElement)input;
            return this.returnType == null || ProcessorUtil.this.isReturnValueTypeMatching(method, this.returnType);
        }
    }

    private static final class MethodType
    extends Enum<MethodType> {
        public static final /* enum */ MethodType STATIC = new MethodType();
        public static final /* enum */ MethodType INSTANCE = new MethodType();
        private static final /* synthetic */ MethodType[] $VALUES;

        static {
            $VALUES = new MethodType[]{STATIC, INSTANCE};
        }
    }
}

