/*
 * Decompiled with CFR 0.152.
 */
package com.bumptech.glide.annotation.compiler;

import com.bumptech.glide.repackaged.com.squareup.javapoet.ClassName;
import com.bumptech.glide.repackaged.com.squareup.javapoet.MethodSpec;
import com.bumptech.glide.repackaged.com.squareup.javapoet.TypeSpec;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.Elements;

final class RequestManagerFactoryGenerator {
    private static final ClassName CONTEXT_CLASS_NAME = ClassName.get("android.content", "Context", new String[0]);
    private final TypeElement glideType;
    private final TypeElement lifecycleType;
    private final TypeElement requestManagerTreeNodeType;
    private final TypeElement requestManagerFactoryInterface;
    private final ClassName requestManagerClassName;

    RequestManagerFactoryGenerator(ProcessingEnvironment processingEnv) {
        Elements elementUtils = processingEnv.getElementUtils();
        this.glideType = elementUtils.getTypeElement("com.bumptech.glide.Glide");
        this.lifecycleType = elementUtils.getTypeElement("com.bumptech.glide.manager.Lifecycle");
        this.requestManagerTreeNodeType = elementUtils.getTypeElement("com.bumptech.glide.manager.RequestManagerTreeNode");
        this.requestManagerFactoryInterface = elementUtils.getTypeElement("com.bumptech.glide.manager.RequestManagerRetriever.RequestManagerFactory");
        TypeElement requestManagerType = elementUtils.getTypeElement("com.bumptech.glide.RequestManager");
        this.requestManagerClassName = ClassName.get(requestManagerType);
    }

    TypeSpec generate(String generatedCodePackageName, TypeSpec generatedRequestManagerSpec) {
        return TypeSpec.classBuilder("GeneratedRequestManagerFactory").addModifiers(Modifier.FINAL).addSuperinterface(ClassName.get(this.requestManagerFactoryInterface)).addJavadoc("Generated code, do not modify\n", new Object[0]).addMethod(MethodSpec.methodBuilder("build").addModifiers(Modifier.PUBLIC).addAnnotation(Override.class).returns(this.requestManagerClassName).addParameter(ClassName.get(this.glideType), "glide", new Modifier[0]).addParameter(ClassName.get(this.lifecycleType), "lifecycle", new Modifier[0]).addParameter(ClassName.get(this.requestManagerTreeNodeType), "treeNode", new Modifier[0]).addParameter(CONTEXT_CLASS_NAME, "context", new Modifier[0]).addStatement("return new $T(glide, lifecycle, treeNode, context)", ClassName.get(generatedCodePackageName, generatedRequestManagerSpec.name, new String[0])).build()).build();
    }
}

