/*
 * Decompiled with CFR 0.152.
 */
package com.bumptech.glide.repackaged.com.squareup.javapoet;

import com.bumptech.glide.repackaged.com.squareup.javapoet.AnnotationSpec;
import com.bumptech.glide.repackaged.com.squareup.javapoet.CodeWriter;
import com.bumptech.glide.repackaged.com.squareup.javapoet.TypeName;
import com.bumptech.glide.repackaged.com.squareup.javapoet.Util;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.NestingKind;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;

public final class ClassName
extends TypeName
implements Comparable<ClassName> {
    public static final ClassName OBJECT = ClassName.get(Object.class);
    final List<String> names;
    final String canonicalName;

    private ClassName(List<String> names) {
        this(names, new ArrayList<AnnotationSpec>());
    }

    private ClassName(List<String> names, List<AnnotationSpec> annotations) {
        super(annotations);
        for (int i = 1; i < names.size(); ++i) {
            Util.checkArgument(SourceVersion.isName(names.get(i)), "part '%s' is keyword", names.get(i));
        }
        this.names = Util.immutableList(names);
        this.canonicalName = (names.get(0).isEmpty() ? Util.join(".", names.subList(1, names.size())) : Util.join(".", names)).replace(".$", "$");
    }

    @Override
    public ClassName annotated(List<AnnotationSpec> annotations) {
        return new ClassName(this.names, this.concatAnnotations(annotations));
    }

    @Override
    public TypeName withoutAnnotations() {
        return new ClassName(this.names);
    }

    public String packageName() {
        return this.names.get(0);
    }

    public ClassName enclosingClassName() {
        if (this.names.size() == 2) {
            return null;
        }
        return new ClassName(this.names.subList(0, this.names.size() - 1));
    }

    public ClassName topLevelClassName() {
        return new ClassName(this.names.subList(0, 2));
    }

    public ClassName nestedClass(String name) {
        Util.checkNotNull(name, "name == null", new Object[0]);
        ArrayList<String> result = new ArrayList<String>(this.names.size() + 1);
        result.addAll(this.names);
        result.add(name);
        return new ClassName((List<String>)result);
    }

    public List<String> simpleNames() {
        return this.names.subList(1, this.names.size());
    }

    public String simpleName() {
        return this.names.get(this.names.size() - 1);
    }

    public static ClassName get(Class<?> clazz) {
        Util.checkNotNull(clazz, "clazz == null", new Object[0]);
        Util.checkArgument(!clazz.isPrimitive(), "primitive types cannot be represented as a ClassName", new Object[0]);
        Util.checkArgument(!Void.TYPE.equals(clazz), "'void' type cannot be represented as a ClassName", new Object[0]);
        Util.checkArgument(!clazz.isArray(), "array types cannot be represented as a ClassName", new Object[0]);
        ArrayList<String> names = new ArrayList<String>();
        while (true) {
            if (clazz.isAnonymousClass()) {
                int lastDot = clazz.getName().lastIndexOf(46);
                if (lastDot != -1) {
                    String anonClassName = clazz.getName().substring(lastDot + 1);
                    int lastDollar = anonClassName.lastIndexOf(36);
                    names.add(anonClassName.substring(lastDollar));
                }
            } else {
                names.add(clazz.getSimpleName());
            }
            Class<?> enclosing = clazz.getEnclosingClass();
            if (enclosing == null) break;
            clazz = enclosing;
        }
        int lastDot = clazz.getName().lastIndexOf(46);
        if (lastDot != -1) {
            names.add(clazz.getName().substring(0, lastDot));
        }
        Collections.reverse(names);
        return new ClassName((List<String>)names);
    }

    public static ClassName bestGuess(String classNameString) {
        ArrayList<String> names = new ArrayList<String>();
        int p = 0;
        while (p < classNameString.length() && Character.isLowerCase(classNameString.codePointAt(p))) {
            Util.checkArgument((p = classNameString.indexOf(46, p) + 1) != 0, "couldn't make a guess for %s", classNameString);
        }
        names.add(p != 0 ? classNameString.substring(0, p - 1) : "");
        for (String part : classNameString.substring(p).split("\\.", -1)) {
            Util.checkArgument(!part.isEmpty() && Character.isUpperCase(part.codePointAt(0)), "couldn't make a guess for %s", classNameString);
            names.add(part);
        }
        Util.checkArgument(names.size() >= 2, "couldn't make a guess for %s", classNameString);
        return new ClassName((List<String>)names);
    }

    public static ClassName get(String packageName, String simpleName, String ... simpleNames) {
        ArrayList<String> result = new ArrayList<String>();
        result.add(packageName);
        result.add(simpleName);
        Collections.addAll(result, simpleNames);
        return new ClassName((List<String>)result);
    }

    public static ClassName get(TypeElement element) {
        Util.checkNotNull(element, "element == null", new Object[0]);
        ArrayList<String> names = new ArrayList<String>();
        Element e = element;
        while (ClassName.isClassOrInterface(e)) {
            Util.checkArgument(element.getNestingKind() == NestingKind.TOP_LEVEL || element.getNestingKind() == NestingKind.MEMBER, "unexpected type testing", new Object[0]);
            names.add(e.getSimpleName().toString());
            e = e.getEnclosingElement();
        }
        names.add(ClassName.getPackage(element).getQualifiedName().toString());
        Collections.reverse(names);
        return new ClassName((List<String>)names);
    }

    private static boolean isClassOrInterface(Element e) {
        return e.getKind().isClass() || e.getKind().isInterface();
    }

    private static PackageElement getPackage(Element type) {
        while (type.getKind() != ElementKind.PACKAGE) {
            type = type.getEnclosingElement();
        }
        return (PackageElement)type;
    }

    @Override
    public int compareTo(ClassName o) {
        return this.canonicalName.compareTo(o.canonicalName);
    }

    @Override
    CodeWriter emit(CodeWriter out) throws IOException {
        return out.emitAndIndent(out.lookupName(this));
    }
}

