/*
 * Decompiled with CFR 0.152.
 */
package com.king.zxing;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.LinearGradient;
import android.graphics.Paint;
import android.graphics.Point;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.Shader;
import android.text.Layout;
import android.text.StaticLayout;
import android.text.TextPaint;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.View;
import androidx.annotation.ColorInt;
import androidx.annotation.ColorRes;
import androidx.annotation.Nullable;
import androidx.core.content.ContextCompat;
import com.king.zxing.R;

public class ViewfinderView
extends View {
    private static final int CURRENT_POINT_OPACITY = 160;
    private static final int MAX_RESULT_POINTS = 20;
    private static final int POINT_SIZE = 30;
    private Paint paint;
    private TextPaint textPaint;
    private int maskColor;
    private int frameColor;
    private int laserColor;
    private int cornerColor;
    private float labelTextPadding;
    private int labelTextWidth;
    private TextLocation labelTextLocation;
    private String labelText;
    private int labelTextColor;
    private float labelTextSize;
    public int scannerStart = 0;
    public int scannerEnd = 0;
    private int frameWidth;
    private int frameHeight;
    private LaserStyle laserStyle;
    private int gridColumn;
    private int gridHeight;
    private Rect frame;
    private int cornerRectWidth;
    private int cornerRectHeight;
    private int scannerLineMoveDistance;
    private int scannerLineHeight;
    private int frameLineWidth;
    private int scannerAnimationDelay;
    private float frameRatio;
    private float framePaddingLeft;
    private float framePaddingTop;
    private float framePaddingRight;
    private float framePaddingBottom;
    private FrameGravity frameGravity;
    private Point point;
    private int pointColor;
    private int pointStrokeColor;
    private float pointRadius;
    private float pointStrokeRatio = 1.2f;

    public ViewfinderView(Context context) {
        this(context, null);
    }

    public ViewfinderView(Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public ViewfinderView(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context, attrs);
    }

    private void init(Context context, AttributeSet attrs) {
        TypedArray array = context.obtainStyledAttributes(attrs, R.styleable.ViewfinderView);
        this.maskColor = array.getColor(R.styleable.ViewfinderView_maskColor, ContextCompat.getColor((Context)context, (int)R.color.viewfinder_mask));
        this.frameColor = array.getColor(R.styleable.ViewfinderView_frameColor, ContextCompat.getColor((Context)context, (int)R.color.viewfinder_frame));
        this.cornerColor = array.getColor(R.styleable.ViewfinderView_cornerColor, ContextCompat.getColor((Context)context, (int)R.color.viewfinder_corner));
        this.laserColor = array.getColor(R.styleable.ViewfinderView_laserColor, ContextCompat.getColor((Context)context, (int)R.color.viewfinder_laser));
        this.labelText = array.getString(R.styleable.ViewfinderView_labelText);
        this.labelTextColor = array.getColor(R.styleable.ViewfinderView_labelTextColor, ContextCompat.getColor((Context)context, (int)R.color.viewfinder_text_color));
        this.labelTextSize = array.getDimension(R.styleable.ViewfinderView_labelTextSize, TypedValue.applyDimension((int)2, (float)14.0f, (DisplayMetrics)this.getResources().getDisplayMetrics()));
        this.labelTextPadding = array.getDimension(R.styleable.ViewfinderView_labelTextPadding, TypedValue.applyDimension((int)1, (float)24.0f, (DisplayMetrics)this.getResources().getDisplayMetrics()));
        this.labelTextWidth = array.getDimensionPixelSize(R.styleable.ViewfinderView_labelTextWidth, 0);
        this.labelTextLocation = TextLocation.getFromInt(array.getInt(R.styleable.ViewfinderView_labelTextLocation, 0));
        this.frameWidth = array.getDimensionPixelSize(R.styleable.ViewfinderView_frameWidth, 0);
        this.frameHeight = array.getDimensionPixelSize(R.styleable.ViewfinderView_frameHeight, 0);
        this.laserStyle = LaserStyle.getFromInt(array.getInt(R.styleable.ViewfinderView_laserStyle, LaserStyle.LINE.mValue));
        this.gridColumn = array.getInt(R.styleable.ViewfinderView_gridColumn, 20);
        this.gridHeight = (int)array.getDimension(R.styleable.ViewfinderView_gridHeight, TypedValue.applyDimension((int)1, (float)40.0f, (DisplayMetrics)this.getResources().getDisplayMetrics()));
        this.cornerRectWidth = (int)array.getDimension(R.styleable.ViewfinderView_cornerRectWidth, TypedValue.applyDimension((int)1, (float)4.0f, (DisplayMetrics)this.getResources().getDisplayMetrics()));
        this.cornerRectHeight = (int)array.getDimension(R.styleable.ViewfinderView_cornerRectHeight, TypedValue.applyDimension((int)1, (float)16.0f, (DisplayMetrics)this.getResources().getDisplayMetrics()));
        this.scannerLineMoveDistance = (int)array.getDimension(R.styleable.ViewfinderView_scannerLineMoveDistance, TypedValue.applyDimension((int)1, (float)2.0f, (DisplayMetrics)this.getResources().getDisplayMetrics()));
        this.scannerLineHeight = (int)array.getDimension(R.styleable.ViewfinderView_scannerLineHeight, TypedValue.applyDimension((int)1, (float)5.0f, (DisplayMetrics)this.getResources().getDisplayMetrics()));
        this.frameLineWidth = (int)array.getDimension(R.styleable.ViewfinderView_frameLineWidth, TypedValue.applyDimension((int)1, (float)1.0f, (DisplayMetrics)this.getResources().getDisplayMetrics()));
        this.scannerAnimationDelay = array.getInteger(R.styleable.ViewfinderView_scannerAnimationDelay, 20);
        this.frameRatio = array.getFloat(R.styleable.ViewfinderView_frameRatio, 0.625f);
        this.framePaddingLeft = array.getDimension(R.styleable.ViewfinderView_framePaddingLeft, 0.0f);
        this.framePaddingTop = array.getDimension(R.styleable.ViewfinderView_framePaddingTop, 0.0f);
        this.framePaddingRight = array.getDimension(R.styleable.ViewfinderView_framePaddingRight, 0.0f);
        this.framePaddingBottom = array.getDimension(R.styleable.ViewfinderView_framePaddingBottom, 0.0f);
        this.frameGravity = FrameGravity.getFromInt(array.getInt(R.styleable.ViewfinderView_frameGravity, FrameGravity.CENTER.mValue));
        array.recycle();
        this.pointColor = this.laserColor;
        this.pointStrokeColor = -1;
        this.pointRadius = TypedValue.applyDimension((int)1, (float)10.0f, (DisplayMetrics)this.getResources().getDisplayMetrics());
        this.paint = new Paint(1);
        this.textPaint = new TextPaint(1);
    }

    private DisplayMetrics getDisplayMetrics() {
        return this.getResources().getDisplayMetrics();
    }

    public void setLabelText(String labelText) {
        this.labelText = labelText;
    }

    public void setLabelTextColor(@ColorInt int color2) {
        this.labelTextColor = color2;
    }

    public void setLabelTextColorResource(@ColorRes int id2) {
        this.labelTextColor = ContextCompat.getColor((Context)this.getContext(), (int)id2);
    }

    public void setLabelTextSize(float textSize) {
        this.labelTextSize = textSize;
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
        this.initFrame(w, h);
    }

    private void initFrame(int width, int height) {
        int size = (int)((float)Math.min(width, height) * this.frameRatio);
        if (this.frameWidth <= 0 || this.frameWidth > width) {
            this.frameWidth = size;
        }
        if (this.frameHeight <= 0 || this.frameHeight > height) {
            this.frameHeight = size;
        }
        if (this.labelTextWidth <= 0) {
            this.labelTextWidth = width - this.getPaddingLeft() - this.getPaddingRight();
        }
        float leftOffsets = (float)((width - this.frameWidth) / 2) + this.framePaddingLeft - this.framePaddingRight;
        float topOffsets = (float)((height - this.frameHeight) / 2) + this.framePaddingTop - this.framePaddingBottom;
        switch (this.frameGravity) {
            case LEFT: {
                leftOffsets = this.framePaddingLeft;
                break;
            }
            case TOP: {
                topOffsets = this.framePaddingTop;
                break;
            }
            case RIGHT: {
                leftOffsets = (float)(width - this.frameWidth) + this.framePaddingRight;
                break;
            }
            case BOTTOM: {
                topOffsets = (float)(height - this.frameHeight) + this.framePaddingBottom;
            }
        }
        this.frame = new Rect((int)leftOffsets, (int)topOffsets, (int)leftOffsets + this.frameWidth, (int)topOffsets + this.frameHeight);
    }

    public void onDraw(Canvas canvas) {
        if (this.frame == null) {
            return;
        }
        if (this.scannerStart == 0 || this.scannerEnd == 0) {
            this.scannerStart = this.frame.top;
            this.scannerEnd = this.frame.bottom - this.scannerLineHeight;
        }
        int width = canvas.getWidth();
        int height = canvas.getHeight();
        this.drawExterior(canvas, this.frame, width, height);
        this.drawLaserScanner(canvas, this.frame);
        this.drawFrame(canvas, this.frame);
        this.drawCorner(canvas, this.frame);
        this.drawTextInfo(canvas, this.frame);
        this.postInvalidateDelayed(this.scannerAnimationDelay, this.frame.left, this.frame.top, this.frame.right, this.frame.bottom);
    }

    private void drawTextInfo(Canvas canvas, Rect frame) {
        if (!TextUtils.isEmpty((CharSequence)this.labelText)) {
            this.textPaint.setColor(this.labelTextColor);
            this.textPaint.setTextSize(this.labelTextSize);
            this.textPaint.setTextAlign(Paint.Align.CENTER);
            StaticLayout staticLayout = new StaticLayout((CharSequence)this.labelText, this.textPaint, this.labelTextWidth, Layout.Alignment.ALIGN_NORMAL, 1.2f, 0.0f, true);
            if (this.labelTextLocation == TextLocation.BOTTOM) {
                canvas.translate((float)(frame.left + frame.width() / 2), (float)frame.bottom + this.labelTextPadding);
            } else {
                canvas.translate((float)(frame.left + frame.width() / 2), (float)frame.top - this.labelTextPadding - (float)staticLayout.getHeight());
            }
            staticLayout.draw(canvas);
        }
    }

    private void drawCorner(Canvas canvas, Rect frame) {
        this.paint.setColor(this.cornerColor);
        canvas.drawRect((float)frame.left, (float)frame.top, (float)(frame.left + this.cornerRectWidth), (float)(frame.top + this.cornerRectHeight), this.paint);
        canvas.drawRect((float)frame.left, (float)frame.top, (float)(frame.left + this.cornerRectHeight), (float)(frame.top + this.cornerRectWidth), this.paint);
        canvas.drawRect((float)(frame.right - this.cornerRectWidth), (float)frame.top, (float)frame.right, (float)(frame.top + this.cornerRectHeight), this.paint);
        canvas.drawRect((float)(frame.right - this.cornerRectHeight), (float)frame.top, (float)frame.right, (float)(frame.top + this.cornerRectWidth), this.paint);
        canvas.drawRect((float)frame.left, (float)(frame.bottom - this.cornerRectWidth), (float)(frame.left + this.cornerRectHeight), (float)frame.bottom, this.paint);
        canvas.drawRect((float)frame.left, (float)(frame.bottom - this.cornerRectHeight), (float)(frame.left + this.cornerRectWidth), (float)frame.bottom, this.paint);
        canvas.drawRect((float)(frame.right - this.cornerRectWidth), (float)(frame.bottom - this.cornerRectHeight), (float)frame.right, (float)frame.bottom, this.paint);
        canvas.drawRect((float)(frame.right - this.cornerRectHeight), (float)(frame.bottom - this.cornerRectWidth), (float)frame.right, (float)frame.bottom, this.paint);
    }

    private void drawLaserScanner(Canvas canvas, Rect frame) {
        if (this.laserStyle != null) {
            this.paint.setColor(this.laserColor);
            switch (this.laserStyle) {
                case LINE: {
                    this.drawLineScanner(canvas, frame);
                    break;
                }
                case GRID: {
                    this.drawGridScanner(canvas, frame);
                }
            }
            this.paint.setShader(null);
        }
    }

    private void drawLineScanner(Canvas canvas, Rect frame) {
        LinearGradient linearGradient = new LinearGradient((float)frame.left, (float)this.scannerStart, (float)frame.left, (float)(this.scannerStart + this.scannerLineHeight), this.shadeColor(this.laserColor), this.laserColor, Shader.TileMode.MIRROR);
        this.paint.setShader((Shader)linearGradient);
        if (this.scannerStart <= this.scannerEnd) {
            RectF rectF = new RectF((float)(frame.left + 2 * this.scannerLineHeight), (float)this.scannerStart, (float)(frame.right - 2 * this.scannerLineHeight), (float)(this.scannerStart + this.scannerLineHeight));
            canvas.drawOval(rectF, this.paint);
            this.scannerStart += this.scannerLineMoveDistance;
        } else {
            this.scannerStart = frame.top;
        }
    }

    private void drawGridScanner(Canvas canvas, Rect frame) {
        float wUnit;
        int stroke = 2;
        this.paint.setStrokeWidth((float)stroke);
        int startY = this.gridHeight > 0 && this.scannerStart - frame.top > this.gridHeight ? this.scannerStart - this.gridHeight : frame.top;
        LinearGradient linearGradient = new LinearGradient((float)(frame.left + frame.width() / 2), (float)startY, (float)(frame.left + frame.width() / 2), (float)this.scannerStart, new int[]{this.shadeColor(this.laserColor), this.laserColor}, new float[]{0.0f, 1.0f}, Shader.TileMode.CLAMP);
        this.paint.setShader((Shader)linearGradient);
        float hUnit = wUnit = (float)frame.width() * 1.0f / (float)this.gridColumn;
        for (int i = 1; i < this.gridColumn; ++i) {
            canvas.drawLine((float)frame.left + (float)i * wUnit, (float)startY, (float)frame.left + (float)i * wUnit, (float)this.scannerStart, this.paint);
        }
        int height = this.gridHeight > 0 && this.scannerStart - frame.top > this.gridHeight ? this.gridHeight : this.scannerStart - frame.top;
        int i = 0;
        while ((float)i <= (float)height / hUnit) {
            canvas.drawLine((float)frame.left, (float)this.scannerStart - (float)i * hUnit, (float)frame.right, (float)this.scannerStart - (float)i * hUnit, this.paint);
            ++i;
        }
        this.scannerStart = this.scannerStart < this.scannerEnd ? (this.scannerStart += this.scannerLineMoveDistance) : frame.top;
    }

    public int shadeColor(int color2) {
        String hax = Integer.toHexString(color2);
        String result = "01" + hax.substring(2);
        return Integer.valueOf(result, 16);
    }

    private void drawFrame(Canvas canvas, Rect frame) {
        this.paint.setColor(this.frameColor);
        canvas.drawRect((float)frame.left, (float)frame.top, (float)frame.right, (float)(frame.top + this.frameLineWidth), this.paint);
        canvas.drawRect((float)frame.left, (float)frame.top, (float)(frame.left + this.frameLineWidth), (float)frame.bottom, this.paint);
        canvas.drawRect((float)(frame.right - this.frameLineWidth), (float)frame.top, (float)frame.right, (float)frame.bottom, this.paint);
        canvas.drawRect((float)frame.left, (float)(frame.bottom - this.frameLineWidth), (float)frame.right, (float)frame.bottom, this.paint);
    }

    private void drawExterior(Canvas canvas, Rect frame, int width, int height) {
        if (this.maskColor != 0) {
            this.paint.setColor(this.maskColor);
            canvas.drawRect(0.0f, 0.0f, (float)width, (float)frame.top, this.paint);
            canvas.drawRect(0.0f, (float)frame.top, (float)frame.left, (float)frame.bottom, this.paint);
            canvas.drawRect((float)frame.right, (float)frame.top, (float)width, (float)frame.bottom, this.paint);
            canvas.drawRect(0.0f, (float)frame.bottom, (float)width, (float)height, this.paint);
        }
    }

    public void drawViewfinder() {
        this.invalidate();
    }

    public void setLaserStyle(LaserStyle laserStyle) {
        this.laserStyle = laserStyle;
    }

    public static enum FrameGravity {
        CENTER(0),
        LEFT(1),
        TOP(2),
        RIGHT(3),
        BOTTOM(4);

        private int mValue;

        private FrameGravity(int value) {
            this.mValue = value;
        }

        private static FrameGravity getFromInt(int value) {
            for (FrameGravity gravity : FrameGravity.values()) {
                if (gravity.mValue != value) continue;
                return gravity;
            }
            return CENTER;
        }
    }

    public static enum TextLocation {
        TOP(0),
        BOTTOM(1);

        private int mValue;

        private TextLocation(int value) {
            this.mValue = value;
        }

        private static TextLocation getFromInt(int value) {
            for (TextLocation location : TextLocation.values()) {
                if (location.mValue != value) continue;
                return location;
            }
            return TOP;
        }
    }

    public static enum LaserStyle {
        NONE(0),
        LINE(1),
        GRID(2);

        private int mValue;

        private LaserStyle(int value) {
            this.mValue = value;
        }

        private static LaserStyle getFromInt(int value) {
            for (LaserStyle style : LaserStyle.values()) {
                if (style.mValue != value) continue;
                return style;
            }
            return LINE;
        }
    }
}

