/*
 * Decompiled with CFR 0.152.
 */
package com.king.zxing.analyze;

import android.graphics.Rect;
import androidx.annotation.Nullable;
import com.google.zxing.DecodeHintType;
import com.google.zxing.Result;
import com.king.zxing.DecodeConfig;
import com.king.zxing.DecodeFormatManager;
import com.king.zxing.analyze.ImageAnalyzer;
import java.util.Map;

public abstract class AreaRectAnalyzer
extends ImageAnalyzer {
    DecodeConfig mDecodeConfig;
    Map<DecodeHintType, ?> mHints;
    boolean isMultiDecode = true;
    private float mAreaRectRatio = 0.8f;
    private int mAreaRectHorizontalOffset = 0;
    private int mAreaRectVerticalOffset = 0;

    public AreaRectAnalyzer(@Nullable DecodeConfig config) {
        this.mDecodeConfig = config;
        if (config != null) {
            this.mHints = config.getHints();
            this.isMultiDecode = config.isMultiDecode();
            this.mAreaRectRatio = config.getAreaRectRatio();
            this.mAreaRectHorizontalOffset = config.getAreaRectHorizontalOffset();
            this.mAreaRectVerticalOffset = config.getAreaRectVerticalOffset();
        } else {
            this.mHints = DecodeFormatManager.DEFAULT_HINTS;
        }
    }

    @Override
    @Nullable
    public Result analyze(byte[] data, int width, int height) {
        if (this.mDecodeConfig != null) {
            if (this.mDecodeConfig.isFullAreaScan()) {
                return this.analyze(data, width, height, 0, 0, width, height);
            }
            Rect rect = this.mDecodeConfig.getAnalyzeAreaRect();
            if (rect != null) {
                return this.analyze(data, width, height, rect.left, rect.top, rect.width(), rect.height());
            }
        }
        int size = (int)((float)Math.min(width, height) * this.mAreaRectRatio);
        int left = (width - size) / 2 + this.mAreaRectHorizontalOffset;
        int top = (height - size) / 2 + this.mAreaRectVerticalOffset;
        return this.analyze(data, width, height, left, top, size, size);
    }

    @Nullable
    public abstract Result analyze(byte[] var1, int var2, int var3, int var4, int var5, int var6, int var7);
}

