/*
 * Decompiled with CFR 0.152.
 */
package com.king.zxing.analyze;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.camera.core.ImageProxy;
import com.google.zxing.Result;
import com.king.zxing.analyze.Analyzer;
import com.king.zxing.util.LogUtils;
import java.nio.ByteBuffer;

public abstract class ImageAnalyzer
implements Analyzer {
    @Nullable
    public abstract Result analyze(byte[] var1, int var2, int var3);

    @Override
    public Result analyze(@NonNull ImageProxy image, int orientation) {
        if (image.getFormat() == 35) {
            ByteBuffer buffer = image.getPlanes()[0].getBuffer();
            byte[] data = new byte[buffer.remaining()];
            buffer.get(data);
            int width = image.getWidth();
            int height = image.getHeight();
            if (orientation == 1) {
                byte[] rotatedData = new byte[data.length];
                for (int y = 0; y < height; ++y) {
                    for (int x = 0; x < width; ++x) {
                        rotatedData[x * height + height - y - 1] = data[x + y * width];
                    }
                }
                return this.analyze(rotatedData, height, width);
            }
            return this.analyze(data, width, height);
        }
        LogUtils.w("imageFormat: " + image.getFormat());
        return null;
    }
}

