/*
 * Decompiled with CFR 0.152.
 */
package com.king.zxing.config;

import android.content.Context;
import android.util.DisplayMetrics;
import android.util.Size;
import androidx.annotation.NonNull;
import androidx.camera.core.CameraSelector;
import androidx.camera.core.ImageAnalysis;
import androidx.camera.core.Preview;
import com.king.zxing.config.CameraConfig;
import com.king.zxing.util.LogUtils;

public class ResolutionCameraConfig
extends CameraConfig {
    private Size mTargetSize;

    public ResolutionCameraConfig(Context context) {
        DisplayMetrics displayMetrics = context.getResources().getDisplayMetrics();
        int width = displayMetrics.widthPixels;
        int height = displayMetrics.heightPixels;
        LogUtils.d(String.format("displayMetrics:%d x %d", width, height));
        if (width < height) {
            int size = Math.min(width, 1080);
            float ratio = (float)width / (float)height;
            this.mTargetSize = (double)ratio > 0.7 ? new Size(size, (int)((float)size / 3.0f * 4.0f)) : new Size(size, (int)((float)size / 9.0f * 16.0f));
        } else {
            int size = Math.min(height, 1080);
            float ratio = (float)height / (float)width;
            this.mTargetSize = (double)ratio > 0.7 ? new Size((int)((float)size / 3.0f * 4.0f), size) : new Size((int)((double)((float)size / 9.0f) * 16.0), size);
        }
        LogUtils.d("targetSize:" + this.mTargetSize);
    }

    @Override
    @NonNull
    public Preview options(@NonNull Preview.Builder builder) {
        return super.options(builder);
    }

    @Override
    @NonNull
    public CameraSelector options(@NonNull CameraSelector.Builder builder) {
        return super.options(builder);
    }

    @Override
    @NonNull
    public ImageAnalysis options(@NonNull ImageAnalysis.Builder builder) {
        builder.setTargetResolution(this.mTargetSize);
        return super.options(builder);
    }
}

