/*
 * Decompiled with CFR 0.152.
 */
package com.github.mjdev.libaums.driver.scsi;

import android.util.Log;
import com.github.mjdev.libaums.driver.BlockDeviceDriver;
import com.github.mjdev.libaums.driver.scsi.commands.CommandBlockWrapper;
import com.github.mjdev.libaums.driver.scsi.commands.CommandStatusWrapper;
import com.github.mjdev.libaums.driver.scsi.commands.ScsiInquiry;
import com.github.mjdev.libaums.driver.scsi.commands.ScsiInquiryResponse;
import com.github.mjdev.libaums.driver.scsi.commands.ScsiRead10;
import com.github.mjdev.libaums.driver.scsi.commands.ScsiReadCapacity;
import com.github.mjdev.libaums.driver.scsi.commands.ScsiReadCapacityResponse;
import com.github.mjdev.libaums.driver.scsi.commands.ScsiTestUnitReady;
import com.github.mjdev.libaums.driver.scsi.commands.ScsiWrite10;
import com.github.mjdev.libaums.usb.UsbCommunication;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Arrays;

public class ScsiBlockDevice
implements BlockDeviceDriver {
    private static final String TAG = ScsiBlockDevice.class.getSimpleName();
    private UsbCommunication usbCommunication;
    private ByteBuffer outBuffer;
    private ByteBuffer cswBuffer;
    private int blockSize;
    private int lastBlockAddress;
    private ScsiWrite10 writeCommand = new ScsiWrite10();
    private ScsiRead10 readCommand = new ScsiRead10();
    private CommandStatusWrapper csw = new CommandStatusWrapper();

    public ScsiBlockDevice(UsbCommunication usbCommunication) {
        this.usbCommunication = usbCommunication;
        this.outBuffer = ByteBuffer.allocate(31);
        this.cswBuffer = ByteBuffer.allocate(13);
    }

    @Override
    public void init() throws IOException {
        ByteBuffer inBuffer = ByteBuffer.allocate(36);
        ScsiInquiry inquiry = new ScsiInquiry((byte)inBuffer.array().length);
        this.transferCommand(inquiry, inBuffer);
        inBuffer.clear();
        ScsiInquiryResponse inquiryResponse = ScsiInquiryResponse.read(inBuffer);
        Log.d((String)TAG, (String)("inquiry response: " + inquiryResponse));
        if (inquiryResponse.getPeripheralQualifier() != 0 || inquiryResponse.getPeripheralDeviceType() != 0) {
            throw new IOException("unsupported PeripheralQualifier or PeripheralDeviceType");
        }
        ScsiTestUnitReady testUnit = new ScsiTestUnitReady();
        if (!this.transferCommand(testUnit, null)) {
            Log.w((String)TAG, (String)"unit not ready!");
        }
        ScsiReadCapacity readCapacity = new ScsiReadCapacity();
        inBuffer.clear();
        this.transferCommand(readCapacity, inBuffer);
        inBuffer.clear();
        ScsiReadCapacityResponse readCapacityResponse = ScsiReadCapacityResponse.read(inBuffer);
        this.blockSize = readCapacityResponse.getBlockLength();
        this.lastBlockAddress = readCapacityResponse.getLogicalBlockAddress();
        Log.i((String)TAG, (String)("Block size: " + this.blockSize));
        Log.i((String)TAG, (String)("Last block address: " + this.lastBlockAddress));
    }

    private boolean transferCommand(CommandBlockWrapper command, ByteBuffer inBuffer) throws IOException {
        byte[] outArray = this.outBuffer.array();
        Arrays.fill(outArray, (byte)0);
        this.outBuffer.clear();
        command.serialize(this.outBuffer);
        this.outBuffer.clear();
        int written = this.usbCommunication.bulkOutTransfer(this.outBuffer);
        if (written != outArray.length) {
            throw new IOException("Writing all bytes on command " + command + " failed!");
        }
        int transferLength = command.getdCbwDataTransferLength();
        int read = 0;
        if (transferLength > 0) {
            if (command.getDirection() == CommandBlockWrapper.Direction.IN) {
                while ((read += this.usbCommunication.bulkInTransfer(inBuffer)) < transferLength) {
                }
                if (read != transferLength) {
                    throw new IOException("Unexpected command size (" + read + ") on response to " + command);
                }
            } else {
                written = 0;
                while ((written += this.usbCommunication.bulkOutTransfer(inBuffer)) < transferLength) {
                }
                if (written != transferLength) {
                    throw new IOException("Could not write all bytes: " + command);
                }
            }
        }
        this.cswBuffer.clear();
        read = this.usbCommunication.bulkInTransfer(this.cswBuffer);
        if (read != 13) {
            throw new IOException("Unexpected command size while expecting csw");
        }
        this.cswBuffer.clear();
        this.csw.read(this.cswBuffer);
        if (this.csw.getbCswStatus() != 0) {
            throw new IOException("Unsuccessful Csw status: " + this.csw.getbCswStatus());
        }
        if (this.csw.getdCswTag() != command.getdCbwTag()) {
            throw new IOException("wrong csw tag!");
        }
        return this.csw.getbCswStatus() == 0;
    }

    @Override
    public synchronized void read(long devOffset, ByteBuffer dest) throws IOException {
        if (dest.remaining() % this.blockSize != 0) {
            throw new IllegalArgumentException("dest.remaining() must be multiple of blockSize!");
        }
        this.readCommand.init((int)devOffset, dest.remaining(), this.blockSize);
        this.transferCommand(this.readCommand, dest);
        dest.position(dest.limit());
    }

    @Override
    public synchronized void write(long devOffset, ByteBuffer src) throws IOException {
        if (src.remaining() % this.blockSize != 0) {
            throw new IllegalArgumentException("src.remaining() must be multiple of blockSize!");
        }
        this.writeCommand.init((int)devOffset, src.remaining(), this.blockSize);
        this.transferCommand(this.writeCommand, src);
        src.position(src.limit());
    }

    @Override
    public int getBlockSize() {
        return this.blockSize;
    }
}

