/*
 * Decompiled with CFR 0.152.
 */
package com.github.mjdev.libaums.fs.fat32;

import com.github.mjdev.libaums.fs.fat32.ShortName;
import java.util.Collection;
import java.util.Locale;

class ShortNameGenerator {
    ShortNameGenerator() {
    }

    private static boolean isValidChar(char c) {
        if (c >= '0' && c <= '9') {
            return true;
        }
        if (c >= 'A' && c <= 'Z') {
            return true;
        }
        return c == '$' || c == '%' || c == '\'' || c == '-' || c == '_' || c == '@' || c == '~' || c == '`' || c == '!' || c == '(' || c == ')' || c == '{' || c == '}' || c == '^' || c == '#' || c == '&';
    }

    private static boolean containsInvalidChars(String str) {
        int length = str.length();
        for (int i = 0; i < length; ++i) {
            char c = str.charAt(i);
            if (ShortNameGenerator.isValidChar(c)) continue;
            return true;
        }
        return false;
    }

    private static String replaceInvalidChars(String str) {
        int length = str.length();
        StringBuilder builder = new StringBuilder(length);
        for (int i = 0; i < length; ++i) {
            char c = str.charAt(i);
            if (ShortNameGenerator.isValidChar(c)) {
                builder.append(c);
                continue;
            }
            builder.append("_");
        }
        return builder.toString();
    }

    static String getNextHexPart(String hexPart, int limit) {
        String tempHexString;
        long hexValue = Long.parseLong(hexPart, 16);
        if ((tempHexString = Long.toHexString(++hexValue)).length() <= limit) {
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < limit - tempHexString.length(); ++i) {
                sb.append("0");
            }
            return sb.toString() + tempHexString;
        }
        return null;
    }

    static ShortName generateShortName(String lfnName, Collection<ShortName> existingShortNames) {
        int i;
        lfnName = lfnName.toUpperCase(Locale.ROOT).trim();
        for (i = 0; i < lfnName.length() && lfnName.charAt(i) == '.'; ++i) {
        }
        lfnName = lfnName.substring(i);
        lfnName = lfnName.replace(" ", "");
        String filenamePart = "";
        String extensionPart = "";
        int indexOfDot = lfnName.lastIndexOf(".");
        if (indexOfDot == -1) {
            filenamePart = lfnName;
            extensionPart = "";
        } else {
            filenamePart = lfnName.substring(0, indexOfDot);
            extensionPart = lfnName.substring(indexOfDot + 1);
            if (extensionPart.length() > 3) {
                extensionPart = extensionPart.substring(0, 3);
            }
        }
        if (ShortNameGenerator.containsInvalidChars(filenamePart)) {
            filenamePart = ShortNameGenerator.replaceInvalidChars(filenamePart);
        }
        if (ShortNameGenerator.containsInvalidChars(extensionPart)) {
            extensionPart = ShortNameGenerator.replaceInvalidChars(extensionPart);
        }
        String filePrefix = filenamePart;
        if (filenamePart.length() == 0) {
            filePrefix = "__";
        } else if (filenamePart.length() == 1) {
            filePrefix = filePrefix + "_";
        } else if (filenamePart.length() != 2 && filenamePart.length() > 2) {
            filePrefix = filenamePart.substring(0, 2);
        }
        String extSuffix = extensionPart;
        if (extensionPart.length() == 0) {
            extSuffix = "000";
        } else if (extensionPart.length() == 1) {
            extSuffix = extensionPart + "00";
        } else if (extensionPart.length() == 2) {
            extSuffix = extensionPart + "0";
        }
        String hexPart = "0000";
        int tildeDigit = 0;
        ShortName result = new ShortName(filePrefix + hexPart + "~" + tildeDigit, extSuffix);
        while (ShortNameGenerator.containShortName(existingShortNames, result)) {
            if (ShortNameGenerator.getNextHexPart(hexPart, 4) != null) {
                hexPart = ShortNameGenerator.getNextHexPart(hexPart, 4);
            } else {
                if (tildeDigit + 1 >= 10) break;
                ++tildeDigit;
                hexPart = "0000";
            }
            result = new ShortName(filePrefix + hexPart + "~" + tildeDigit, extSuffix);
        }
        return result;
    }

    public static boolean containShortName(Collection<ShortName> shortNames, ShortName shortName) {
        boolean contain = false;
        for (ShortName temp : shortNames) {
            if (!temp.getString().equalsIgnoreCase(shortName.getString())) continue;
            contain = true;
            break;
        }
        return contain;
    }
}

