/*
 * Decompiled with CFR 0.152.
 */
package com.github.mjdev.libaums.partition.mbr;

import android.util.Log;
import com.github.mjdev.libaums.partition.PartitionTable;
import com.github.mjdev.libaums.partition.PartitionTableEntry;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class MasterBootRecord
implements PartitionTable {
    private static Map<Integer, Integer> partitionTypes = new HashMap<Integer, Integer>(){
        {
            this.put(11, 2);
            this.put(12, 2);
            this.put(27, 2);
            this.put(28, 2);
            this.put(1, 0);
            this.put(4, 1);
            this.put(6, 1);
            this.put(14, 1);
            this.put(131, 3);
            this.put(7, 6);
            this.put(175, 4);
        }
    };
    private static final String TAG = MasterBootRecord.class.getSimpleName();
    private static final int TABLE_OFFSET = 446;
    private static final int TABLE_ENTRY_SIZE = 16;
    public List<PartitionTableEntry> partitions = new ArrayList<PartitionTableEntry>();

    private MasterBootRecord() {
    }

    public static MasterBootRecord read(ByteBuffer buffer) {
        MasterBootRecord result = new MasterBootRecord();
        buffer.order(ByteOrder.LITTLE_ENDIAN);
        if (buffer.get(510) != 85 || buffer.get(511) != -86) {
            Log.i((String)TAG, (String)"not a valid mbr partition table!");
            return null;
        }
        for (int i = 0; i < 4; ++i) {
            int offset = 446 + i * 16;
            byte partitionType = buffer.get(offset + 4);
            if (partitionType == 0) continue;
            if (partitionType == 5 || partitionType == 15) {
                Log.w((String)TAG, (String)"extended partitions are currently unsupported!");
                continue;
            }
            Integer type = partitionTypes.get(partitionType);
            if (type == null) {
                type = -1;
            }
            PartitionTableEntry entry = new PartitionTableEntry(type, buffer.getInt(offset + 8), buffer.getInt(offset + 12));
            result.partitions.add(entry);
        }
        return result;
    }

    @Override
    public int getSize() {
        return 512;
    }

    @Override
    public Collection<PartitionTableEntry> getPartitionTableEntries() {
        return this.partitions;
    }
}

