/*
 * Decompiled with CFR 0.152.
 */
package com.github.mjdev.libaums.usb;

import android.annotation.TargetApi;
import android.hardware.usb.UsbDeviceConnection;
import android.hardware.usb.UsbEndpoint;
import com.github.mjdev.libaums.ErrNo;
import com.github.mjdev.libaums.usb.UsbCommunication;
import java.io.IOException;
import java.nio.ByteBuffer;

@TargetApi(value=18)
class JellyBeanMr2Communication
implements UsbCommunication {
    private UsbDeviceConnection deviceConnection;
    private UsbEndpoint outEndpoint;
    private UsbEndpoint inEndpoint;

    JellyBeanMr2Communication(UsbDeviceConnection deviceConnection, UsbEndpoint outEndpoint, UsbEndpoint inEndpoint) {
        this.deviceConnection = deviceConnection;
        this.outEndpoint = outEndpoint;
        this.inEndpoint = inEndpoint;
    }

    @Override
    public int bulkOutTransfer(ByteBuffer src) throws IOException {
        int result = this.deviceConnection.bulkTransfer(this.outEndpoint, src.array(), src.position(), src.remaining(), 5000);
        if (result == -1) {
            throw new IOException("Could not write to device, result == -1 errno " + ErrNo.getErrno() + " " + ErrNo.getErrstr());
        }
        src.position(src.position() + result);
        return result;
    }

    @Override
    public int bulkInTransfer(ByteBuffer dest) throws IOException {
        int result = this.deviceConnection.bulkTransfer(this.inEndpoint, dest.array(), dest.position(), dest.remaining(), 5000);
        if (result == -1) {
            throw new IOException("Could not read from device, result == -1 errno " + ErrNo.getErrno() + " " + ErrNo.getErrstr());
        }
        dest.position(dest.position() + result);
        return result;
    }
}

