/*
 * Decompiled with CFR 0.152.
 */
package github.nisrulz.easydeviceinfo.base;

import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.util.Log;
import github.nisrulz.easydeviceinfo.base.CheckValidityUtil;
import github.nisrulz.easydeviceinfo.common.EasyDeviceInfo;

public class EasyAppMod {
    private static final String NAME_NOT_FOUND_EXCEPTION = "Name Not Found Exception";
    private final Context context;

    public EasyAppMod(Context context) {
        this.context = context;
    }

    public final String getActivityName() {
        return CheckValidityUtil.checkValidData(this.context.getClass().getSimpleName());
    }

    public final String getPackageName() {
        return CheckValidityUtil.checkValidData(this.context.getPackageName());
    }

    public final String getStore() {
        String result = this.context.getPackageManager().getInstallerPackageName(this.context.getPackageName());
        return CheckValidityUtil.checkValidData(result);
    }

    public final String getAppName() {
        ApplicationInfo ai;
        PackageManager pm;
        block2: {
            pm = this.context.getPackageManager();
            ai = null;
            try {
                ai = pm.getApplicationInfo(this.context.getPackageName(), 0);
            }
            catch (PackageManager.NameNotFoundException e) {
                if (!EasyDeviceInfo.debuggable) break block2;
                Log.d((String)"EasyDeviceInfo", (String)NAME_NOT_FOUND_EXCEPTION, (Throwable)e);
            }
        }
        String result = ai != null ? (String)pm.getApplicationLabel(ai) : null;
        return CheckValidityUtil.checkValidData(result);
    }

    public final String getAppVersion() {
        String result;
        block2: {
            result = null;
            try {
                result = this.context.getPackageManager().getPackageInfo((String)this.context.getPackageName(), (int)0).versionName;
            }
            catch (PackageManager.NameNotFoundException e) {
                if (!EasyDeviceInfo.debuggable) break block2;
                Log.e((String)"EasyDeviceInfo", (String)NAME_NOT_FOUND_EXCEPTION, (Throwable)e);
            }
        }
        return CheckValidityUtil.checkValidData(result);
    }

    public final String getAppVersionCode() {
        String result;
        block2: {
            result = null;
            try {
                result = String.valueOf(this.context.getPackageManager().getPackageInfo((String)this.context.getPackageName(), (int)0).versionCode);
            }
            catch (PackageManager.NameNotFoundException e) {
                if (!EasyDeviceInfo.debuggable) break block2;
                Log.e((String)"EasyDeviceInfo", (String)NAME_NOT_FOUND_EXCEPTION, (Throwable)e);
            }
        }
        return CheckValidityUtil.checkValidData(result);
    }

    public final boolean isPermissionGranted(String permission) {
        return this.context.checkCallingPermission(permission) == 0;
    }

    public final boolean isAppInstalled(String packageName) {
        return this.context.getPackageManager().getLaunchIntentForPackage(packageName) != null;
    }
}

