/*
 * Decompiled with CFR 0.152.
 */
package github.nisrulz.easydeviceinfo.base;

import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import github.nisrulz.easydeviceinfo.base.BatteryHealth;
import github.nisrulz.easydeviceinfo.base.ChargingVia;
import github.nisrulz.easydeviceinfo.base.CheckValidityUtil;

@BatteryHealth
public class EasyBatteryMod {
    private final Context context;

    public EasyBatteryMod(Context context) {
        this.context = context;
    }

    public final int getBatteryPercentage() {
        int percentage = 0;
        Intent batteryStatus = this.getBatteryStatusIntent();
        if (batteryStatus != null) {
            int level = batteryStatus.getIntExtra("level", -1);
            int scale = batteryStatus.getIntExtra("scale", -1);
            percentage = (int)((float)level / (float)scale * 100.0f);
        }
        return percentage;
    }

    private Intent getBatteryStatusIntent() {
        IntentFilter batFilter = new IntentFilter("android.intent.action.BATTERY_CHANGED");
        return this.context.registerReceiver(null, batFilter);
    }

    public final boolean isDeviceCharging() {
        Intent batteryStatus = this.getBatteryStatusIntent();
        int status = batteryStatus.getIntExtra("status", -1);
        return status == 2 || status == 5;
    }

    @BatteryHealth
    public final int getBatteryHealth() {
        int health = 0;
        Intent batteryStatus = this.getBatteryStatusIntent();
        if (batteryStatus != null) {
            health = batteryStatus.getIntExtra("health", 0);
            health = health == 2 ? 1 : 0;
        }
        return health;
    }

    public final String getBatteryTechnology() {
        return CheckValidityUtil.checkValidData(this.getBatteryStatusIntent().getStringExtra("technology"));
    }

    public final float getBatteryTemperature() {
        float temp = 0.0f;
        Intent batteryStatus = this.getBatteryStatusIntent();
        if (batteryStatus != null) {
            temp = (float)((double)batteryStatus.getIntExtra("temperature", 0) / 10.0);
        }
        return temp;
    }

    public final int getBatteryVoltage() {
        int volt = 0;
        Intent batteryStatus = this.getBatteryStatusIntent();
        if (batteryStatus != null) {
            volt = batteryStatus.getIntExtra("voltage", 0);
        }
        return volt;
    }

    @ChargingVia
    public final int getChargingSource() {
        Intent batteryStatus = this.getBatteryStatusIntent();
        int chargePlug = batteryStatus.getIntExtra("plugged", 0);
        switch (chargePlug) {
            case 1: {
                return 1;
            }
            case 2: {
                return 0;
            }
            case 4: {
                return 2;
            }
        }
        return 3;
    }

    public final boolean isBatteryPresent() {
        return this.getBatteryStatusIntent().getExtras() != null && this.getBatteryStatusIntent().getExtras().getBoolean("present");
    }
}

