/*
 * Decompiled with CFR 0.152.
 */
package github.nisrulz.easydeviceinfo.base;

import android.content.Context;
import android.util.DisplayMetrics;
import android.view.Display;
import android.view.MotionEvent;
import android.view.WindowManager;
import github.nisrulz.easydeviceinfo.base.CheckValidityUtil;

public class EasyDisplayMod {
    private final Context context;
    private final Display display;

    public EasyDisplayMod(Context context) {
        this.context = context;
        WindowManager wm = (WindowManager)context.getSystemService("window");
        this.display = wm != null ? wm.getDefaultDisplay() : null;
    }

    public final String getDensity() {
        String densityStr = null;
        int density = this.context.getResources().getDisplayMetrics().densityDpi;
        switch (density) {
            case 120: {
                densityStr = "LDPI";
                break;
            }
            case 160: {
                densityStr = "MDPI";
                break;
            }
            case 213: {
                densityStr = "TVDPI";
                break;
            }
            case 240: {
                densityStr = "HDPI";
                break;
            }
            case 320: {
                densityStr = "XHDPI";
                break;
            }
            case 400: {
                densityStr = "XMHDPI";
                break;
            }
            case 480: {
                densityStr = "XXHDPI";
                break;
            }
            case 640: {
                densityStr = "XXXHDPI";
                break;
            }
        }
        return CheckValidityUtil.checkValidData(densityStr);
    }

    public final int[] getDisplayXYCoordinates(MotionEvent event) {
        int[] coordinates = new int[]{0, 0};
        if (event.getAction() == 0) {
            coordinates[0] = (int)event.getX();
            coordinates[1] = (int)event.getY();
        }
        return coordinates;
    }

    public final String getResolution() {
        DisplayMetrics metrics = new DisplayMetrics();
        if (this.display != null) {
            this.display.getMetrics(metrics);
            return CheckValidityUtil.checkValidData(metrics.heightPixels + "x" + metrics.widthPixels);
        }
        return CheckValidityUtil.checkValidData("");
    }

    public final float getRefreshRate() {
        return this.display.getRefreshRate();
    }

    public final float getPhysicalSize() {
        DisplayMetrics metrics = new DisplayMetrics();
        if (this.display != null) {
            this.display.getMetrics(metrics);
            float x = (float)Math.pow((float)metrics.widthPixels / metrics.xdpi, 2.0);
            float y = (float)Math.pow((float)metrics.heightPixels / metrics.ydpi, 2.0);
            return (float)Math.sqrt(x + y);
        }
        return 0.0f;
    }
}

