/*
 * Decompiled with CFR 0.152.
 */
package github.nisrulz.easydeviceinfo.base;

import android.content.Context;
import android.location.Location;
import android.location.LocationManager;
import android.support.annotation.RequiresPermission;
import github.nisrulz.easydeviceinfo.base.PermissionUtil;

public class EasyLocationMod {
    private final boolean hasFineLocationPermission;
    private final boolean hasCoarseLocationPermission;
    private LocationManager lm;

    public EasyLocationMod(Context context) {
        this.hasFineLocationPermission = PermissionUtil.hasPermission(context, "android.permission.ACCESS_FINE_LOCATION");
        this.hasCoarseLocationPermission = PermissionUtil.hasPermission(context, "android.permission.ACCESS_COARSE_LOCATION");
        if (this.hasCoarseLocationPermission || this.hasFineLocationPermission) {
            this.lm = (LocationManager)context.getSystemService("location");
        }
    }

    @RequiresPermission(anyOf={"android.permission.ACCESS_COARSE_LOCATION", "android.permission.ACCESS_FINE_LOCATION"})
    public final double[] getLatLong() {
        double[] gps = new double[]{0.0, 0.0};
        if (this.hasCoarseLocationPermission && this.lm.isProviderEnabled("network")) {
            Location lastKnownLocation = this.lm.getLastKnownLocation("network");
            if (lastKnownLocation != null) {
                gps[0] = lastKnownLocation.getLatitude();
                gps[1] = lastKnownLocation.getLongitude();
            }
        } else if (this.hasFineLocationPermission) {
            boolean isGPSEnabled = this.lm.isProviderEnabled("gps");
            boolean isNetworkEnabled = this.lm.isProviderEnabled("network");
            Location lastKnownLocationNetwork = null;
            Location lastKnownLocationGps = null;
            Location betterLastKnownLocation = null;
            if (isNetworkEnabled) {
                lastKnownLocationNetwork = this.lm.getLastKnownLocation("network");
            }
            if (isGPSEnabled) {
                lastKnownLocationGps = this.lm.getLastKnownLocation("gps");
            }
            if (lastKnownLocationGps != null && lastKnownLocationNetwork != null) {
                betterLastKnownLocation = this.getBetterLocation(lastKnownLocationGps, lastKnownLocationNetwork);
            }
            if (betterLastKnownLocation == null) {
                betterLastKnownLocation = this.lm.getLastKnownLocation("passive");
            }
            if (betterLastKnownLocation != null) {
                gps[0] = betterLastKnownLocation.getLatitude();
                gps[1] = betterLastKnownLocation.getLongitude();
            }
        }
        return gps;
    }

    private Location getBetterLocation(Location location1, Location location2) {
        if (location1.getAccuracy() >= location2.getAccuracy()) {
            return location1;
        }
        return location2;
    }
}

