/*
 * Decompiled with CFR 0.152.
 */
package github.nisrulz.easydeviceinfo.base;

import android.app.ActivityManager;
import android.content.Context;
import android.os.Build;
import android.os.Environment;
import android.os.StatFs;
import android.util.Log;
import github.nisrulz.easydeviceinfo.common.EasyDeviceInfo;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;

public class EasyMemoryMod {
    private static final String IO_EXCEPTION = "IO Exception";
    private static final int BYTEFACTOR = 1024;
    private final Context context;

    public EasyMemoryMod(Context context) {
        this.context = context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final long getTotalRAM() {
        long totalMemory = 0L;
        if (Build.VERSION.SDK_INT >= 16) {
            ActivityManager.MemoryInfo mi = new ActivityManager.MemoryInfo();
            ActivityManager activityManager = (ActivityManager)this.context.getSystemService("activity");
            if (activityManager != null) {
                activityManager.getMemoryInfo(mi);
                totalMemory = mi.totalMem;
            }
        } else {
            RandomAccessFile reader = null;
            try {
                reader = new RandomAccessFile("/proc/meminfo", "r");
                String load = reader.readLine().replaceAll("\\D+", "");
                totalMemory = Integer.parseInt(load);
            }
            catch (IOException e) {
                if (EasyDeviceInfo.debuggable) {
                    Log.e((String)"EasyDeviceInfo", (String)IO_EXCEPTION, (Throwable)e);
                }
            }
            finally {
                block17: {
                    if (reader != null) {
                        try {
                            reader.close();
                        }
                        catch (IOException e) {
                            if (!EasyDeviceInfo.debuggable) break block17;
                            Log.e((String)"EasyDeviceInfo", (String)IO_EXCEPTION, (Throwable)e);
                        }
                    }
                }
            }
        }
        return totalMemory;
    }

    public final long getAvailableInternalMemorySize() {
        long availableBlocks;
        long blockSize;
        File path = Environment.getDataDirectory();
        StatFs stat = new StatFs(path.getPath());
        if (Build.VERSION.SDK_INT >= 18) {
            blockSize = stat.getBlockSizeLong();
            availableBlocks = stat.getAvailableBlocksLong();
        } else {
            blockSize = stat.getBlockSize();
            availableBlocks = stat.getAvailableBlocks();
        }
        return availableBlocks * blockSize;
    }

    public final long getTotalInternalMemorySize() {
        long totalBlocks;
        long blockSize;
        File path = Environment.getDataDirectory();
        StatFs stat = new StatFs(path.getPath());
        if (Build.VERSION.SDK_INT >= 18) {
            blockSize = stat.getBlockSizeLong();
            totalBlocks = stat.getBlockCountLong();
        } else {
            blockSize = stat.getBlockSize();
            totalBlocks = stat.getBlockCount();
        }
        return totalBlocks * blockSize;
    }

    public final long getAvailableExternalMemorySize() {
        if (this.externalMemoryAvailable()) {
            long availableBlocks;
            long blockSize;
            File path = Environment.getExternalStorageDirectory();
            StatFs stat = new StatFs(path.getPath());
            if (Build.VERSION.SDK_INT >= 18) {
                blockSize = stat.getBlockSizeLong();
                availableBlocks = stat.getAvailableBlocksLong();
            } else {
                blockSize = stat.getBlockSize();
                availableBlocks = stat.getAvailableBlocks();
            }
            return availableBlocks * blockSize;
        }
        return 0L;
    }

    private boolean externalMemoryAvailable() {
        return Environment.getExternalStorageState().equals("mounted");
    }

    public final long getTotalExternalMemorySize() {
        if (this.externalMemoryAvailable()) {
            long totalBlocks;
            long blockSize;
            File path = Environment.getExternalStorageDirectory();
            StatFs stat = new StatFs(path.getPath());
            if (Build.VERSION.SDK_INT >= 18) {
                blockSize = stat.getBlockSizeLong();
                totalBlocks = stat.getBlockCountLong();
            } else {
                blockSize = stat.getBlockSize();
                totalBlocks = stat.getBlockCount();
            }
            return totalBlocks * blockSize;
        }
        return 0L;
    }

    public float convertToKb(long valInBytes) {
        return (float)valInBytes / 1024.0f;
    }

    public float convertToMb(long valInBytes) {
        return (float)valInBytes / 1048576.0f;
    }

    public float convertToGb(long valInBytes) {
        return (float)valInBytes / 1.0737418E9f;
    }

    public float convertToTb(long valInBytes) {
        return (float)valInBytes / 0.0f;
    }
}

