/*
 * Decompiled with CFR 0.152.
 */
package com.pedrogomez.renderers;

import android.support.v7.widget.RecyclerView;
import android.view.LayoutInflater;
import android.view.ViewGroup;
import com.pedrogomez.renderers.AdapteeCollection;
import com.pedrogomez.renderers.Renderer;
import com.pedrogomez.renderers.RendererBuilder;
import com.pedrogomez.renderers.RendererViewHolder;
import com.pedrogomez.renderers.exception.NullRendererBuiltException;
import java.util.Collection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RVRendererAdapter<T>
extends RecyclerView.Adapter<RendererViewHolder> {
    private final LayoutInflater layoutInflater;
    private final RendererBuilder<T> rendererBuilder;
    private final AdapteeCollection<T> collection;

    public RVRendererAdapter(LayoutInflater layoutInflater, RendererBuilder<T> rendererBuilder, AdapteeCollection<T> collection) {
        this.layoutInflater = layoutInflater;
        this.rendererBuilder = rendererBuilder;
        this.collection = collection;
    }

    public int getItemCount() {
        return this.collection.size();
    }

    public T getItem(int position) {
        return this.collection.get(position);
    }

    public long getItemId(int position) {
        return position;
    }

    public int getItemViewType(int position) {
        T content = this.getItem(position);
        return this.rendererBuilder.getItemViewType(content);
    }

    public RendererViewHolder onCreateViewHolder(ViewGroup viewGroup, int viewType) {
        this.rendererBuilder.withParent(viewGroup);
        this.rendererBuilder.withLayoutInflater(this.layoutInflater);
        this.rendererBuilder.withViewType(viewType);
        RendererViewHolder viewHolder = this.rendererBuilder.buildRendererViewHolder();
        if (viewHolder == null) {
            throw new NullRendererBuiltException("RendererBuilder have to return a not null viewHolder");
        }
        return viewHolder;
    }

    public void onBindViewHolder(RendererViewHolder viewHolder, int position) {
        T content = this.getItem(position);
        Renderer renderer = viewHolder.getRenderer();
        if (renderer == null) {
            throw new NullRendererBuiltException("RendererBuilder have to return a not null renderer");
        }
        renderer.setContent(content);
        this.updateRendererExtraValues(content, renderer, position);
        renderer.render();
    }

    public void add(T element) {
        this.collection.add(element);
    }

    public void remove(T element) {
        this.collection.remove(element);
    }

    public void addAll(Collection<T> elements) {
        this.collection.addAll(elements);
    }

    public void removeAll(Collection<T> elements) {
        this.collection.removeAll(elements);
    }

    public void clear() {
        this.collection.clear();
    }

    protected AdapteeCollection<T> getCollection() {
        return this.collection;
    }

    protected void updateRendererExtraValues(T content, Renderer<T> renderer, int position) {
    }
}

