/*
 * Decompiled with CFR 0.152.
 */
package com.pedrogomez.renderers;

import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import com.pedrogomez.renderers.exception.NotInflateViewException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Renderer<T>
implements Cloneable {
    private View rootView;
    private T content;

    public void onCreate(T content, LayoutInflater layoutInflater, ViewGroup parent) {
        this.content = content;
        this.rootView = this.inflate(layoutInflater, parent);
        if (this.rootView == null) {
            throw new NotInflateViewException("Renderer instances have to return a not null view in inflateView method");
        }
        this.rootView.setTag((Object)this);
        this.setUpView(this.rootView);
        this.hookListeners(this.rootView);
    }

    public void onRecycle(T content) {
        this.content = content;
    }

    public View getRootView() {
        return this.rootView;
    }

    protected final T getContent() {
        return this.content;
    }

    protected void setContent(T content) {
        this.content = content;
    }

    protected abstract void setUpView(View var1);

    protected abstract void hookListeners(View var1);

    protected abstract View inflate(LayoutInflater var1, ViewGroup var2);

    public abstract void render();

    Renderer copy() {
        Renderer copy = null;
        try {
            copy = (Renderer)this.clone();
        }
        catch (CloneNotSupportedException e) {
            Log.e((String)"Renderer", (String)"All your renderers should be clonables.");
        }
        return copy;
    }
}

