/*
 * Decompiled with CFR 0.152.
 */
package com.pedrogomez.renderers;

import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import com.pedrogomez.renderers.AdapteeCollection;
import com.pedrogomez.renderers.Renderer;
import com.pedrogomez.renderers.RendererBuilder;
import com.pedrogomez.renderers.exception.NullRendererBuiltException;
import java.util.Collection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RendererAdapter<T>
extends BaseAdapter {
    private final LayoutInflater layoutInflater;
    private final RendererBuilder<T> rendererBuilder;
    private final AdapteeCollection<T> collection;

    public RendererAdapter(LayoutInflater layoutInflater, RendererBuilder rendererBuilder, AdapteeCollection<T> collection) {
        this.layoutInflater = layoutInflater;
        this.rendererBuilder = rendererBuilder;
        this.collection = collection;
    }

    public int getCount() {
        return this.collection.size();
    }

    public T getItem(int position) {
        return this.collection.get(position);
    }

    public long getItemId(int position) {
        return position;
    }

    public View getView(int position, View convertView, ViewGroup parent) {
        T content = this.getItem(position);
        this.rendererBuilder.withContent(content);
        this.rendererBuilder.withConvertView(convertView);
        this.rendererBuilder.withParent(parent);
        this.rendererBuilder.withLayoutInflater(this.layoutInflater);
        Renderer renderer = this.rendererBuilder.build();
        if (renderer == null) {
            throw new NullRendererBuiltException("RendererBuilder have to return a not null Renderer");
        }
        this.updateRendererExtraValues(content, renderer, position);
        renderer.render();
        return renderer.getRootView();
    }

    public int getItemViewType(int position) {
        T content = this.getItem(position);
        return this.rendererBuilder.getItemViewType(content);
    }

    public int getViewTypeCount() {
        return this.rendererBuilder.getViewTypeCount();
    }

    public void add(T element) {
        this.collection.add(element);
    }

    public void remove(T element) {
        this.collection.remove(element);
    }

    public void addAll(Collection<T> elements) {
        this.collection.addAll(elements);
    }

    public void removeAll(Collection<T> elements) {
        this.collection.removeAll(elements);
    }

    public void clear() {
        this.collection.clear();
    }

    protected AdapteeCollection<T> getCollection() {
        return this.collection;
    }

    protected void updateRendererExtraValues(T content, Renderer<T> renderer, int position) {
    }
}

