/*
 * Decompiled with CFR 0.152.
 */
package com.pedrogomez.renderers;

import android.content.Context;
import android.support.v7.widget.RecyclerView;
import android.view.LayoutInflater;
import android.view.ViewGroup;
import com.pedrogomez.renderers.AdapteeCollection;
import com.pedrogomez.renderers.ListAdapteeCollection;
import com.pedrogomez.renderers.Renderer;
import com.pedrogomez.renderers.RendererBuilder;
import com.pedrogomez.renderers.RendererViewHolder;
import com.pedrogomez.renderers.exception.NullRendererBuiltException;
import java.util.Collection;

public class RVRendererAdapter<T>
extends RecyclerView.Adapter<RendererViewHolder> {
    private final RendererBuilder<T> rendererBuilder;
    private AdapteeCollection<T> collection;

    public RVRendererAdapter(RendererBuilder<T> rendererBuilder) {
        this(rendererBuilder, new ListAdapteeCollection());
    }

    public RVRendererAdapter(RendererBuilder<T> rendererBuilder, AdapteeCollection<T> collection) {
        this.rendererBuilder = rendererBuilder;
        this.collection = collection;
    }

    public int getItemCount() {
        return this.collection.size();
    }

    public T getItem(int position) {
        return this.collection.get(position);
    }

    public long getItemId(int position) {
        return position;
    }

    public void setCollection(AdapteeCollection<T> collection) {
        if (collection == null) {
            throw new IllegalArgumentException("The AdapteeCollection configured can't be null");
        }
        this.collection = collection;
    }

    public int getItemViewType(int position) {
        T content = this.getItem(position);
        return this.rendererBuilder.getItemViewType(content);
    }

    public RendererViewHolder onCreateViewHolder(ViewGroup viewGroup, int viewType) {
        this.rendererBuilder.withParent(viewGroup);
        this.rendererBuilder.withLayoutInflater(LayoutInflater.from((Context)viewGroup.getContext()));
        this.rendererBuilder.withViewType(viewType);
        RendererViewHolder viewHolder = this.rendererBuilder.buildRendererViewHolder();
        if (viewHolder == null) {
            throw new NullRendererBuiltException("RendererBuilder have to return a not null viewHolder");
        }
        return viewHolder;
    }

    public void onBindViewHolder(RendererViewHolder viewHolder, int position) {
        T content = this.getItem(position);
        Renderer renderer = viewHolder.getRenderer();
        if (renderer == null) {
            throw new NullRendererBuiltException("RendererBuilder have to return a not null renderer");
        }
        renderer.setContent(content);
        this.updateRendererExtraValues(content, renderer, position);
        renderer.render();
    }

    public boolean add(T element) {
        return this.collection.add(element);
    }

    public boolean remove(Object element) {
        return this.collection.remove(element);
    }

    public boolean addAll(Collection<? extends T> elements) {
        return this.collection.addAll(elements);
    }

    public boolean removeAll(Collection<?> elements) {
        return this.collection.removeAll(elements);
    }

    public void clear() {
        this.collection.clear();
    }

    protected AdapteeCollection<T> getCollection() {
        return this.collection;
    }

    protected void updateRendererExtraValues(T content, Renderer<T> renderer, int position) {
    }
}

