/*
 * Decompiled with CFR 0.152.
 */
package com.pedrogomez.renderers;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import com.pedrogomez.renderers.AdapteeCollection;
import com.pedrogomez.renderers.ListAdapteeCollection;
import com.pedrogomez.renderers.Renderer;
import com.pedrogomez.renderers.RendererBuilder;
import com.pedrogomez.renderers.exception.NullRendererBuiltException;
import java.util.Collection;

public class RendererAdapter<T>
extends BaseAdapter {
    private final RendererBuilder<T> rendererBuilder;
    private AdapteeCollection<T> collection;

    public RendererAdapter(RendererBuilder<T> rendererBuilder) {
        this(rendererBuilder, new ListAdapteeCollection());
    }

    public RendererAdapter(RendererBuilder<T> rendererBuilder, AdapteeCollection<T> collection) {
        this.rendererBuilder = rendererBuilder;
        this.collection = collection;
    }

    public int getCount() {
        return this.collection.size();
    }

    public T getItem(int position) {
        return this.collection.get(position);
    }

    public long getItemId(int position) {
        return position;
    }

    public void setCollection(AdapteeCollection<T> collection) {
        if (collection == null) {
            throw new IllegalArgumentException("The AdapteeCollection configured can't be null");
        }
        this.collection = collection;
    }

    public View getView(int position, View convertView, ViewGroup parent) {
        T content = this.getItem(position);
        this.rendererBuilder.withContent(content);
        this.rendererBuilder.withConvertView(convertView);
        this.rendererBuilder.withParent(parent);
        this.rendererBuilder.withLayoutInflater(LayoutInflater.from((Context)parent.getContext()));
        Renderer renderer = this.rendererBuilder.build();
        if (renderer == null) {
            throw new NullRendererBuiltException("RendererBuilder have to return a not null Renderer");
        }
        this.updateRendererExtraValues(content, renderer, position);
        renderer.render();
        return renderer.getRootView();
    }

    public int getItemViewType(int position) {
        T content = this.getItem(position);
        return this.rendererBuilder.getItemViewType(content);
    }

    public int getViewTypeCount() {
        return this.rendererBuilder.getViewTypeCount();
    }

    public void add(T element) {
        this.collection.add(element);
    }

    public void remove(Object element) {
        this.collection.remove(element);
    }

    public void addAll(Collection<? extends T> elements) {
        this.collection.addAll(elements);
    }

    public void removeAll(Collection<?> elements) {
        this.collection.removeAll(elements);
    }

    public void clear() {
        this.collection.clear();
    }

    protected AdapteeCollection<T> getCollection() {
        return this.collection;
    }

    protected void updateRendererExtraValues(T content, Renderer<T> renderer, int position) {
    }
}

