/*
 * Decompiled with CFR 0.152.
 */
package com.pedrogomez.renderers;

import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import com.pedrogomez.renderers.Renderer;
import com.pedrogomez.renderers.RendererViewHolder;
import com.pedrogomez.renderers.exception.NeedsPrototypesException;
import com.pedrogomez.renderers.exception.NullContentException;
import com.pedrogomez.renderers.exception.NullLayoutInflaterException;
import com.pedrogomez.renderers.exception.NullParentException;
import com.pedrogomez.renderers.exception.NullPrototypeClassException;
import com.pedrogomez.renderers.exception.PrototypeNotFoundException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class RendererBuilder<T> {
    private List<Renderer<? extends T>> prototypes;
    private T content;
    private View convertView;
    private ViewGroup parent;
    private LayoutInflater layoutInflater;
    private Integer viewType;
    private Map<Class<? extends T>, Class<? extends Renderer>> binding;

    public RendererBuilder() {
        this(new LinkedList());
    }

    public RendererBuilder(Renderer<T> renderer) {
        this(Collections.singletonList(renderer));
    }

    public RendererBuilder(Collection<? extends Renderer<? extends T>> prototypes) {
        if (prototypes == null) {
            throw new NeedsPrototypesException("RendererBuilder has to be created with a non null collection ofCollection<Renderer<T> to provide new or recycled Renderer instances");
        }
        this.prototypes = new LinkedList<Renderer<T>>(prototypes);
        this.binding = new HashMap<Class<? extends T>, Class<? extends Renderer>>();
    }

    public final List<Renderer<? extends T>> getPrototypes() {
        return Collections.unmodifiableList(this.prototypes);
    }

    public final void setPrototypes(Collection<? extends Renderer<? extends T>> prototypes) {
        if (prototypes == null) {
            throw new NeedsPrototypesException("RendererBuilder has to be created with a non null collection ofCollection<Renderer<T> to provide new or recycled Renderer instances");
        }
        this.prototypes = new LinkedList<Renderer<T>>(prototypes);
    }

    public RendererBuilder<T> withPrototypes(Collection<? extends Renderer<? extends T>> prototypes) {
        if (prototypes == null) {
            throw new NeedsPrototypesException("RendererBuilder has to be created with a non null collection ofCollection<Renderer<T> to provide new or recycled Renderer instances");
        }
        this.prototypes.addAll(prototypes);
        return this;
    }

    public RendererBuilder<T> withPrototype(Renderer<? extends T> renderer) {
        if (renderer == null) {
            throw new NeedsPrototypesException("RendererBuilder can't use a null Renderer<T> instance as prototype");
        }
        this.prototypes.add(renderer);
        return this;
    }

    public <G extends T> RendererBuilder<T> bind(Class<G> clazz, Renderer<? extends G> prototype) {
        if (clazz == null || prototype == null) {
            throw new IllegalArgumentException("The binding RecyclerView binding can't be configured using null instances");
        }
        this.prototypes.add(prototype);
        this.binding.put(clazz, prototype.getClass());
        return this;
    }

    public <G extends T> RendererBuilder<T> bind(Class<G> clazz, Class<? extends Renderer<? extends G>> prototypeClass) {
        if (clazz == null || prototypeClass == null) {
            throw new IllegalArgumentException("The binding RecyclerView binding can't be configured using null instances");
        }
        this.binding.put(clazz, prototypeClass);
        return this;
    }

    RendererBuilder withContent(T content) {
        this.content = content;
        return this;
    }

    protected RendererBuilder withConvertView(View convertView) {
        this.convertView = convertView;
        return this;
    }

    RendererBuilder withParent(ViewGroup parent) {
        this.parent = parent;
        return this;
    }

    RendererBuilder withLayoutInflater(LayoutInflater layoutInflater) {
        this.layoutInflater = layoutInflater;
        return this;
    }

    RendererBuilder withViewType(Integer viewType) {
        this.viewType = viewType;
        return this;
    }

    int getItemViewType(T content) {
        Class prototypeClass = this.getPrototypeClass(content);
        this.validatePrototypeClass(prototypeClass);
        return this.getItemViewType(prototypeClass);
    }

    int getViewTypeCount() {
        return this.prototypes.size();
    }

    protected Renderer build() {
        this.validateAttributes();
        Renderer renderer = this.isRecyclable(this.convertView, this.content) ? this.recycle(this.convertView, this.content) : this.createRenderer(this.content, this.parent);
        return renderer;
    }

    protected RendererViewHolder buildRendererViewHolder() {
        this.validateAttributesToCreateANewRendererViewHolder();
        Renderer renderer = this.getPrototypeByIndex(this.viewType).copy();
        renderer.onCreate(null, this.layoutInflater, this.parent);
        return new RendererViewHolder(renderer);
    }

    private Renderer recycle(View convertView, T content) {
        Renderer renderer = (Renderer)convertView.getTag();
        renderer.onRecycle(content);
        return renderer;
    }

    private Renderer createRenderer(T content, ViewGroup parent) {
        int prototypeIndex = this.getPrototypeIndex(content);
        Renderer renderer = this.getPrototypeByIndex(prototypeIndex).copy();
        renderer.onCreate(content, this.layoutInflater, parent);
        return renderer;
    }

    private Renderer getPrototypeByIndex(int prototypeIndex) {
        Renderer<? extends T> prototypeSelected = null;
        int i = 0;
        for (Renderer<? extends T> renderer : this.prototypes) {
            if (i == prototypeIndex) {
                prototypeSelected = renderer;
            }
            ++i;
        }
        return prototypeSelected;
    }

    private boolean isRecyclable(View convertView, T content) {
        boolean isRecyclable = false;
        if (convertView != null && convertView.getTag() != null) {
            Class prototypeClass = this.getPrototypeClass(content);
            this.validatePrototypeClass(prototypeClass);
            isRecyclable = prototypeClass.equals(convertView.getTag().getClass());
        }
        return isRecyclable;
    }

    private void validatePrototypeClass(Class prototypeClass) {
        if (prototypeClass == null) {
            throw new NullPrototypeClassException("Your getPrototypeClass method implementation can't return a null class");
        }
    }

    private int getPrototypeIndex(T content) {
        return this.getItemViewType(content);
    }

    private int getItemViewType(Class prototypeClass) {
        int itemViewType = -1;
        for (Renderer<T> renderer : this.prototypes) {
            if (!renderer.getClass().equals(prototypeClass)) continue;
            itemViewType = this.getPrototypeIndex(renderer);
            break;
        }
        if (itemViewType == -1) {
            throw new PrototypeNotFoundException("Review your RendererBuilder implementation, you are returning one prototype class not found in prototypes collection");
        }
        return itemViewType;
    }

    private int getPrototypeIndex(Renderer renderer) {
        int index = 0;
        for (Renderer<T> prototype : this.prototypes) {
            if (prototype.getClass().equals(renderer.getClass())) break;
            ++index;
        }
        return index;
    }

    private void validateAttributes() {
        if (this.content == null) {
            throw new NullContentException("RendererBuilder needs content to create Renderer instances");
        }
        if (this.parent == null) {
            throw new NullParentException("RendererBuilder needs a parent to inflate Renderer instances");
        }
        if (this.layoutInflater == null) {
            throw new NullLayoutInflaterException("RendererBuilder needs a LayoutInflater to inflate Renderer instances");
        }
    }

    private void validateAttributesToCreateANewRendererViewHolder() {
        if (this.viewType == null) {
            throw new NullContentException("RendererBuilder needs a view type to create a RendererViewHolder");
        }
        if (this.layoutInflater == null) {
            throw new NullLayoutInflaterException("RendererBuilder needs a LayoutInflater to create a RendererViewHolder");
        }
        if (this.parent == null) {
            throw new NullParentException("RendererBuilder needs a parent to create a RendererViewHolder");
        }
    }

    protected Class getPrototypeClass(T content) {
        if (this.prototypes.size() == 1) {
            return this.prototypes.get(0).getClass();
        }
        return this.binding.get(content.getClass());
    }
}

