/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.mediation.pangle;

import android.content.Context;
import android.os.Bundle;
import android.text.TextUtils;
import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.VisibleForTesting;
import com.bytedance.sdk.openadsdk.api.PAGConstant;
import com.bytedance.sdk.openadsdk.api.bidding.PAGBiddingRequest;
import com.bytedance.sdk.openadsdk.api.init.BiddingTokenCallback;
import com.bytedance.sdk.openadsdk.api.init.PAGConfig;
import com.google.ads.mediation.pangle.PangleConstants;
import com.google.ads.mediation.pangle.PangleFactory;
import com.google.ads.mediation.pangle.PangleInitializer;
import com.google.ads.mediation.pangle.PangleSdkWrapper;
import com.google.ads.mediation.pangle.renderer.PangleAppOpenAd;
import com.google.ads.mediation.pangle.renderer.PangleBannerAd;
import com.google.ads.mediation.pangle.renderer.PangleInterstitialAd;
import com.google.ads.mediation.pangle.renderer.PangleNativeAd;
import com.google.ads.mediation.pangle.renderer.PangleRewardedAd;
import com.google.android.gms.ads.AdError;
import com.google.android.gms.ads.VersionInfo;
import com.google.android.gms.ads.mediation.InitializationCompleteCallback;
import com.google.android.gms.ads.mediation.MediationAdLoadCallback;
import com.google.android.gms.ads.mediation.MediationAppOpenAd;
import com.google.android.gms.ads.mediation.MediationAppOpenAdCallback;
import com.google.android.gms.ads.mediation.MediationAppOpenAdConfiguration;
import com.google.android.gms.ads.mediation.MediationBannerAd;
import com.google.android.gms.ads.mediation.MediationBannerAdCallback;
import com.google.android.gms.ads.mediation.MediationBannerAdConfiguration;
import com.google.android.gms.ads.mediation.MediationConfiguration;
import com.google.android.gms.ads.mediation.MediationInterstitialAd;
import com.google.android.gms.ads.mediation.MediationInterstitialAdCallback;
import com.google.android.gms.ads.mediation.MediationInterstitialAdConfiguration;
import com.google.android.gms.ads.mediation.MediationNativeAdCallback;
import com.google.android.gms.ads.mediation.MediationNativeAdConfiguration;
import com.google.android.gms.ads.mediation.MediationRewardedAd;
import com.google.android.gms.ads.mediation.MediationRewardedAdCallback;
import com.google.android.gms.ads.mediation.MediationRewardedAdConfiguration;
import com.google.android.gms.ads.mediation.UnifiedNativeAdMapper;
import com.google.android.gms.ads.mediation.rtb.RtbAdapter;
import com.google.android.gms.ads.mediation.rtb.RtbSignalData;
import com.google.android.gms.ads.mediation.rtb.SignalCallbacks;
import java.util.HashSet;
import java.util.List;

public class PangleMediationAdapter
extends RtbAdapter {
    public static final String TAG = PangleMediationAdapter.class.getSimpleName();
    @VisibleForTesting
    static final String ERROR_MESSAGE_MISSING_OR_INVALID_APP_ID = "Missing or invalid App ID.";
    private final PangleInitializer pangleInitializer;
    private final PangleSdkWrapper pangleSdkWrapper;
    private final PangleFactory pangleFactory;
    private PangleAppOpenAd appOpenAd;
    private PangleBannerAd bannerAd;
    private PangleInterstitialAd interstitialAd;
    private PangleNativeAd nativeAd;
    private PangleRewardedAd rewardedAd;
    private static int gdpr = -1;

    public PangleMediationAdapter() {
        this.pangleInitializer = PangleInitializer.getInstance();
        this.pangleSdkWrapper = new PangleSdkWrapper();
        this.pangleFactory = new PangleFactory();
    }

    @VisibleForTesting
    PangleMediationAdapter(PangleInitializer pangleInitializer, PangleSdkWrapper pangleSdkWrapper, PangleFactory pangleFactory) {
        this.pangleInitializer = pangleInitializer;
        this.pangleSdkWrapper = pangleSdkWrapper;
        this.pangleFactory = pangleFactory;
    }

    public void collectSignals(@NonNull RtbSignalData rtbSignalData, final @NonNull SignalCallbacks signalCallbacks) {
        if (PangleConstants.isChildUser()) {
            signalCallbacks.onFailure(PangleConstants.createChildUserError());
            return;
        }
        Bundle networkExtras = rtbSignalData.getNetworkExtras();
        if (networkExtras != null && networkExtras.containsKey("user_data")) {
            this.pangleSdkWrapper.setUserData(networkExtras.getString("user_data", ""));
        }
        PAGBiddingRequest biddingRequest = new PAGBiddingRequest();
        biddingRequest.setAdxId("207");
        this.pangleSdkWrapper.getBiddingToken(rtbSignalData.getContext(), biddingRequest, new BiddingTokenCallback(){

            public void onBiddingTokenCollected(String biddingToken) {
                signalCallbacks.onSuccess(biddingToken);
            }
        });
    }

    public void initialize(@NonNull Context context, final @NonNull InitializationCompleteCallback initializationCompleteCallback, @NonNull List<MediationConfiguration> list) {
        if (PangleConstants.isChildUser()) {
            initializationCompleteCallback.onInitializationFailed("MobileAds.getRequestConfiguration() indicates the user is a child. Pangle SDK V71 or higher does not support child users.");
            return;
        }
        HashSet<String> appIds = new HashSet<String>();
        for (MediationConfiguration mediationConfiguration : list) {
            Bundle serverParameters = mediationConfiguration.getServerParameters();
            String appId = serverParameters.getString("appid");
            if (TextUtils.isEmpty((CharSequence)appId)) continue;
            appIds.add(appId);
        }
        int count = appIds.size();
        if (count <= 0) {
            AdError error = PangleConstants.createAdapterError(101, ERROR_MESSAGE_MISSING_OR_INVALID_APP_ID);
            Log.w((String)TAG, (String)error.toString());
            initializationCompleteCallback.onInitializationFailed(error.toString());
            return;
        }
        String appId = (String)appIds.iterator().next();
        if (count > 1) {
            String message = String.format("Found multiple app IDs in %s. Using %s to initialize Pangle SDK.", appIds, appId);
            Log.w((String)TAG, (String)message);
        }
        this.pangleInitializer.initialize(context, appId, new PangleInitializer.Listener(){

            @Override
            public void onInitializeSuccess() {
                initializationCompleteCallback.onInitializationSucceeded();
            }

            @Override
            public void onInitializeError(@NonNull AdError error) {
                Log.w((String)TAG, (String)error.toString());
                initializationCompleteCallback.onInitializationFailed(error.getMessage());
            }
        });
    }

    @NonNull
    public VersionInfo getVersionInfo() {
        return this.getVersionInfo("7.5.0.2.0");
    }

    @VisibleForTesting
    @NonNull
    VersionInfo getVersionInfo(String versionString) {
        String[] splits = versionString.split("\\.");
        if (splits.length >= 4) {
            int major = Integer.parseInt(splits[0]);
            int minor = Integer.parseInt(splits[1]);
            int micro = Integer.parseInt(splits[2]) * 100 + Integer.parseInt(splits[3]);
            if (splits.length >= 5) {
                micro = micro * 100 + Integer.parseInt(splits[4]);
            }
            return new VersionInfo(major, minor, micro);
        }
        String logMessage = String.format("Unexpected adapter version format: %s. Returning 0.0.0 for adapter version.", versionString);
        Log.w((String)TAG, (String)logMessage);
        return new VersionInfo(0, 0, 0);
    }

    @NonNull
    public VersionInfo getSDKVersionInfo() {
        String versionString = this.pangleSdkWrapper.getSdkVersion();
        String[] splits = versionString.split("\\.");
        if (splits.length >= 3) {
            int major = Integer.parseInt(splits[0]);
            int minor = Integer.parseInt(splits[1]);
            int micro = Integer.parseInt(splits[2]);
            if (splits.length >= 4) {
                micro = micro * 100 + Integer.parseInt(splits[3]);
            }
            return new VersionInfo(major, minor, micro);
        }
        String logMessage = String.format("Unexpected SDK version format: %s. Returning 0.0.0 for SDK version.", versionString);
        Log.w((String)TAG, (String)logMessage);
        return new VersionInfo(0, 0, 0);
    }

    public void loadAppOpenAd(@NonNull MediationAppOpenAdConfiguration adConfiguration, @NonNull MediationAdLoadCallback<MediationAppOpenAd, MediationAppOpenAdCallback> callback) {
        if (PangleConstants.isChildUser()) {
            callback.onFailure(PangleConstants.createChildUserError());
            return;
        }
        this.appOpenAd = this.pangleFactory.createPangleAppOpenAd(adConfiguration, callback, this.pangleInitializer, this.pangleSdkWrapper);
        this.appOpenAd.render();
    }

    public void loadBannerAd(@NonNull MediationBannerAdConfiguration adConfiguration, @NonNull MediationAdLoadCallback<MediationBannerAd, MediationBannerAdCallback> callback) {
        if (PangleConstants.isChildUser()) {
            callback.onFailure(PangleConstants.createChildUserError());
            return;
        }
        this.bannerAd = this.pangleFactory.createPangleBannerAd(adConfiguration, callback, this.pangleInitializer, this.pangleSdkWrapper);
        this.bannerAd.render();
    }

    public void loadInterstitialAd(@NonNull MediationInterstitialAdConfiguration adConfiguration, @NonNull MediationAdLoadCallback<MediationInterstitialAd, MediationInterstitialAdCallback> callback) {
        if (PangleConstants.isChildUser()) {
            callback.onFailure(PangleConstants.createChildUserError());
            return;
        }
        this.interstitialAd = this.pangleFactory.createPangleInterstitialAd(adConfiguration, callback, this.pangleInitializer, this.pangleSdkWrapper);
        this.interstitialAd.render();
    }

    public void loadNativeAd(@NonNull MediationNativeAdConfiguration adConfiguration, @NonNull MediationAdLoadCallback<UnifiedNativeAdMapper, MediationNativeAdCallback> callback) {
        if (PangleConstants.isChildUser()) {
            callback.onFailure(PangleConstants.createChildUserError());
            return;
        }
        this.nativeAd = this.pangleFactory.createPangleNativeAd(adConfiguration, callback, this.pangleInitializer, this.pangleSdkWrapper);
        this.nativeAd.render();
    }

    public void loadRewardedAd(@NonNull MediationRewardedAdConfiguration adConfiguration, @NonNull MediationAdLoadCallback<MediationRewardedAd, MediationRewardedAdCallback> callback) {
        if (PangleConstants.isChildUser()) {
            callback.onFailure(PangleConstants.createChildUserError());
            return;
        }
        this.rewardedAd = this.pangleFactory.createPangleRewardedAd(adConfiguration, callback, this.pangleInitializer, this.pangleSdkWrapper);
        this.rewardedAd.render();
    }

    public static void setGDPRConsent(@PAGConstant.PAGGDPRConsentType int gdpr) {
        PangleMediationAdapter.setGDPRConsent(gdpr, new PangleSdkWrapper());
    }

    @VisibleForTesting
    static void setGDPRConsent(@PAGConstant.PAGGDPRConsentType int gdpr, PangleSdkWrapper pangleSdkWrapper) {
        if (gdpr != 1 && gdpr != 0 && gdpr != -1) {
            Log.w((String)TAG, (String)"Invalid GDPR value. Pangle SDK only accepts -1, 0 or 1.");
            return;
        }
        if (pangleSdkWrapper.isInitSuccess() && !PangleConstants.isChildUser()) {
            pangleSdkWrapper.setGdprConsent(gdpr);
        }
        PangleMediationAdapter.gdpr = gdpr;
    }

    public static int getGDPRConsent() {
        return gdpr;
    }

    public static void setPAConsent(@PAGConstant.PAGPAConsentType int pa) {
        PangleMediationAdapter.setPAConsent(pa, new PangleSdkWrapper());
    }

    @VisibleForTesting
    static void setPAConsent(@PAGConstant.PAGPAConsentType int pa, PangleSdkWrapper pangleSdkWrapper) {
        if (pa != 1 && pa != 0) {
            Log.w((String)TAG, (String)"Invalid PA value. Pangle SDK only accepts 0 or 1.");
            return;
        }
        pangleSdkWrapper.setPAConsent(pa);
    }

    public static int getPAConsent() {
        return PAGConfig.getPAConsent();
    }
}

