/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.mediation.pangle.renderer;

import android.content.Context;
import android.os.Bundle;
import android.text.TextUtils;
import android.util.Log;
import android.view.View;
import android.widget.FrameLayout;
import androidx.annotation.NonNull;
import androidx.annotation.VisibleForTesting;
import com.bytedance.sdk.openadsdk.api.PAGRequest;
import com.bytedance.sdk.openadsdk.api.banner.PAGBannerAd;
import com.bytedance.sdk.openadsdk.api.banner.PAGBannerAdInteractionListener;
import com.bytedance.sdk.openadsdk.api.banner.PAGBannerAdLoadListener;
import com.bytedance.sdk.openadsdk.api.banner.PAGBannerRequest;
import com.bytedance.sdk.openadsdk.api.banner.PAGBannerSize;
import com.google.ads.mediation.pangle.PangleConstants;
import com.google.ads.mediation.pangle.PangleFactory;
import com.google.ads.mediation.pangle.PangleInitializer;
import com.google.ads.mediation.pangle.PangleMediationAdapter;
import com.google.ads.mediation.pangle.PangleRequestHelper;
import com.google.ads.mediation.pangle.PangleSdkWrapper;
import com.google.android.gms.ads.AdError;
import com.google.android.gms.ads.AdSize;
import com.google.android.gms.ads.mediation.MediationAdConfiguration;
import com.google.android.gms.ads.mediation.MediationAdLoadCallback;
import com.google.android.gms.ads.mediation.MediationBannerAd;
import com.google.android.gms.ads.mediation.MediationBannerAdCallback;
import com.google.android.gms.ads.mediation.MediationBannerAdConfiguration;

public class PangleBannerAd
implements MediationBannerAd,
PAGBannerAdInteractionListener {
    @VisibleForTesting
    public static final String ERROR_MESSAGE_BANNER_SIZE_MISMATCH = "Failed to request banner ad from Pangle. Invalid banner size.";
    private final MediationBannerAdConfiguration adConfiguration;
    private final MediationAdLoadCallback<MediationBannerAd, MediationBannerAdCallback> adLoadCallback;
    private final PangleInitializer pangleInitializer;
    private final PangleSdkWrapper pangleSdkWrapper;
    private final PangleFactory pangleFactory;
    private MediationBannerAdCallback bannerAdCallback;
    @VisibleForTesting
    FrameLayout wrappedAdView;

    public PangleBannerAd(@NonNull MediationBannerAdConfiguration mediationBannerAdConfiguration, @NonNull MediationAdLoadCallback<MediationBannerAd, MediationBannerAdCallback> mediationAdLoadCallback, @NonNull PangleInitializer pangleInitializer, @NonNull PangleSdkWrapper pangleSdkWrapper, @NonNull PangleFactory pangleFactory) {
        this.adConfiguration = mediationBannerAdConfiguration;
        this.adLoadCallback = mediationAdLoadCallback;
        this.pangleInitializer = pangleInitializer;
        this.pangleSdkWrapper = pangleSdkWrapper;
        this.pangleFactory = pangleFactory;
    }

    public void render() {
        Bundle serverParameters = this.adConfiguration.getServerParameters();
        final String placementId = serverParameters.getString("placementid");
        if (TextUtils.isEmpty((CharSequence)placementId)) {
            AdError error = PangleConstants.createAdapterError(101, "Failed to load banner ad from Pangle. Missing or invalid Placement ID.");
            Log.e((String)PangleMediationAdapter.TAG, (String)error.toString());
            this.adLoadCallback.onFailure(error);
            return;
        }
        final String bidResponse = this.adConfiguration.getBidResponse();
        final Context context = this.adConfiguration.getContext();
        String appId = serverParameters.getString("appid");
        this.pangleInitializer.initialize(context, appId, new PangleInitializer.Listener(){

            @Override
            public void onInitializeSuccess() {
                AdSize googleAdSize = PangleBannerAd.this.adConfiguration.getAdSize();
                PAGBannerSize bannerSize = PangleBannerAd.getBannerSizeFromGoogleAdSize(context, googleAdSize);
                if (bannerSize == null) {
                    AdError error = PangleConstants.createAdapterError(102, PangleBannerAd.ERROR_MESSAGE_BANNER_SIZE_MISMATCH);
                    Log.w((String)PangleMediationAdapter.TAG, (String)error.toString());
                    PangleBannerAd.this.adLoadCallback.onFailure(error);
                    return;
                }
                PangleBannerAd.this.wrappedAdView = new FrameLayout(context);
                PAGBannerRequest request = PangleBannerAd.this.pangleFactory.createPagBannerRequest(bannerSize);
                request.setAdString(bidResponse);
                PangleRequestHelper.setWatermarkString((PAGRequest)request, bidResponse, (MediationAdConfiguration)PangleBannerAd.this.adConfiguration);
                PangleBannerAd.this.pangleSdkWrapper.loadBannerAd(placementId, request, new PAGBannerAdLoadListener(){

                    public void onError(int errorCode, String errorMessage) {
                        AdError error = PangleConstants.createSdkError(errorCode, errorMessage);
                        Log.w((String)PangleMediationAdapter.TAG, (String)error.toString());
                        PangleBannerAd.this.adLoadCallback.onFailure(error);
                    }

                    public void onAdLoaded(PAGBannerAd pagBannerAd) {
                        pagBannerAd.setAdInteractionListener((PAGBannerAdInteractionListener)PangleBannerAd.this);
                        PangleBannerAd.this.wrappedAdView.addView(pagBannerAd.getBannerView());
                        PangleBannerAd.this.bannerAdCallback = (MediationBannerAdCallback)PangleBannerAd.this.adLoadCallback.onSuccess((Object)PangleBannerAd.this);
                    }
                });
            }

            @Override
            public void onInitializeError(@NonNull AdError error) {
                Log.w((String)PangleMediationAdapter.TAG, (String)error.toString());
                PangleBannerAd.this.adLoadCallback.onFailure(error);
            }
        });
    }

    @NonNull
    public View getView() {
        return this.wrappedAdView;
    }

    public void onAdShowed() {
        if (this.bannerAdCallback != null) {
            this.bannerAdCallback.reportAdImpression();
        }
    }

    public void onAdClicked() {
        if (this.bannerAdCallback != null) {
            this.bannerAdCallback.reportAdClicked();
        }
    }

    public void onAdDismissed() {
    }

    static PAGBannerSize getBannerSizeFromGoogleAdSize(Context context, AdSize adSize) {
        if (adSize != null) {
            if (adSize.getWidth() == PAGBannerSize.BANNER_W_320_H_50.getWidth() && adSize.getHeight() == PAGBannerSize.BANNER_W_320_H_50.getHeight()) {
                return PAGBannerSize.BANNER_W_320_H_50;
            }
            if (adSize.getWidth() == PAGBannerSize.BANNER_W_300_H_250.getWidth() && adSize.getHeight() == PAGBannerSize.BANNER_W_300_H_250.getHeight()) {
                return PAGBannerSize.BANNER_W_300_H_250;
            }
            if (adSize.getWidth() == PAGBannerSize.BANNER_W_728_H_90.getWidth() && adSize.getHeight() == PAGBannerSize.BANNER_W_728_H_90.getHeight()) {
                return PAGBannerSize.BANNER_W_728_H_90;
            }
            PAGBannerSize pagAnchoredSize = PAGBannerSize.getCurrentOrientationAnchoredAdaptiveBannerAdSize((Context)context, (int)adSize.getWidth());
            if (adSize.getWidth() == pagAnchoredSize.getWidth() && adSize.getHeight() == pagAnchoredSize.getHeight()) {
                return pagAnchoredSize;
            }
            return PAGBannerSize.getInlineAdaptiveBannerAdSize((int)adSize.getWidth(), (int)adSize.getHeight());
        }
        return null;
    }
}

