/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.mediation.pangle.renderer;

import android.app.Activity;
import android.content.Context;
import android.os.Bundle;
import android.text.TextUtils;
import android.util.Log;
import androidx.annotation.NonNull;
import com.bytedance.sdk.openadsdk.api.PAGRequest;
import com.bytedance.sdk.openadsdk.api.interstitial.PAGInterstitialAd;
import com.bytedance.sdk.openadsdk.api.interstitial.PAGInterstitialAdInteractionListener;
import com.bytedance.sdk.openadsdk.api.interstitial.PAGInterstitialAdLoadListener;
import com.bytedance.sdk.openadsdk.api.interstitial.PAGInterstitialRequest;
import com.google.ads.mediation.pangle.PangleConstants;
import com.google.ads.mediation.pangle.PangleFactory;
import com.google.ads.mediation.pangle.PangleInitializer;
import com.google.ads.mediation.pangle.PangleMediationAdapter;
import com.google.ads.mediation.pangle.PangleRequestHelper;
import com.google.ads.mediation.pangle.PangleSdkWrapper;
import com.google.android.gms.ads.AdError;
import com.google.android.gms.ads.mediation.MediationAdConfiguration;
import com.google.android.gms.ads.mediation.MediationAdLoadCallback;
import com.google.android.gms.ads.mediation.MediationInterstitialAd;
import com.google.android.gms.ads.mediation.MediationInterstitialAdCallback;
import com.google.android.gms.ads.mediation.MediationInterstitialAdConfiguration;

public class PangleInterstitialAd
implements MediationInterstitialAd {
    private final MediationInterstitialAdConfiguration adConfiguration;
    private final MediationAdLoadCallback<MediationInterstitialAd, MediationInterstitialAdCallback> adLoadCallback;
    private final PangleInitializer pangleInitializer;
    private final PangleSdkWrapper pangleSdkWrapper;
    private final PangleFactory pangleFactory;
    private MediationInterstitialAdCallback interstitialAdCallback;
    private PAGInterstitialAd pagInterstitialAd;

    public PangleInterstitialAd(@NonNull MediationInterstitialAdConfiguration mediationInterstitialAdConfiguration, @NonNull MediationAdLoadCallback<MediationInterstitialAd, MediationInterstitialAdCallback> mediationAdLoadCallback, @NonNull PangleInitializer pangleInitializer, PangleSdkWrapper pangleSdkWrapper, PangleFactory pangleFactory) {
        this.adConfiguration = mediationInterstitialAdConfiguration;
        this.adLoadCallback = mediationAdLoadCallback;
        this.pangleInitializer = pangleInitializer;
        this.pangleSdkWrapper = pangleSdkWrapper;
        this.pangleFactory = pangleFactory;
    }

    public void render() {
        Bundle serverParameters = this.adConfiguration.getServerParameters();
        final String placementId = serverParameters.getString("placementid");
        if (TextUtils.isEmpty((CharSequence)placementId)) {
            AdError error = PangleConstants.createAdapterError(101, "Failed to load interstitial ad from Pangle. Missing or invalid Placement ID.");
            Log.e((String)PangleMediationAdapter.TAG, (String)error.toString());
            this.adLoadCallback.onFailure(error);
            return;
        }
        final String bidResponse = this.adConfiguration.getBidResponse();
        Context context = this.adConfiguration.getContext();
        String appId = serverParameters.getString("appid");
        this.pangleInitializer.initialize(context, appId, new PangleInitializer.Listener(){

            @Override
            public void onInitializeSuccess() {
                PAGInterstitialRequest request = PangleInterstitialAd.this.pangleFactory.createPagInterstitialRequest();
                request.setAdString(bidResponse);
                PangleRequestHelper.setWatermarkString((PAGRequest)request, bidResponse, (MediationAdConfiguration)PangleInterstitialAd.this.adConfiguration);
                PangleInterstitialAd.this.pangleSdkWrapper.loadInterstitialAd(placementId, request, new PAGInterstitialAdLoadListener(){

                    public void onError(int errorCode, String errorMessage) {
                        AdError error = PangleConstants.createSdkError(errorCode, errorMessage);
                        Log.w((String)PangleMediationAdapter.TAG, (String)error.toString());
                        PangleInterstitialAd.this.adLoadCallback.onFailure(error);
                    }

                    public void onAdLoaded(PAGInterstitialAd interstitialAd) {
                        PangleInterstitialAd.this.interstitialAdCallback = (MediationInterstitialAdCallback)PangleInterstitialAd.this.adLoadCallback.onSuccess((Object)PangleInterstitialAd.this);
                        PangleInterstitialAd.this.pagInterstitialAd = interstitialAd;
                    }
                });
            }

            @Override
            public void onInitializeError(@NonNull AdError error) {
                Log.w((String)PangleMediationAdapter.TAG, (String)error.toString());
                PangleInterstitialAd.this.adLoadCallback.onFailure(error);
            }
        });
    }

    public void showAd(@NonNull Context context) {
        this.pagInterstitialAd.setAdInteractionListener(new PAGInterstitialAdInteractionListener(){

            public void onAdShowed() {
                if (PangleInterstitialAd.this.interstitialAdCallback != null) {
                    PangleInterstitialAd.this.interstitialAdCallback.onAdOpened();
                    PangleInterstitialAd.this.interstitialAdCallback.reportAdImpression();
                }
            }

            public void onAdClicked() {
                if (PangleInterstitialAd.this.interstitialAdCallback != null) {
                    PangleInterstitialAd.this.interstitialAdCallback.reportAdClicked();
                }
            }

            public void onAdDismissed() {
                if (PangleInterstitialAd.this.interstitialAdCallback != null) {
                    PangleInterstitialAd.this.interstitialAdCallback.onAdClosed();
                }
            }
        });
        if (context instanceof Activity) {
            this.pagInterstitialAd.show((Activity)context);
            return;
        }
        this.pagInterstitialAd.show(null);
    }
}

