/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.mediation.pangle;

import android.content.Context;
import android.text.TextUtils;
import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.VisibleForTesting;
import com.bytedance.sdk.openadsdk.api.init.PAGConfig;
import com.bytedance.sdk.openadsdk.api.init.PAGSdk;
import com.google.ads.mediation.pangle.PangleConstants;
import com.google.ads.mediation.pangle.PangleFactory;
import com.google.ads.mediation.pangle.PangleMediationAdapter;
import com.google.ads.mediation.pangle.PangleSdkWrapper;
import com.google.android.gms.ads.AdError;
import java.util.ArrayList;

public class PangleInitializer
implements PAGSdk.PAGInitCallback {
    private static PangleInitializer instance;
    private boolean isInitializing = false;
    private boolean isInitialized = false;
    private final ArrayList<Listener> initListeners = new ArrayList();
    private final PangleSdkWrapper pangleSdkWrapper;
    private final PangleFactory pangleFactory;

    @NonNull
    public static PangleInitializer getInstance() {
        if (instance == null) {
            instance = new PangleInitializer();
        }
        return instance;
    }

    private PangleInitializer() {
        this.pangleSdkWrapper = new PangleSdkWrapper();
        this.pangleFactory = new PangleFactory();
    }

    @VisibleForTesting
    public PangleInitializer(PangleSdkWrapper pangleSdkWrapper, PangleFactory pangleFactory) {
        this.pangleSdkWrapper = pangleSdkWrapper;
        this.pangleFactory = pangleFactory;
    }

    public void initialize(@NonNull Context context, @NonNull String appId, @NonNull Listener listener) {
        if (TextUtils.isEmpty((CharSequence)appId)) {
            AdError error = PangleConstants.createAdapterError(101, "Failed to initialize Pangle SDK. Missing or invalid App ID.");
            Log.w((String)PangleMediationAdapter.TAG, (String)error.toString());
            listener.onInitializeError(error);
            return;
        }
        if (this.isInitializing) {
            this.initListeners.add(listener);
            return;
        }
        if (this.isInitialized) {
            listener.onInitializeSuccess();
            return;
        }
        this.isInitializing = true;
        this.initListeners.add(listener);
        PAGConfig adConfig = this.pangleFactory.createPAGConfigBuilder().appId(appId).setAdxId("207").setGDPRConsent(PangleMediationAdapter.getGDPRConsent()).setUserData(String.format("[{\"name\":\"mediation\",\"value\":\"google\"},{\"name\":\"adapter_version\",\"value\":\"%s\"}]", "7.6.0.4.0")).build();
        this.pangleSdkWrapper.init(context, adConfig, this);
    }

    public void success() {
        this.isInitializing = false;
        this.isInitialized = true;
        for (Listener listener : this.initListeners) {
            listener.onInitializeSuccess();
        }
        this.initListeners.clear();
    }

    public void fail(int errorCode, @NonNull String errorMessage) {
        this.isInitializing = false;
        this.isInitialized = false;
        AdError error = PangleConstants.createSdkError(errorCode, errorMessage);
        for (Listener listener : this.initListeners) {
            listener.onInitializeError(error);
        }
        this.initListeners.clear();
    }

    public static interface Listener {
        public void onInitializeSuccess();

        public void onInitializeError(@NonNull AdError var1);
    }
}

