/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.mediation.pangle.renderer;

import android.app.Activity;
import android.content.Context;
import android.os.Bundle;
import android.text.TextUtils;
import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.VisibleForTesting;
import com.bytedance.sdk.openadsdk.api.PAGRequest;
import com.bytedance.sdk.openadsdk.api.open.PAGAppOpenAd;
import com.bytedance.sdk.openadsdk.api.open.PAGAppOpenAdInteractionListener;
import com.bytedance.sdk.openadsdk.api.open.PAGAppOpenAdLoadListener;
import com.bytedance.sdk.openadsdk.api.open.PAGAppOpenRequest;
import com.google.ads.mediation.pangle.PangleConstants;
import com.google.ads.mediation.pangle.PangleFactory;
import com.google.ads.mediation.pangle.PangleInitializer;
import com.google.ads.mediation.pangle.PangleMediationAdapter;
import com.google.ads.mediation.pangle.PangleRequestHelper;
import com.google.ads.mediation.pangle.PangleSdkWrapper;
import com.google.android.gms.ads.AdError;
import com.google.android.gms.ads.mediation.MediationAdConfiguration;
import com.google.android.gms.ads.mediation.MediationAdLoadCallback;
import com.google.android.gms.ads.mediation.MediationAppOpenAd;
import com.google.android.gms.ads.mediation.MediationAppOpenAdCallback;
import com.google.android.gms.ads.mediation.MediationAppOpenAdConfiguration;

public class PangleAppOpenAd
implements MediationAppOpenAd {
    @VisibleForTesting
    static final String ERROR_MSG_INVALID_PLACEMENT_ID = "Failed to load app open ad from Pangle. Missing or invalid Placement ID.";
    private final MediationAppOpenAdConfiguration adConfiguration;
    private final MediationAdLoadCallback<MediationAppOpenAd, MediationAppOpenAdCallback> adLoadCallback;
    private final PangleInitializer pangleInitializer;
    private final PangleSdkWrapper pangleSdkWrapper;
    private final PangleFactory pangleFactory;
    private MediationAppOpenAdCallback appOpenAdCallback;
    private PAGAppOpenAd pagAppOpenAd;

    public PangleAppOpenAd(@NonNull MediationAppOpenAdConfiguration mediationAppOpenAdConfiguration, @NonNull MediationAdLoadCallback<MediationAppOpenAd, MediationAppOpenAdCallback> mediationAdLoadCallback, @NonNull PangleInitializer pangleInitializer, @NonNull PangleSdkWrapper pangleSdkWrapper, @NonNull PangleFactory pangleFactory) {
        this.adConfiguration = mediationAppOpenAdConfiguration;
        this.adLoadCallback = mediationAdLoadCallback;
        this.pangleInitializer = pangleInitializer;
        this.pangleSdkWrapper = pangleSdkWrapper;
        this.pangleFactory = pangleFactory;
    }

    public void render() {
        Bundle serverParameters = this.adConfiguration.getServerParameters();
        final String placementId = serverParameters.getString("placementid");
        if (TextUtils.isEmpty((CharSequence)placementId)) {
            AdError error = PangleConstants.createAdapterError(101, ERROR_MSG_INVALID_PLACEMENT_ID);
            Log.e((String)PangleMediationAdapter.TAG, (String)error.toString());
            this.adLoadCallback.onFailure(error);
            return;
        }
        final String bidResponse = this.adConfiguration.getBidResponse();
        Context context = this.adConfiguration.getContext();
        String appId = serverParameters.getString("appid");
        this.pangleInitializer.initialize(context, appId, new PangleInitializer.Listener(){

            @Override
            public void onInitializeSuccess() {
                PAGAppOpenRequest request = PangleAppOpenAd.this.pangleFactory.createPagAppOpenRequest();
                request.setAdString(bidResponse);
                PangleRequestHelper.setWatermarkString((PAGRequest)request, bidResponse, (MediationAdConfiguration)PangleAppOpenAd.this.adConfiguration);
                PangleAppOpenAd.this.pangleSdkWrapper.loadAppOpenAd(placementId, request, new PAGAppOpenAdLoadListener(){

                    public void onError(int errorCode, String errorMessage) {
                        AdError error = PangleConstants.createSdkError(errorCode, errorMessage);
                        Log.w((String)PangleMediationAdapter.TAG, (String)error.toString());
                        PangleAppOpenAd.this.adLoadCallback.onFailure(error);
                    }

                    public void onAdLoaded(PAGAppOpenAd appOpenAd) {
                        PangleAppOpenAd.this.appOpenAdCallback = (MediationAppOpenAdCallback)PangleAppOpenAd.this.adLoadCallback.onSuccess((Object)PangleAppOpenAd.this);
                        PangleAppOpenAd.this.pagAppOpenAd = appOpenAd;
                    }
                });
            }

            @Override
            public void onInitializeError(@NonNull AdError error) {
                Log.w((String)PangleMediationAdapter.TAG, (String)error.toString());
                PangleAppOpenAd.this.adLoadCallback.onFailure(error);
            }
        });
    }

    public void showAd(@NonNull Context context) {
        this.pagAppOpenAd.setAdInteractionListener(new PAGAppOpenAdInteractionListener(){

            public void onAdShowed() {
                if (PangleAppOpenAd.this.appOpenAdCallback != null) {
                    PangleAppOpenAd.this.appOpenAdCallback.onAdOpened();
                    PangleAppOpenAd.this.appOpenAdCallback.reportAdImpression();
                }
            }

            public void onAdClicked() {
                if (PangleAppOpenAd.this.appOpenAdCallback != null) {
                    PangleAppOpenAd.this.appOpenAdCallback.reportAdClicked();
                }
            }

            public void onAdDismissed() {
                if (PangleAppOpenAd.this.appOpenAdCallback != null) {
                    PangleAppOpenAd.this.appOpenAdCallback.onAdClosed();
                }
            }
        });
        if (context instanceof Activity) {
            this.pagAppOpenAd.show((Activity)context);
            return;
        }
        this.pagAppOpenAd.show(null);
    }
}

