/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2;

import android.net.Uri;
import android.os.Bundle;
import androidx.annotation.IntRange;
import androidx.annotation.Nullable;
import com.google.android.exoplayer2.Bundleable;
import com.google.android.exoplayer2.MediaMetadata;
import com.google.android.exoplayer2.offline.StreamKey;
import com.google.android.exoplayer2.util.Assertions;
import com.google.android.exoplayer2.util.Util;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.UUID;

public final class MediaItem
implements Bundleable {
    public static final String DEFAULT_MEDIA_ID = "";
    public static final MediaItem EMPTY = new Builder().build();
    public final String mediaId;
    @Nullable
    public final LocalConfiguration localConfiguration;
    @Deprecated
    @Nullable
    public final PlaybackProperties playbackProperties;
    public final LiveConfiguration liveConfiguration;
    public final MediaMetadata mediaMetadata;
    public final ClippingConfiguration clippingConfiguration;
    @Deprecated
    public final ClippingProperties clippingProperties;
    private static final int FIELD_MEDIA_ID = 0;
    private static final int FIELD_LIVE_CONFIGURATION = 1;
    private static final int FIELD_MEDIA_METADATA = 2;
    private static final int FIELD_CLIPPING_PROPERTIES = 3;
    public static final Bundleable.Creator<MediaItem> CREATOR = MediaItem::fromBundle;

    public static MediaItem fromUri(String uri) {
        return new Builder().setUri(uri).build();
    }

    public static MediaItem fromUri(Uri uri) {
        return new Builder().setUri(uri).build();
    }

    private MediaItem(String mediaId, ClippingProperties clippingConfiguration, @Nullable PlaybackProperties localConfiguration, LiveConfiguration liveConfiguration, MediaMetadata mediaMetadata) {
        this.mediaId = mediaId;
        this.localConfiguration = localConfiguration;
        this.playbackProperties = localConfiguration;
        this.liveConfiguration = liveConfiguration;
        this.mediaMetadata = mediaMetadata;
        this.clippingConfiguration = clippingConfiguration;
        this.clippingProperties = clippingConfiguration;
    }

    public Builder buildUpon() {
        return new Builder(this);
    }

    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof MediaItem)) {
            return false;
        }
        MediaItem other = (MediaItem)obj;
        return Util.areEqual(this.mediaId, other.mediaId) && this.clippingConfiguration.equals(other.clippingConfiguration) && Util.areEqual(this.localConfiguration, other.localConfiguration) && Util.areEqual(this.liveConfiguration, other.liveConfiguration) && Util.areEqual(this.mediaMetadata, other.mediaMetadata);
    }

    public int hashCode() {
        int result = this.mediaId.hashCode();
        result = 31 * result + (this.localConfiguration != null ? this.localConfiguration.hashCode() : 0);
        result = 31 * result + this.liveConfiguration.hashCode();
        result = 31 * result + this.clippingConfiguration.hashCode();
        result = 31 * result + this.mediaMetadata.hashCode();
        return result;
    }

    @Override
    public Bundle toBundle() {
        Bundle bundle = new Bundle();
        bundle.putString(MediaItem.keyForField(0), this.mediaId);
        bundle.putBundle(MediaItem.keyForField(1), this.liveConfiguration.toBundle());
        bundle.putBundle(MediaItem.keyForField(2), this.mediaMetadata.toBundle());
        bundle.putBundle(MediaItem.keyForField(3), this.clippingConfiguration.toBundle());
        return bundle;
    }

    private static MediaItem fromBundle(Bundle bundle) {
        String mediaId = Assertions.checkNotNull(bundle.getString(MediaItem.keyForField(0), DEFAULT_MEDIA_ID));
        Bundle liveConfigurationBundle = bundle.getBundle(MediaItem.keyForField(1));
        LiveConfiguration liveConfiguration = liveConfigurationBundle == null ? LiveConfiguration.UNSET : LiveConfiguration.CREATOR.fromBundle(liveConfigurationBundle);
        Bundle mediaMetadataBundle = bundle.getBundle(MediaItem.keyForField(2));
        MediaMetadata mediaMetadata = mediaMetadataBundle == null ? MediaMetadata.EMPTY : MediaMetadata.CREATOR.fromBundle(mediaMetadataBundle);
        Bundle clippingConfigurationBundle = bundle.getBundle(MediaItem.keyForField(3));
        ClippingProperties clippingConfiguration = clippingConfigurationBundle == null ? ClippingProperties.UNSET : ClippingConfiguration.CREATOR.fromBundle(clippingConfigurationBundle);
        return new MediaItem(mediaId, clippingConfiguration, null, liveConfiguration, mediaMetadata);
    }

    private static String keyForField(int field) {
        return Integer.toString(field, 36);
    }

    @Deprecated
    public static final class ClippingProperties
    extends ClippingConfiguration {
        public static final ClippingProperties UNSET = new ClippingConfiguration.Builder().buildClippingProperties();

        private ClippingProperties(ClippingConfiguration.Builder builder) {
            super(builder);
        }
    }

    public static class ClippingConfiguration
    implements Bundleable {
        public static final ClippingConfiguration UNSET = new Builder().build();
        @IntRange(from=0L)
        public final long startPositionMs;
        public final long endPositionMs;
        public final boolean relativeToLiveWindow;
        public final boolean relativeToDefaultPosition;
        public final boolean startsAtKeyFrame;
        private static final int FIELD_START_POSITION_MS = 0;
        private static final int FIELD_END_POSITION_MS = 1;
        private static final int FIELD_RELATIVE_TO_LIVE_WINDOW = 2;
        private static final int FIELD_RELATIVE_TO_DEFAULT_POSITION = 3;
        private static final int FIELD_STARTS_AT_KEY_FRAME = 4;
        public static final Bundleable.Creator<ClippingProperties> CREATOR = bundle -> new Builder().setStartPositionMs(bundle.getLong(ClippingConfiguration.keyForField(0), 0L)).setEndPositionMs(bundle.getLong(ClippingConfiguration.keyForField(1), Long.MIN_VALUE)).setRelativeToLiveWindow(bundle.getBoolean(ClippingConfiguration.keyForField(2), false)).setRelativeToDefaultPosition(bundle.getBoolean(ClippingConfiguration.keyForField(3), false)).setStartsAtKeyFrame(bundle.getBoolean(ClippingConfiguration.keyForField(4), false)).buildClippingProperties();

        private ClippingConfiguration(Builder builder) {
            this.startPositionMs = builder.startPositionMs;
            this.endPositionMs = builder.endPositionMs;
            this.relativeToLiveWindow = builder.relativeToLiveWindow;
            this.relativeToDefaultPosition = builder.relativeToDefaultPosition;
            this.startsAtKeyFrame = builder.startsAtKeyFrame;
        }

        public Builder buildUpon() {
            return new Builder(this);
        }

        public boolean equals(@Nullable Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof ClippingConfiguration)) {
                return false;
            }
            ClippingConfiguration other = (ClippingConfiguration)obj;
            return this.startPositionMs == other.startPositionMs && this.endPositionMs == other.endPositionMs && this.relativeToLiveWindow == other.relativeToLiveWindow && this.relativeToDefaultPosition == other.relativeToDefaultPosition && this.startsAtKeyFrame == other.startsAtKeyFrame;
        }

        public int hashCode() {
            int result = (int)(this.startPositionMs ^ this.startPositionMs >>> 32);
            result = 31 * result + (int)(this.endPositionMs ^ this.endPositionMs >>> 32);
            result = 31 * result + (this.relativeToLiveWindow ? 1 : 0);
            result = 31 * result + (this.relativeToDefaultPosition ? 1 : 0);
            result = 31 * result + (this.startsAtKeyFrame ? 1 : 0);
            return result;
        }

        @Override
        public Bundle toBundle() {
            Bundle bundle = new Bundle();
            bundle.putLong(ClippingConfiguration.keyForField(0), this.startPositionMs);
            bundle.putLong(ClippingConfiguration.keyForField(1), this.endPositionMs);
            bundle.putBoolean(ClippingConfiguration.keyForField(2), this.relativeToLiveWindow);
            bundle.putBoolean(ClippingConfiguration.keyForField(3), this.relativeToDefaultPosition);
            bundle.putBoolean(ClippingConfiguration.keyForField(4), this.startsAtKeyFrame);
            return bundle;
        }

        private static String keyForField(int field) {
            return Integer.toString(field, 36);
        }

        public static final class Builder {
            private long startPositionMs;
            private long endPositionMs;
            private boolean relativeToLiveWindow;
            private boolean relativeToDefaultPosition;
            private boolean startsAtKeyFrame;

            public Builder() {
                this.endPositionMs = Long.MIN_VALUE;
            }

            private Builder(ClippingConfiguration clippingConfiguration) {
                this.startPositionMs = clippingConfiguration.startPositionMs;
                this.endPositionMs = clippingConfiguration.endPositionMs;
                this.relativeToLiveWindow = clippingConfiguration.relativeToLiveWindow;
                this.relativeToDefaultPosition = clippingConfiguration.relativeToDefaultPosition;
                this.startsAtKeyFrame = clippingConfiguration.startsAtKeyFrame;
            }

            public Builder setStartPositionMs(@IntRange(from=0L) long startPositionMs) {
                Assertions.checkArgument(startPositionMs >= 0L);
                this.startPositionMs = startPositionMs;
                return this;
            }

            public Builder setEndPositionMs(long endPositionMs) {
                Assertions.checkArgument(endPositionMs == Long.MIN_VALUE || endPositionMs >= 0L);
                this.endPositionMs = endPositionMs;
                return this;
            }

            public Builder setRelativeToLiveWindow(boolean relativeToLiveWindow) {
                this.relativeToLiveWindow = relativeToLiveWindow;
                return this;
            }

            public Builder setRelativeToDefaultPosition(boolean relativeToDefaultPosition) {
                this.relativeToDefaultPosition = relativeToDefaultPosition;
                return this;
            }

            public Builder setStartsAtKeyFrame(boolean startsAtKeyFrame) {
                this.startsAtKeyFrame = startsAtKeyFrame;
                return this;
            }

            public ClippingConfiguration build() {
                return this.buildClippingProperties();
            }

            @Deprecated
            public ClippingProperties buildClippingProperties() {
                return new ClippingProperties(this);
            }
        }
    }

    @Deprecated
    public static final class Subtitle
    extends SubtitleConfiguration {
        @Deprecated
        public Subtitle(Uri uri, String mimeType, @Nullable String language) {
            this(uri, mimeType, language, 0);
        }

        @Deprecated
        public Subtitle(Uri uri, String mimeType, @Nullable String language, int selectionFlags) {
            this(uri, mimeType, language, selectionFlags, 0, null);
        }

        @Deprecated
        public Subtitle(Uri uri, String mimeType, @Nullable String language, int selectionFlags, int roleFlags, @Nullable String label) {
            super(uri, mimeType, language, selectionFlags, roleFlags, label);
        }

        private Subtitle(SubtitleConfiguration.Builder builder) {
            super(builder);
        }
    }

    public static class SubtitleConfiguration {
        public final Uri uri;
        @Nullable
        public final String mimeType;
        @Nullable
        public final String language;
        public final int selectionFlags;
        public final int roleFlags;
        @Nullable
        public final String label;

        private SubtitleConfiguration(Uri uri, String mimeType, @Nullable String language, int selectionFlags, int roleFlags, @Nullable String label) {
            this.uri = uri;
            this.mimeType = mimeType;
            this.language = language;
            this.selectionFlags = selectionFlags;
            this.roleFlags = roleFlags;
            this.label = label;
        }

        private SubtitleConfiguration(Builder builder) {
            this.uri = builder.uri;
            this.mimeType = builder.mimeType;
            this.language = builder.language;
            this.selectionFlags = builder.selectionFlags;
            this.roleFlags = builder.roleFlags;
            this.label = builder.label;
        }

        public Builder buildUpon() {
            return new Builder(this);
        }

        public boolean equals(@Nullable Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof SubtitleConfiguration)) {
                return false;
            }
            SubtitleConfiguration other = (SubtitleConfiguration)obj;
            return this.uri.equals((Object)other.uri) && Util.areEqual(this.mimeType, other.mimeType) && Util.areEqual(this.language, other.language) && this.selectionFlags == other.selectionFlags && this.roleFlags == other.roleFlags && Util.areEqual(this.label, other.label);
        }

        public int hashCode() {
            int result = this.uri.hashCode();
            result = 31 * result + (this.mimeType == null ? 0 : this.mimeType.hashCode());
            result = 31 * result + (this.language == null ? 0 : this.language.hashCode());
            result = 31 * result + this.selectionFlags;
            result = 31 * result + this.roleFlags;
            result = 31 * result + (this.label == null ? 0 : this.label.hashCode());
            return result;
        }

        public static final class Builder {
            private Uri uri;
            @Nullable
            private String mimeType;
            @Nullable
            private String language;
            private int selectionFlags;
            private int roleFlags;
            @Nullable
            private String label;

            public Builder(Uri uri) {
                this.uri = uri;
            }

            private Builder(SubtitleConfiguration subtitleConfiguration) {
                this.uri = subtitleConfiguration.uri;
                this.mimeType = subtitleConfiguration.mimeType;
                this.language = subtitleConfiguration.language;
                this.selectionFlags = subtitleConfiguration.selectionFlags;
                this.roleFlags = subtitleConfiguration.roleFlags;
                this.label = subtitleConfiguration.label;
            }

            public Builder setUri(Uri uri) {
                this.uri = uri;
                return this;
            }

            public Builder setMimeType(String mimeType) {
                this.mimeType = mimeType;
                return this;
            }

            public Builder setLanguage(@Nullable String language) {
                this.language = language;
                return this;
            }

            public Builder setSelectionFlags(int selectionFlags) {
                this.selectionFlags = selectionFlags;
                return this;
            }

            public Builder setRoleFlags(int roleFlags) {
                this.roleFlags = roleFlags;
                return this;
            }

            public Builder setLabel(@Nullable String label) {
                this.label = label;
                return this;
            }

            public SubtitleConfiguration build() {
                return new SubtitleConfiguration(this);
            }

            private Subtitle buildSubtitle() {
                return new Subtitle(this);
            }
        }
    }

    public static final class LiveConfiguration
    implements Bundleable {
        public static final LiveConfiguration UNSET = new Builder().build();
        public final long targetOffsetMs;
        public final long minOffsetMs;
        public final long maxOffsetMs;
        public final float minPlaybackSpeed;
        public final float maxPlaybackSpeed;
        private static final int FIELD_TARGET_OFFSET_MS = 0;
        private static final int FIELD_MIN_OFFSET_MS = 1;
        private static final int FIELD_MAX_OFFSET_MS = 2;
        private static final int FIELD_MIN_PLAYBACK_SPEED = 3;
        private static final int FIELD_MAX_PLAYBACK_SPEED = 4;
        public static final Bundleable.Creator<LiveConfiguration> CREATOR = bundle -> new LiveConfiguration(bundle.getLong(LiveConfiguration.keyForField(0), -9223372036854775807L), bundle.getLong(LiveConfiguration.keyForField(1), -9223372036854775807L), bundle.getLong(LiveConfiguration.keyForField(2), -9223372036854775807L), bundle.getFloat(LiveConfiguration.keyForField(3), -3.4028235E38f), bundle.getFloat(LiveConfiguration.keyForField(4), -3.4028235E38f));

        private LiveConfiguration(Builder builder) {
            this(builder.targetOffsetMs, builder.minOffsetMs, builder.maxOffsetMs, builder.minPlaybackSpeed, builder.maxPlaybackSpeed);
        }

        @Deprecated
        public LiveConfiguration(long targetOffsetMs, long minOffsetMs, long maxOffsetMs, float minPlaybackSpeed, float maxPlaybackSpeed) {
            this.targetOffsetMs = targetOffsetMs;
            this.minOffsetMs = minOffsetMs;
            this.maxOffsetMs = maxOffsetMs;
            this.minPlaybackSpeed = minPlaybackSpeed;
            this.maxPlaybackSpeed = maxPlaybackSpeed;
        }

        public Builder buildUpon() {
            return new Builder(this);
        }

        public boolean equals(@Nullable Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof LiveConfiguration)) {
                return false;
            }
            LiveConfiguration other = (LiveConfiguration)obj;
            return this.targetOffsetMs == other.targetOffsetMs && this.minOffsetMs == other.minOffsetMs && this.maxOffsetMs == other.maxOffsetMs && this.minPlaybackSpeed == other.minPlaybackSpeed && this.maxPlaybackSpeed == other.maxPlaybackSpeed;
        }

        public int hashCode() {
            int result = (int)(this.targetOffsetMs ^ this.targetOffsetMs >>> 32);
            result = 31 * result + (int)(this.minOffsetMs ^ this.minOffsetMs >>> 32);
            result = 31 * result + (int)(this.maxOffsetMs ^ this.maxOffsetMs >>> 32);
            result = 31 * result + (this.minPlaybackSpeed != 0.0f ? Float.floatToIntBits(this.minPlaybackSpeed) : 0);
            result = 31 * result + (this.maxPlaybackSpeed != 0.0f ? Float.floatToIntBits(this.maxPlaybackSpeed) : 0);
            return result;
        }

        @Override
        public Bundle toBundle() {
            Bundle bundle = new Bundle();
            bundle.putLong(LiveConfiguration.keyForField(0), this.targetOffsetMs);
            bundle.putLong(LiveConfiguration.keyForField(1), this.minOffsetMs);
            bundle.putLong(LiveConfiguration.keyForField(2), this.maxOffsetMs);
            bundle.putFloat(LiveConfiguration.keyForField(3), this.minPlaybackSpeed);
            bundle.putFloat(LiveConfiguration.keyForField(4), this.maxPlaybackSpeed);
            return bundle;
        }

        private static String keyForField(int field) {
            return Integer.toString(field, 36);
        }

        public static final class Builder {
            private long targetOffsetMs;
            private long minOffsetMs;
            private long maxOffsetMs;
            private float minPlaybackSpeed;
            private float maxPlaybackSpeed;

            public Builder() {
                this.targetOffsetMs = -9223372036854775807L;
                this.minOffsetMs = -9223372036854775807L;
                this.maxOffsetMs = -9223372036854775807L;
                this.minPlaybackSpeed = -3.4028235E38f;
                this.maxPlaybackSpeed = -3.4028235E38f;
            }

            private Builder(LiveConfiguration liveConfiguration) {
                this.targetOffsetMs = liveConfiguration.targetOffsetMs;
                this.minOffsetMs = liveConfiguration.minOffsetMs;
                this.maxOffsetMs = liveConfiguration.maxOffsetMs;
                this.minPlaybackSpeed = liveConfiguration.minPlaybackSpeed;
                this.maxPlaybackSpeed = liveConfiguration.maxPlaybackSpeed;
            }

            public Builder setTargetOffsetMs(long targetOffsetMs) {
                this.targetOffsetMs = targetOffsetMs;
                return this;
            }

            public Builder setMinOffsetMs(long minOffsetMs) {
                this.minOffsetMs = minOffsetMs;
                return this;
            }

            public Builder setMaxOffsetMs(long maxOffsetMs) {
                this.maxOffsetMs = maxOffsetMs;
                return this;
            }

            public Builder setMinPlaybackSpeed(float minPlaybackSpeed) {
                this.minPlaybackSpeed = minPlaybackSpeed;
                return this;
            }

            public Builder setMaxPlaybackSpeed(float maxPlaybackSpeed) {
                this.maxPlaybackSpeed = maxPlaybackSpeed;
                return this;
            }

            public LiveConfiguration build() {
                return new LiveConfiguration(this);
            }
        }
    }

    @Deprecated
    public static final class PlaybackProperties
    extends LocalConfiguration {
        private PlaybackProperties(Uri uri, @Nullable String mimeType, @Nullable DrmConfiguration drmConfiguration, @Nullable AdsConfiguration adsConfiguration, List<StreamKey> streamKeys, @Nullable String customCacheKey, ImmutableList<SubtitleConfiguration> subtitleConfigurations, @Nullable Object tag) {
            super(uri, mimeType, drmConfiguration, adsConfiguration, streamKeys, customCacheKey, subtitleConfigurations, tag);
        }
    }

    public static class LocalConfiguration {
        public final Uri uri;
        @Nullable
        public final String mimeType;
        @Nullable
        public final DrmConfiguration drmConfiguration;
        @Nullable
        public final AdsConfiguration adsConfiguration;
        public final List<StreamKey> streamKeys;
        @Nullable
        public final String customCacheKey;
        public final ImmutableList<SubtitleConfiguration> subtitleConfigurations;
        @Deprecated
        public final List<Subtitle> subtitles;
        @Nullable
        public final Object tag;

        private LocalConfiguration(Uri uri, @Nullable String mimeType, @Nullable DrmConfiguration drmConfiguration, @Nullable AdsConfiguration adsConfiguration, List<StreamKey> streamKeys, @Nullable String customCacheKey, ImmutableList<SubtitleConfiguration> subtitleConfigurations, @Nullable Object tag) {
            this.uri = uri;
            this.mimeType = mimeType;
            this.drmConfiguration = drmConfiguration;
            this.adsConfiguration = adsConfiguration;
            this.streamKeys = streamKeys;
            this.customCacheKey = customCacheKey;
            this.subtitleConfigurations = subtitleConfigurations;
            ImmutableList.Builder subtitles = ImmutableList.builder();
            for (int i = 0; i < subtitleConfigurations.size(); ++i) {
                subtitles.add((Object)((SubtitleConfiguration)subtitleConfigurations.get(i)).buildUpon().buildSubtitle());
            }
            this.subtitles = subtitles.build();
            this.tag = tag;
        }

        public boolean equals(@Nullable Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof LocalConfiguration)) {
                return false;
            }
            LocalConfiguration other = (LocalConfiguration)obj;
            return this.uri.equals((Object)other.uri) && Util.areEqual(this.mimeType, other.mimeType) && Util.areEqual(this.drmConfiguration, other.drmConfiguration) && Util.areEqual(this.adsConfiguration, other.adsConfiguration) && this.streamKeys.equals(other.streamKeys) && Util.areEqual(this.customCacheKey, other.customCacheKey) && this.subtitleConfigurations.equals(other.subtitleConfigurations) && Util.areEqual(this.tag, other.tag);
        }

        public int hashCode() {
            int result = this.uri.hashCode();
            result = 31 * result + (this.mimeType == null ? 0 : this.mimeType.hashCode());
            result = 31 * result + (this.drmConfiguration == null ? 0 : this.drmConfiguration.hashCode());
            result = 31 * result + (this.adsConfiguration == null ? 0 : this.adsConfiguration.hashCode());
            result = 31 * result + this.streamKeys.hashCode();
            result = 31 * result + (this.customCacheKey == null ? 0 : this.customCacheKey.hashCode());
            result = 31 * result + this.subtitleConfigurations.hashCode();
            result = 31 * result + (this.tag == null ? 0 : this.tag.hashCode());
            return result;
        }
    }

    public static final class AdsConfiguration {
        public final Uri adTagUri;
        @Nullable
        public final Object adsId;

        private AdsConfiguration(Builder builder) {
            this.adTagUri = builder.adTagUri;
            this.adsId = builder.adsId;
        }

        public Builder buildUpon() {
            return new Builder(this.adTagUri).setAdsId(this.adsId);
        }

        public boolean equals(@Nullable Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof AdsConfiguration)) {
                return false;
            }
            AdsConfiguration other = (AdsConfiguration)obj;
            return this.adTagUri.equals((Object)other.adTagUri) && Util.areEqual(this.adsId, other.adsId);
        }

        public int hashCode() {
            int result = this.adTagUri.hashCode();
            result = 31 * result + (this.adsId != null ? this.adsId.hashCode() : 0);
            return result;
        }

        public static final class Builder {
            private Uri adTagUri;
            @Nullable
            private Object adsId;

            public Builder(Uri adTagUri) {
                this.adTagUri = adTagUri;
            }

            public Builder setAdTagUri(Uri adTagUri) {
                this.adTagUri = adTagUri;
                return this;
            }

            public Builder setAdsId(@Nullable Object adsId) {
                this.adsId = adsId;
                return this;
            }

            public AdsConfiguration build() {
                return new AdsConfiguration(this);
            }
        }
    }

    public static final class DrmConfiguration {
        public final UUID scheme;
        @Deprecated
        public final UUID uuid;
        @Nullable
        public final Uri licenseUri;
        @Deprecated
        public final ImmutableMap<String, String> requestHeaders;
        public final ImmutableMap<String, String> licenseRequestHeaders;
        public final boolean multiSession;
        public final boolean playClearContentWithoutKey;
        public final boolean forceDefaultLicenseUri;
        @Deprecated
        public final ImmutableList<Integer> sessionForClearTypes;
        public final ImmutableList<Integer> forcedSessionTrackTypes;
        @Nullable
        private final byte[] keySetId;

        private DrmConfiguration(Builder builder) {
            Assertions.checkState(!builder.forceDefaultLicenseUri || builder.licenseUri != null);
            this.uuid = this.scheme = Assertions.checkNotNull(builder.scheme);
            this.licenseUri = builder.licenseUri;
            this.requestHeaders = builder.licenseRequestHeaders;
            this.licenseRequestHeaders = builder.licenseRequestHeaders;
            this.multiSession = builder.multiSession;
            this.forceDefaultLicenseUri = builder.forceDefaultLicenseUri;
            this.playClearContentWithoutKey = builder.playClearContentWithoutKey;
            this.sessionForClearTypes = builder.forcedSessionTrackTypes;
            this.forcedSessionTrackTypes = builder.forcedSessionTrackTypes;
            this.keySetId = builder.keySetId != null ? Arrays.copyOf(builder.keySetId, builder.keySetId.length) : null;
        }

        @Nullable
        public byte[] getKeySetId() {
            return this.keySetId != null ? Arrays.copyOf(this.keySetId, this.keySetId.length) : null;
        }

        public Builder buildUpon() {
            return new Builder(this);
        }

        public boolean equals(@Nullable Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DrmConfiguration)) {
                return false;
            }
            DrmConfiguration other = (DrmConfiguration)obj;
            return this.scheme.equals(other.scheme) && Util.areEqual(this.licenseUri, other.licenseUri) && Util.areEqual(this.licenseRequestHeaders, other.licenseRequestHeaders) && this.multiSession == other.multiSession && this.forceDefaultLicenseUri == other.forceDefaultLicenseUri && this.playClearContentWithoutKey == other.playClearContentWithoutKey && this.forcedSessionTrackTypes.equals(other.forcedSessionTrackTypes) && Arrays.equals(this.keySetId, other.keySetId);
        }

        public int hashCode() {
            int result = this.scheme.hashCode();
            result = 31 * result + (this.licenseUri != null ? this.licenseUri.hashCode() : 0);
            result = 31 * result + this.licenseRequestHeaders.hashCode();
            result = 31 * result + (this.multiSession ? 1 : 0);
            result = 31 * result + (this.forceDefaultLicenseUri ? 1 : 0);
            result = 31 * result + (this.playClearContentWithoutKey ? 1 : 0);
            result = 31 * result + this.forcedSessionTrackTypes.hashCode();
            result = 31 * result + Arrays.hashCode(this.keySetId);
            return result;
        }

        public static final class Builder {
            @Nullable
            private UUID scheme;
            @Nullable
            private Uri licenseUri;
            private ImmutableMap<String, String> licenseRequestHeaders;
            private boolean multiSession;
            private boolean playClearContentWithoutKey;
            private boolean forceDefaultLicenseUri;
            private ImmutableList<Integer> forcedSessionTrackTypes;
            @Nullable
            private byte[] keySetId;

            public Builder(UUID scheme) {
                this.scheme = scheme;
                this.licenseRequestHeaders = ImmutableMap.of();
                this.forcedSessionTrackTypes = ImmutableList.of();
            }

            @Deprecated
            private Builder() {
                this.licenseRequestHeaders = ImmutableMap.of();
                this.forcedSessionTrackTypes = ImmutableList.of();
            }

            private Builder(DrmConfiguration drmConfiguration) {
                this.scheme = drmConfiguration.scheme;
                this.licenseUri = drmConfiguration.licenseUri;
                this.licenseRequestHeaders = drmConfiguration.licenseRequestHeaders;
                this.multiSession = drmConfiguration.multiSession;
                this.playClearContentWithoutKey = drmConfiguration.playClearContentWithoutKey;
                this.forceDefaultLicenseUri = drmConfiguration.forceDefaultLicenseUri;
                this.forcedSessionTrackTypes = drmConfiguration.forcedSessionTrackTypes;
                this.keySetId = drmConfiguration.keySetId;
            }

            public Builder setScheme(UUID scheme) {
                this.scheme = scheme;
                return this;
            }

            @Deprecated
            private Builder setNullableScheme(@Nullable UUID scheme) {
                this.scheme = scheme;
                return this;
            }

            public Builder setLicenseUri(@Nullable Uri licenseUri) {
                this.licenseUri = licenseUri;
                return this;
            }

            public Builder setLicenseUri(@Nullable String licenseUri) {
                this.licenseUri = licenseUri == null ? null : Uri.parse((String)licenseUri);
                return this;
            }

            public Builder setLicenseRequestHeaders(Map<String, String> licenseRequestHeaders) {
                this.licenseRequestHeaders = ImmutableMap.copyOf(licenseRequestHeaders);
                return this;
            }

            public Builder setMultiSession(boolean multiSession) {
                this.multiSession = multiSession;
                return this;
            }

            public Builder setForceDefaultLicenseUri(boolean forceDefaultLicenseUri) {
                this.forceDefaultLicenseUri = forceDefaultLicenseUri;
                return this;
            }

            public Builder setPlayClearContentWithoutKey(boolean playClearContentWithoutKey) {
                this.playClearContentWithoutKey = playClearContentWithoutKey;
                return this;
            }

            public Builder forceSessionsForAudioAndVideoTracks(boolean useClearSessionsForAudioAndVideoTracks) {
                this.setForcedSessionTrackTypes((List<Integer>)(useClearSessionsForAudioAndVideoTracks ? ImmutableList.of((Object)2, (Object)1) : ImmutableList.of()));
                return this;
            }

            public Builder setForcedSessionTrackTypes(List<Integer> forcedSessionTrackTypes) {
                this.forcedSessionTrackTypes = ImmutableList.copyOf(forcedSessionTrackTypes);
                return this;
            }

            public Builder setKeySetId(@Nullable byte[] keySetId) {
                this.keySetId = keySetId != null ? Arrays.copyOf(keySetId, keySetId.length) : null;
                return this;
            }

            public DrmConfiguration build() {
                return new DrmConfiguration(this);
            }
        }
    }

    public static final class Builder {
        @Nullable
        private String mediaId;
        @Nullable
        private Uri uri;
        @Nullable
        private String mimeType;
        private ClippingConfiguration.Builder clippingConfiguration = new ClippingConfiguration.Builder();
        private DrmConfiguration.Builder drmConfiguration = new DrmConfiguration.Builder();
        private List<StreamKey> streamKeys = Collections.emptyList();
        @Nullable
        private String customCacheKey;
        private ImmutableList<SubtitleConfiguration> subtitleConfigurations = ImmutableList.of();
        @Nullable
        private AdsConfiguration adsConfiguration;
        @Nullable
        private Object tag;
        @Nullable
        private MediaMetadata mediaMetadata;
        private LiveConfiguration.Builder liveConfiguration = new LiveConfiguration.Builder();

        public Builder() {
        }

        private Builder(MediaItem mediaItem) {
            this();
            this.clippingConfiguration = mediaItem.clippingConfiguration.buildUpon();
            this.mediaId = mediaItem.mediaId;
            this.mediaMetadata = mediaItem.mediaMetadata;
            this.liveConfiguration = mediaItem.liveConfiguration.buildUpon();
            LocalConfiguration localConfiguration = mediaItem.localConfiguration;
            if (localConfiguration != null) {
                this.customCacheKey = localConfiguration.customCacheKey;
                this.mimeType = localConfiguration.mimeType;
                this.uri = localConfiguration.uri;
                this.streamKeys = localConfiguration.streamKeys;
                this.subtitleConfigurations = localConfiguration.subtitleConfigurations;
                this.tag = localConfiguration.tag;
                this.drmConfiguration = localConfiguration.drmConfiguration != null ? localConfiguration.drmConfiguration.buildUpon() : new DrmConfiguration.Builder();
                this.adsConfiguration = localConfiguration.adsConfiguration;
            }
        }

        public Builder setMediaId(String mediaId) {
            this.mediaId = Assertions.checkNotNull(mediaId);
            return this;
        }

        public Builder setUri(@Nullable String uri) {
            return this.setUri(uri == null ? null : Uri.parse((String)uri));
        }

        public Builder setUri(@Nullable Uri uri) {
            this.uri = uri;
            return this;
        }

        public Builder setMimeType(@Nullable String mimeType) {
            this.mimeType = mimeType;
            return this;
        }

        public Builder setClippingConfiguration(ClippingConfiguration clippingConfiguration) {
            this.clippingConfiguration = clippingConfiguration.buildUpon();
            return this;
        }

        @Deprecated
        public Builder setClipStartPositionMs(@IntRange(from=0L) long startPositionMs) {
            this.clippingConfiguration.setStartPositionMs(startPositionMs);
            return this;
        }

        @Deprecated
        public Builder setClipEndPositionMs(long endPositionMs) {
            this.clippingConfiguration.setEndPositionMs(endPositionMs);
            return this;
        }

        @Deprecated
        public Builder setClipRelativeToLiveWindow(boolean relativeToLiveWindow) {
            this.clippingConfiguration.setRelativeToLiveWindow(relativeToLiveWindow);
            return this;
        }

        @Deprecated
        public Builder setClipRelativeToDefaultPosition(boolean relativeToDefaultPosition) {
            this.clippingConfiguration.setRelativeToDefaultPosition(relativeToDefaultPosition);
            return this;
        }

        @Deprecated
        public Builder setClipStartsAtKeyFrame(boolean startsAtKeyFrame) {
            this.clippingConfiguration.setStartsAtKeyFrame(startsAtKeyFrame);
            return this;
        }

        public Builder setDrmConfiguration(@Nullable DrmConfiguration drmConfiguration) {
            this.drmConfiguration = drmConfiguration != null ? drmConfiguration.buildUpon() : new DrmConfiguration.Builder();
            return this;
        }

        @Deprecated
        public Builder setDrmLicenseUri(@Nullable Uri licenseUri) {
            this.drmConfiguration.setLicenseUri(licenseUri);
            return this;
        }

        @Deprecated
        public Builder setDrmLicenseUri(@Nullable String licenseUri) {
            this.drmConfiguration.setLicenseUri(licenseUri);
            return this;
        }

        @Deprecated
        public Builder setDrmLicenseRequestHeaders(@Nullable Map<String, String> licenseRequestHeaders) {
            this.drmConfiguration.setLicenseRequestHeaders((Map<String, String>)(licenseRequestHeaders != null ? licenseRequestHeaders : ImmutableMap.of()));
            return this;
        }

        @Deprecated
        public Builder setDrmUuid(@Nullable UUID uuid) {
            this.drmConfiguration.setNullableScheme(uuid);
            return this;
        }

        @Deprecated
        public Builder setDrmMultiSession(boolean multiSession) {
            this.drmConfiguration.setMultiSession(multiSession);
            return this;
        }

        @Deprecated
        public Builder setDrmForceDefaultLicenseUri(boolean forceDefaultLicenseUri) {
            this.drmConfiguration.setForceDefaultLicenseUri(forceDefaultLicenseUri);
            return this;
        }

        @Deprecated
        public Builder setDrmPlayClearContentWithoutKey(boolean playClearContentWithoutKey) {
            this.drmConfiguration.setPlayClearContentWithoutKey(playClearContentWithoutKey);
            return this;
        }

        @Deprecated
        public Builder setDrmSessionForClearPeriods(boolean sessionForClearPeriods) {
            this.drmConfiguration.forceSessionsForAudioAndVideoTracks(sessionForClearPeriods);
            return this;
        }

        @Deprecated
        public Builder setDrmSessionForClearTypes(@Nullable List<Integer> sessionForClearTypes) {
            this.drmConfiguration.setForcedSessionTrackTypes((List<Integer>)(sessionForClearTypes != null ? sessionForClearTypes : ImmutableList.of()));
            return this;
        }

        @Deprecated
        public Builder setDrmKeySetId(@Nullable byte[] keySetId) {
            this.drmConfiguration.setKeySetId(keySetId);
            return this;
        }

        public Builder setStreamKeys(@Nullable List<StreamKey> streamKeys) {
            this.streamKeys = streamKeys != null && !streamKeys.isEmpty() ? Collections.unmodifiableList(new ArrayList<StreamKey>(streamKeys)) : Collections.emptyList();
            return this;
        }

        public Builder setCustomCacheKey(@Nullable String customCacheKey) {
            this.customCacheKey = customCacheKey;
            return this;
        }

        @Deprecated
        public Builder setSubtitles(@Nullable List<Subtitle> subtitles) {
            this.subtitleConfigurations = subtitles != null ? ImmutableList.copyOf(subtitles) : ImmutableList.of();
            return this;
        }

        public Builder setSubtitleConfigurations(List<SubtitleConfiguration> subtitleConfigurations) {
            this.subtitleConfigurations = ImmutableList.copyOf(subtitleConfigurations);
            return this;
        }

        public Builder setAdsConfiguration(@Nullable AdsConfiguration adsConfiguration) {
            this.adsConfiguration = adsConfiguration;
            return this;
        }

        @Deprecated
        public Builder setAdTagUri(@Nullable String adTagUri) {
            return this.setAdTagUri(adTagUri != null ? Uri.parse((String)adTagUri) : null);
        }

        @Deprecated
        public Builder setAdTagUri(@Nullable Uri adTagUri) {
            return this.setAdTagUri(adTagUri, null);
        }

        @Deprecated
        public Builder setAdTagUri(@Nullable Uri adTagUri, @Nullable Object adsId) {
            this.adsConfiguration = adTagUri != null ? new AdsConfiguration.Builder(adTagUri).setAdsId(adsId).build() : null;
            return this;
        }

        public Builder setLiveConfiguration(LiveConfiguration liveConfiguration) {
            this.liveConfiguration = liveConfiguration.buildUpon();
            return this;
        }

        @Deprecated
        public Builder setLiveTargetOffsetMs(long liveTargetOffsetMs) {
            this.liveConfiguration.setTargetOffsetMs(liveTargetOffsetMs);
            return this;
        }

        @Deprecated
        public Builder setLiveMinOffsetMs(long liveMinOffsetMs) {
            this.liveConfiguration.setMinOffsetMs(liveMinOffsetMs);
            return this;
        }

        @Deprecated
        public Builder setLiveMaxOffsetMs(long liveMaxOffsetMs) {
            this.liveConfiguration.setMaxOffsetMs(liveMaxOffsetMs);
            return this;
        }

        @Deprecated
        public Builder setLiveMinPlaybackSpeed(float minPlaybackSpeed) {
            this.liveConfiguration.setMinPlaybackSpeed(minPlaybackSpeed);
            return this;
        }

        @Deprecated
        public Builder setLiveMaxPlaybackSpeed(float maxPlaybackSpeed) {
            this.liveConfiguration.setMaxPlaybackSpeed(maxPlaybackSpeed);
            return this;
        }

        public Builder setTag(@Nullable Object tag) {
            this.tag = tag;
            return this;
        }

        public Builder setMediaMetadata(MediaMetadata mediaMetadata) {
            this.mediaMetadata = mediaMetadata;
            return this;
        }

        public MediaItem build() {
            Assertions.checkState(this.drmConfiguration.licenseUri == null || this.drmConfiguration.scheme != null);
            PlaybackProperties localConfiguration = null;
            Uri uri = this.uri;
            if (uri != null) {
                localConfiguration = new PlaybackProperties(uri, this.mimeType, this.drmConfiguration.scheme != null ? this.drmConfiguration.build() : null, this.adsConfiguration, this.streamKeys, this.customCacheKey, this.subtitleConfigurations, this.tag);
            }
            return new MediaItem(this.mediaId != null ? this.mediaId : MediaItem.DEFAULT_MEDIA_ID, this.clippingConfiguration.buildClippingProperties(), localConfiguration, this.liveConfiguration.build(), this.mediaMetadata != null ? this.mediaMetadata : MediaMetadata.EMPTY);
        }
    }
}

