/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.util;

import com.google.android.exoplayer2.util.Assertions;
import com.google.android.exoplayer2.util.Log;
import java.util.Arrays;

public final class LibraryLoader {
    private static final String TAG = "LibraryLoader";
    private String[] nativeLibraries;
    private boolean loadAttempted;
    private boolean isAvailable;

    public LibraryLoader(String ... libraries) {
        this.nativeLibraries = libraries;
    }

    public synchronized void setLibraries(String ... libraries) {
        Assertions.checkState(!this.loadAttempted, "Cannot set libraries after loading");
        this.nativeLibraries = libraries;
    }

    public synchronized boolean isAvailable() {
        if (this.loadAttempted) {
            return this.isAvailable;
        }
        this.loadAttempted = true;
        try {
            for (String lib : this.nativeLibraries) {
                System.loadLibrary(lib);
            }
            this.isAvailable = true;
        }
        catch (UnsatisfiedLinkError exception) {
            String string = String.valueOf(Arrays.toString(this.nativeLibraries));
            Log.w(TAG, string.length() != 0 ? "Failed to load ".concat(string) : new String("Failed to load "));
        }
        return this.isAvailable;
    }
}

