/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.source.hls;

import android.net.Uri;
import android.text.TextUtils;
import androidx.annotation.Nullable;
import com.google.android.exoplayer2.Format;
import com.google.android.exoplayer2.SeekParameters;
import com.google.android.exoplayer2.analytics.PlayerId;
import com.google.android.exoplayer2.drm.DrmInitData;
import com.google.android.exoplayer2.drm.DrmSessionEventListener;
import com.google.android.exoplayer2.drm.DrmSessionManager;
import com.google.android.exoplayer2.metadata.Metadata;
import com.google.android.exoplayer2.offline.StreamKey;
import com.google.android.exoplayer2.source.CompositeSequenceableLoaderFactory;
import com.google.android.exoplayer2.source.MediaPeriod;
import com.google.android.exoplayer2.source.MediaSourceEventListener;
import com.google.android.exoplayer2.source.SampleStream;
import com.google.android.exoplayer2.source.SequenceableLoader;
import com.google.android.exoplayer2.source.TrackGroup;
import com.google.android.exoplayer2.source.TrackGroupArray;
import com.google.android.exoplayer2.source.hls.HlsChunkSource;
import com.google.android.exoplayer2.source.hls.HlsDataSourceFactory;
import com.google.android.exoplayer2.source.hls.HlsExtractorFactory;
import com.google.android.exoplayer2.source.hls.HlsSampleStreamWrapper;
import com.google.android.exoplayer2.source.hls.TimestampAdjusterProvider;
import com.google.android.exoplayer2.source.hls.playlist.HlsMultivariantPlaylist;
import com.google.android.exoplayer2.source.hls.playlist.HlsPlaylistTracker;
import com.google.android.exoplayer2.trackselection.ExoTrackSelection;
import com.google.android.exoplayer2.upstream.Allocator;
import com.google.android.exoplayer2.upstream.LoadErrorHandlingPolicy;
import com.google.android.exoplayer2.upstream.TransferListener;
import com.google.android.exoplayer2.util.Assertions;
import com.google.android.exoplayer2.util.MimeTypes;
import com.google.android.exoplayer2.util.Util;
import com.google.common.primitives.Ints;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import org.checkerframework.checker.nullness.compatqual.NullableType;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;

public final class HlsMediaPeriod
implements MediaPeriod,
HlsSampleStreamWrapper.Callback,
HlsPlaylistTracker.PlaylistEventListener {
    private final HlsExtractorFactory extractorFactory;
    private final HlsPlaylistTracker playlistTracker;
    private final HlsDataSourceFactory dataSourceFactory;
    @Nullable
    private final TransferListener mediaTransferListener;
    private final DrmSessionManager drmSessionManager;
    private final DrmSessionEventListener.EventDispatcher drmEventDispatcher;
    private final LoadErrorHandlingPolicy loadErrorHandlingPolicy;
    private final MediaSourceEventListener.EventDispatcher eventDispatcher;
    private final Allocator allocator;
    private final IdentityHashMap<SampleStream, Integer> streamWrapperIndices;
    private final TimestampAdjusterProvider timestampAdjusterProvider;
    private final CompositeSequenceableLoaderFactory compositeSequenceableLoaderFactory;
    private final boolean allowChunklessPreparation;
    private final int metadataType;
    private final boolean useSessionKeys;
    private final PlayerId playerId;
    @Nullable
    private MediaPeriod.Callback callback;
    private int pendingPrepareCount;
    private @MonotonicNonNull TrackGroupArray trackGroups;
    private HlsSampleStreamWrapper[] sampleStreamWrappers;
    private HlsSampleStreamWrapper[] enabledSampleStreamWrappers;
    private int[][] manifestUrlIndicesPerWrapper;
    private int audioVideoSampleStreamWrapperCount;
    private SequenceableLoader compositeSequenceableLoader;

    public HlsMediaPeriod(HlsExtractorFactory extractorFactory, HlsPlaylistTracker playlistTracker, HlsDataSourceFactory dataSourceFactory, @Nullable TransferListener mediaTransferListener, DrmSessionManager drmSessionManager, DrmSessionEventListener.EventDispatcher drmEventDispatcher, LoadErrorHandlingPolicy loadErrorHandlingPolicy, MediaSourceEventListener.EventDispatcher eventDispatcher, Allocator allocator, CompositeSequenceableLoaderFactory compositeSequenceableLoaderFactory, boolean allowChunklessPreparation, int metadataType, boolean useSessionKeys, PlayerId playerId) {
        this.extractorFactory = extractorFactory;
        this.playlistTracker = playlistTracker;
        this.dataSourceFactory = dataSourceFactory;
        this.mediaTransferListener = mediaTransferListener;
        this.drmSessionManager = drmSessionManager;
        this.drmEventDispatcher = drmEventDispatcher;
        this.loadErrorHandlingPolicy = loadErrorHandlingPolicy;
        this.eventDispatcher = eventDispatcher;
        this.allocator = allocator;
        this.compositeSequenceableLoaderFactory = compositeSequenceableLoaderFactory;
        this.allowChunklessPreparation = allowChunklessPreparation;
        this.metadataType = metadataType;
        this.useSessionKeys = useSessionKeys;
        this.playerId = playerId;
        this.compositeSequenceableLoader = compositeSequenceableLoaderFactory.createCompositeSequenceableLoader(new SequenceableLoader[0]);
        this.streamWrapperIndices = new IdentityHashMap();
        this.timestampAdjusterProvider = new TimestampAdjusterProvider();
        this.sampleStreamWrappers = new HlsSampleStreamWrapper[0];
        this.enabledSampleStreamWrappers = new HlsSampleStreamWrapper[0];
        this.manifestUrlIndicesPerWrapper = new int[0][];
    }

    public void release() {
        this.playlistTracker.removeListener(this);
        for (HlsSampleStreamWrapper sampleStreamWrapper : this.sampleStreamWrappers) {
            sampleStreamWrapper.release();
        }
        this.callback = null;
    }

    public void prepare(MediaPeriod.Callback callback, long positionUs) {
        this.callback = callback;
        this.playlistTracker.addListener(this);
        this.buildAndPrepareSampleStreamWrappers(positionUs);
    }

    public void maybeThrowPrepareError() throws IOException {
        for (HlsSampleStreamWrapper sampleStreamWrapper : this.sampleStreamWrappers) {
            sampleStreamWrapper.maybeThrowPrepareError();
        }
    }

    public TrackGroupArray getTrackGroups() {
        return (TrackGroupArray)Assertions.checkNotNull((Object)this.trackGroups);
    }

    public List<StreamKey> getStreamKeys(List<ExoTrackSelection> trackSelections) {
        int mainWrapperPrimaryGroupIndex;
        TrackGroupArray mainWrapperTrackGroups;
        int[] mainWrapperVariantIndices;
        HlsMultivariantPlaylist multivariantPlaylist = (HlsMultivariantPlaylist)Assertions.checkNotNull((Object)this.playlistTracker.getMultivariantPlaylist());
        boolean hasVariants = !multivariantPlaylist.variants.isEmpty();
        int audioWrapperOffset = hasVariants ? 1 : 0;
        int subtitleWrapperOffset = this.sampleStreamWrappers.length - multivariantPlaylist.subtitles.size();
        if (hasVariants) {
            HlsSampleStreamWrapper mainWrapper = this.sampleStreamWrappers[0];
            mainWrapperVariantIndices = this.manifestUrlIndicesPerWrapper[0];
            mainWrapperTrackGroups = mainWrapper.getTrackGroups();
            mainWrapperPrimaryGroupIndex = mainWrapper.getPrimaryTrackGroupIndex();
        } else {
            mainWrapperVariantIndices = new int[]{};
            mainWrapperTrackGroups = TrackGroupArray.EMPTY;
            mainWrapperPrimaryGroupIndex = 0;
        }
        ArrayList<StreamKey> streamKeys = new ArrayList<StreamKey>();
        boolean needsPrimaryTrackGroupSelection = false;
        boolean hasPrimaryTrackGroupSelection = false;
        block0: for (ExoTrackSelection trackSelection : trackSelections) {
            int i;
            TrackGroup trackSelectionGroup = trackSelection.getTrackGroup();
            int mainWrapperTrackGroupIndex = mainWrapperTrackGroups.indexOf(trackSelectionGroup);
            if (mainWrapperTrackGroupIndex != -1) {
                if (mainWrapperTrackGroupIndex == mainWrapperPrimaryGroupIndex) {
                    hasPrimaryTrackGroupSelection = true;
                    for (i = 0; i < trackSelection.length(); ++i) {
                        int variantIndex = mainWrapperVariantIndices[trackSelection.getIndexInTrackGroup(i)];
                        streamKeys.add(new StreamKey(0, variantIndex));
                    }
                    continue;
                }
                needsPrimaryTrackGroupSelection = true;
                continue;
            }
            for (i = audioWrapperOffset; i < this.sampleStreamWrappers.length; ++i) {
                TrackGroupArray wrapperTrackGroups = this.sampleStreamWrappers[i].getTrackGroups();
                int selectedTrackGroupIndex = wrapperTrackGroups.indexOf(trackSelectionGroup);
                if (selectedTrackGroupIndex == -1) continue;
                int groupIndexType = i < subtitleWrapperOffset ? 1 : 2;
                int[] selectedWrapperUrlIndices = this.manifestUrlIndicesPerWrapper[i];
                for (int trackIndex = 0; trackIndex < trackSelection.length(); ++trackIndex) {
                    int renditionIndex = selectedWrapperUrlIndices[trackSelection.getIndexInTrackGroup(trackIndex)];
                    streamKeys.add(new StreamKey(groupIndexType, renditionIndex));
                }
                continue block0;
            }
        }
        if (needsPrimaryTrackGroupSelection && !hasPrimaryTrackGroupSelection) {
            int lowestBitrateIndex = mainWrapperVariantIndices[0];
            int lowestBitrate = multivariantPlaylist.variants.get((int)mainWrapperVariantIndices[0]).format.bitrate;
            for (int i = 1; i < mainWrapperVariantIndices.length; ++i) {
                int variantBitrate = multivariantPlaylist.variants.get((int)mainWrapperVariantIndices[i]).format.bitrate;
                if (variantBitrate >= lowestBitrate) continue;
                lowestBitrate = variantBitrate;
                lowestBitrateIndex = mainWrapperVariantIndices[i];
            }
            streamKeys.add(new StreamKey(0, lowestBitrateIndex));
        }
        return streamKeys;
    }

    public long selectTracks(@NullableType ExoTrackSelection[] selections, boolean[] mayRetainStreamFlags, @NullableType SampleStream[] streams, boolean[] streamResetFlags, long positionUs) {
        int[] streamChildIndices = new int[selections.length];
        int[] selectionChildIndices = new int[selections.length];
        block0: for (int i = 0; i < selections.length; ++i) {
            streamChildIndices[i] = streams[i] == null ? -1 : this.streamWrapperIndices.get(streams[i]);
            selectionChildIndices[i] = -1;
            if (selections[i] == null) continue;
            TrackGroup trackGroup = selections[i].getTrackGroup();
            for (int j = 0; j < this.sampleStreamWrappers.length; ++j) {
                if (this.sampleStreamWrappers[j].getTrackGroups().indexOf(trackGroup) == -1) continue;
                selectionChildIndices[i] = j;
                continue block0;
            }
        }
        boolean forceReset = false;
        this.streamWrapperIndices.clear();
        SampleStream[] newStreams = new SampleStream[selections.length];
        @NullableType SampleStream[] childStreams = new SampleStream[selections.length];
        @NullableType ExoTrackSelection[] childSelections = new ExoTrackSelection[selections.length];
        int newEnabledSampleStreamWrapperCount = 0;
        Object[] newEnabledSampleStreamWrappers = new HlsSampleStreamWrapper[this.sampleStreamWrappers.length];
        for (int i = 0; i < this.sampleStreamWrappers.length; ++i) {
            for (int j = 0; j < selections.length; ++j) {
                childStreams[j] = streamChildIndices[j] == i ? streams[j] : null;
                childSelections[j] = selectionChildIndices[j] == i ? selections[j] : null;
            }
            HlsSampleStreamWrapper sampleStreamWrapper = this.sampleStreamWrappers[i];
            boolean wasReset = sampleStreamWrapper.selectTracks(childSelections, mayRetainStreamFlags, childStreams, streamResetFlags, positionUs, forceReset);
            boolean wrapperEnabled = false;
            for (int j = 0; j < selections.length; ++j) {
                SampleStream childStream = childStreams[j];
                if (selectionChildIndices[j] == i) {
                    Assertions.checkNotNull((Object)childStream);
                    newStreams[j] = childStream;
                    wrapperEnabled = true;
                    this.streamWrapperIndices.put(childStream, i);
                    continue;
                }
                if (streamChildIndices[j] != i) continue;
                Assertions.checkState((childStream == null ? 1 : 0) != 0);
            }
            if (!wrapperEnabled) continue;
            newEnabledSampleStreamWrappers[newEnabledSampleStreamWrapperCount] = sampleStreamWrapper;
            if (newEnabledSampleStreamWrapperCount++ == 0) {
                sampleStreamWrapper.setIsTimestampMaster(true);
                if (!wasReset && this.enabledSampleStreamWrappers.length != 0 && sampleStreamWrapper == this.enabledSampleStreamWrappers[0]) continue;
                this.timestampAdjusterProvider.reset();
                forceReset = true;
                continue;
            }
            sampleStreamWrapper.setIsTimestampMaster(i < this.audioVideoSampleStreamWrapperCount);
        }
        System.arraycopy(newStreams, 0, streams, 0, newStreams.length);
        this.enabledSampleStreamWrappers = (HlsSampleStreamWrapper[])Util.nullSafeArrayCopy((Object[])newEnabledSampleStreamWrappers, (int)newEnabledSampleStreamWrapperCount);
        this.compositeSequenceableLoader = this.compositeSequenceableLoaderFactory.createCompositeSequenceableLoader((SequenceableLoader[])this.enabledSampleStreamWrappers);
        return positionUs;
    }

    public void discardBuffer(long positionUs, boolean toKeyframe) {
        for (HlsSampleStreamWrapper sampleStreamWrapper : this.enabledSampleStreamWrappers) {
            sampleStreamWrapper.discardBuffer(positionUs, toKeyframe);
        }
    }

    public void reevaluateBuffer(long positionUs) {
        this.compositeSequenceableLoader.reevaluateBuffer(positionUs);
    }

    public boolean continueLoading(long positionUs) {
        if (this.trackGroups == null) {
            for (HlsSampleStreamWrapper wrapper : this.sampleStreamWrappers) {
                wrapper.continuePreparing();
            }
            return false;
        }
        return this.compositeSequenceableLoader.continueLoading(positionUs);
    }

    public boolean isLoading() {
        return this.compositeSequenceableLoader.isLoading();
    }

    public long getNextLoadPositionUs() {
        return this.compositeSequenceableLoader.getNextLoadPositionUs();
    }

    public long readDiscontinuity() {
        return -9223372036854775807L;
    }

    public long getBufferedPositionUs() {
        return this.compositeSequenceableLoader.getBufferedPositionUs();
    }

    public long seekToUs(long positionUs) {
        if (this.enabledSampleStreamWrappers.length > 0) {
            boolean forceReset = this.enabledSampleStreamWrappers[0].seekToUs(positionUs, false);
            for (int i = 1; i < this.enabledSampleStreamWrappers.length; ++i) {
                this.enabledSampleStreamWrappers[i].seekToUs(positionUs, forceReset);
            }
            if (forceReset) {
                this.timestampAdjusterProvider.reset();
            }
        }
        return positionUs;
    }

    public long getAdjustedSeekPositionUs(long positionUs, SeekParameters seekParameters) {
        long seekTargetUs = positionUs;
        for (HlsSampleStreamWrapper sampleStreamWrapper : this.enabledSampleStreamWrappers) {
            if (!sampleStreamWrapper.isVideoSampleStream()) continue;
            seekTargetUs = sampleStreamWrapper.getAdjustedSeekPositionUs(positionUs, seekParameters);
            break;
        }
        return seekTargetUs;
    }

    @Override
    public void onPrepared() {
        if (--this.pendingPrepareCount > 0) {
            return;
        }
        int totalTrackGroupCount = 0;
        for (HlsSampleStreamWrapper sampleStreamWrapper : this.sampleStreamWrappers) {
            totalTrackGroupCount += sampleStreamWrapper.getTrackGroups().length;
        }
        TrackGroup[] trackGroupArray = new TrackGroup[totalTrackGroupCount];
        int trackGroupIndex = 0;
        for (HlsSampleStreamWrapper sampleStreamWrapper : this.sampleStreamWrappers) {
            int wrapperTrackGroupCount = sampleStreamWrapper.getTrackGroups().length;
            for (int j = 0; j < wrapperTrackGroupCount; ++j) {
                trackGroupArray[trackGroupIndex++] = sampleStreamWrapper.getTrackGroups().get(j);
            }
        }
        this.trackGroups = new TrackGroupArray(trackGroupArray);
        this.callback.onPrepared((MediaPeriod)this);
    }

    @Override
    public void onPlaylistRefreshRequired(Uri url) {
        this.playlistTracker.refreshPlaylist(url);
    }

    public void onContinueLoadingRequested(HlsSampleStreamWrapper sampleStreamWrapper) {
        this.callback.onContinueLoadingRequested((SequenceableLoader)this);
    }

    @Override
    public void onPlaylistChanged() {
        for (HlsSampleStreamWrapper streamWrapper : this.sampleStreamWrappers) {
            streamWrapper.onPlaylistUpdated();
        }
        this.callback.onContinueLoadingRequested((SequenceableLoader)this);
    }

    @Override
    public boolean onPlaylistError(Uri url, LoadErrorHandlingPolicy.LoadErrorInfo loadErrorInfo, boolean forceRetry) {
        boolean exclusionSucceeded = true;
        for (HlsSampleStreamWrapper streamWrapper : this.sampleStreamWrappers) {
            exclusionSucceeded &= streamWrapper.onPlaylistError(url, loadErrorInfo, forceRetry);
        }
        this.callback.onContinueLoadingRequested((SequenceableLoader)this);
        return exclusionSucceeded;
    }

    private void buildAndPrepareSampleStreamWrappers(long positionUs) {
        HlsMultivariantPlaylist multivariantPlaylist = (HlsMultivariantPlaylist)Assertions.checkNotNull((Object)this.playlistTracker.getMultivariantPlaylist());
        Map<String, DrmInitData> overridingDrmInitData = this.useSessionKeys ? HlsMediaPeriod.deriveOverridingDrmInitData(multivariantPlaylist.sessionKeyDrmInitData) : Collections.emptyMap();
        boolean hasVariants = !multivariantPlaylist.variants.isEmpty();
        List<HlsMultivariantPlaylist.Rendition> audioRenditions = multivariantPlaylist.audios;
        List<HlsMultivariantPlaylist.Rendition> subtitleRenditions = multivariantPlaylist.subtitles;
        this.pendingPrepareCount = 0;
        ArrayList<HlsSampleStreamWrapper> sampleStreamWrappers = new ArrayList<HlsSampleStreamWrapper>();
        ArrayList<int[]> manifestUrlIndicesPerWrapper = new ArrayList<int[]>();
        if (hasVariants) {
            this.buildAndPrepareMainSampleStreamWrapper(multivariantPlaylist, positionUs, sampleStreamWrappers, manifestUrlIndicesPerWrapper, overridingDrmInitData);
        }
        this.buildAndPrepareAudioSampleStreamWrappers(positionUs, audioRenditions, sampleStreamWrappers, manifestUrlIndicesPerWrapper, overridingDrmInitData);
        this.audioVideoSampleStreamWrapperCount = sampleStreamWrappers.size();
        int i = 0;
        while (i < subtitleRenditions.size()) {
            HlsMultivariantPlaylist.Rendition subtitleRendition = subtitleRenditions.get(i);
            String sampleStreamWrapperUid = "subtitle:" + i + ":" + subtitleRendition.name;
            HlsSampleStreamWrapper sampleStreamWrapper = this.buildSampleStreamWrapper(sampleStreamWrapperUid, 3, new Uri[]{subtitleRendition.url}, new Format[]{subtitleRendition.format}, null, Collections.emptyList(), overridingDrmInitData, positionUs);
            manifestUrlIndicesPerWrapper.add(new int[]{i++});
            sampleStreamWrappers.add(sampleStreamWrapper);
            sampleStreamWrapper.prepareWithMultivariantPlaylistInfo(new TrackGroup[]{new TrackGroup(sampleStreamWrapperUid, new Format[]{subtitleRendition.format})}, 0, new int[0]);
        }
        this.sampleStreamWrappers = sampleStreamWrappers.toArray(new HlsSampleStreamWrapper[0]);
        this.manifestUrlIndicesPerWrapper = (int[][])manifestUrlIndicesPerWrapper.toArray((T[])new int[0][]);
        this.pendingPrepareCount = this.sampleStreamWrappers.length;
        for (i = 0; i < this.audioVideoSampleStreamWrapperCount; ++i) {
            this.sampleStreamWrappers[i].setIsTimestampMaster(true);
        }
        for (HlsSampleStreamWrapper sampleStreamWrapper : this.sampleStreamWrappers) {
            sampleStreamWrapper.continuePreparing();
        }
        this.enabledSampleStreamWrappers = this.sampleStreamWrappers;
    }

    private void buildAndPrepareMainSampleStreamWrapper(HlsMultivariantPlaylist multivariantPlaylist, long positionUs, List<HlsSampleStreamWrapper> sampleStreamWrappers, List<int[]> manifestUrlIndicesPerWrapper, Map<String, DrmInitData> overridingDrmInitData) {
        int[] variantTypes = new int[multivariantPlaylist.variants.size()];
        int videoVariantCount = 0;
        int audioVariantCount = 0;
        for (int i = 0; i < multivariantPlaylist.variants.size(); ++i) {
            HlsMultivariantPlaylist.Variant variant = multivariantPlaylist.variants.get(i);
            Format format = variant.format;
            if (format.height > 0 || Util.getCodecsOfType((String)format.codecs, (int)2) != null) {
                variantTypes[i] = 2;
                ++videoVariantCount;
                continue;
            }
            if (Util.getCodecsOfType((String)format.codecs, (int)1) != null) {
                variantTypes[i] = 1;
                ++audioVariantCount;
                continue;
            }
            variantTypes[i] = -1;
        }
        boolean useVideoVariantsOnly = false;
        boolean useNonAudioVariantsOnly = false;
        int selectedVariantsCount = variantTypes.length;
        if (videoVariantCount > 0) {
            useVideoVariantsOnly = true;
            selectedVariantsCount = videoVariantCount;
        } else if (audioVariantCount < variantTypes.length) {
            useNonAudioVariantsOnly = true;
            selectedVariantsCount = variantTypes.length - audioVariantCount;
        }
        Uri[] selectedPlaylistUrls = new Uri[selectedVariantsCount];
        Format[] selectedPlaylistFormats = new Format[selectedVariantsCount];
        int[] selectedVariantIndices = new int[selectedVariantsCount];
        int outIndex = 0;
        for (int i = 0; i < multivariantPlaylist.variants.size(); ++i) {
            if (useVideoVariantsOnly && variantTypes[i] != 2 || useNonAudioVariantsOnly && variantTypes[i] == 1) continue;
            HlsMultivariantPlaylist.Variant variant = multivariantPlaylist.variants.get(i);
            selectedPlaylistUrls[outIndex] = variant.url;
            selectedPlaylistFormats[outIndex] = variant.format;
            selectedVariantIndices[outIndex++] = i;
        }
        String codecs = selectedPlaylistFormats[0].codecs;
        int numberOfVideoCodecs = Util.getCodecCountOfType((String)codecs, (int)2);
        int numberOfAudioCodecs = Util.getCodecCountOfType((String)codecs, (int)1);
        boolean codecsStringAllowsChunklessPreparation = (numberOfAudioCodecs == 1 || numberOfAudioCodecs == 0 && multivariantPlaylist.audios.isEmpty()) && numberOfVideoCodecs <= 1 && numberOfAudioCodecs + numberOfVideoCodecs > 0;
        int trackType = !useVideoVariantsOnly && numberOfAudioCodecs > 0 ? 1 : 0;
        String sampleStreamWrapperUid = "main";
        HlsSampleStreamWrapper sampleStreamWrapper = this.buildSampleStreamWrapper(sampleStreamWrapperUid, trackType, selectedPlaylistUrls, selectedPlaylistFormats, multivariantPlaylist.muxedAudioFormat, multivariantPlaylist.muxedCaptionFormats, overridingDrmInitData, positionUs);
        sampleStreamWrappers.add(sampleStreamWrapper);
        manifestUrlIndicesPerWrapper.add(selectedVariantIndices);
        if (this.allowChunklessPreparation && codecsStringAllowsChunklessPreparation) {
            ArrayList<TrackGroup> muxedTrackGroups = new ArrayList<TrackGroup>();
            if (numberOfVideoCodecs > 0) {
                List<Format> ccFormats;
                Format[] videoFormats = new Format[selectedVariantsCount];
                for (int i = 0; i < videoFormats.length; ++i) {
                    videoFormats[i] = HlsMediaPeriod.deriveVideoFormat(selectedPlaylistFormats[i]);
                }
                muxedTrackGroups.add(new TrackGroup(sampleStreamWrapperUid, videoFormats));
                if (numberOfAudioCodecs > 0 && (multivariantPlaylist.muxedAudioFormat != null || multivariantPlaylist.audios.isEmpty())) {
                    muxedTrackGroups.add(new TrackGroup(sampleStreamWrapperUid + ":audio", new Format[]{HlsMediaPeriod.deriveAudioFormat(selectedPlaylistFormats[0], multivariantPlaylist.muxedAudioFormat, false)}));
                }
                if ((ccFormats = multivariantPlaylist.muxedCaptionFormats) != null) {
                    for (int i = 0; i < ccFormats.size(); ++i) {
                        String ccId = sampleStreamWrapperUid + ":cc:" + i;
                        muxedTrackGroups.add(new TrackGroup(ccId, new Format[]{ccFormats.get(i)}));
                    }
                }
            } else {
                Format[] audioFormats = new Format[selectedVariantsCount];
                for (int i = 0; i < audioFormats.length; ++i) {
                    audioFormats[i] = HlsMediaPeriod.deriveAudioFormat(selectedPlaylistFormats[i], multivariantPlaylist.muxedAudioFormat, true);
                }
                muxedTrackGroups.add(new TrackGroup(sampleStreamWrapperUid, audioFormats));
            }
            TrackGroup id3TrackGroup = new TrackGroup(sampleStreamWrapperUid + ":id3", new Format[]{new Format.Builder().setId("ID3").setSampleMimeType("application/id3").build()});
            muxedTrackGroups.add(id3TrackGroup);
            sampleStreamWrapper.prepareWithMultivariantPlaylistInfo(muxedTrackGroups.toArray(new TrackGroup[0]), 0, muxedTrackGroups.indexOf(id3TrackGroup));
        }
    }

    private void buildAndPrepareAudioSampleStreamWrappers(long positionUs, List<HlsMultivariantPlaylist.Rendition> audioRenditions, List<HlsSampleStreamWrapper> sampleStreamWrappers, List<int[]> manifestUrlsIndicesPerWrapper, Map<String, DrmInitData> overridingDrmInitData) {
        ArrayList<Uri> scratchPlaylistUrls = new ArrayList<Uri>(audioRenditions.size());
        ArrayList<Format> scratchPlaylistFormats = new ArrayList<Format>(audioRenditions.size());
        ArrayList<Integer> scratchIndicesList = new ArrayList<Integer>(audioRenditions.size());
        HashSet<String> alreadyGroupedNames = new HashSet<String>();
        for (int renditionByNameIndex = 0; renditionByNameIndex < audioRenditions.size(); ++renditionByNameIndex) {
            String name = audioRenditions.get((int)renditionByNameIndex).name;
            if (!alreadyGroupedNames.add(name)) continue;
            boolean codecStringsAllowChunklessPreparation = true;
            scratchPlaylistUrls.clear();
            scratchPlaylistFormats.clear();
            scratchIndicesList.clear();
            for (int renditionIndex = 0; renditionIndex < audioRenditions.size(); ++renditionIndex) {
                if (!Util.areEqual((Object)name, (Object)audioRenditions.get((int)renditionIndex).name)) continue;
                HlsMultivariantPlaylist.Rendition rendition = audioRenditions.get(renditionIndex);
                scratchIndicesList.add(renditionIndex);
                scratchPlaylistUrls.add(rendition.url);
                scratchPlaylistFormats.add(rendition.format);
                codecStringsAllowChunklessPreparation &= Util.getCodecCountOfType((String)rendition.format.codecs, (int)1) == 1;
            }
            String sampleStreamWrapperUid = "audio:" + name;
            HlsSampleStreamWrapper sampleStreamWrapper = this.buildSampleStreamWrapper(sampleStreamWrapperUid, 1, scratchPlaylistUrls.toArray((Uri[])Util.castNonNullTypeArray((Object[])new Uri[0])), scratchPlaylistFormats.toArray(new Format[0]), null, Collections.emptyList(), overridingDrmInitData, positionUs);
            manifestUrlsIndicesPerWrapper.add(Ints.toArray(scratchIndicesList));
            sampleStreamWrappers.add(sampleStreamWrapper);
            if (!this.allowChunklessPreparation || !codecStringsAllowChunklessPreparation) continue;
            Format[] renditionFormats = scratchPlaylistFormats.toArray(new Format[0]);
            sampleStreamWrapper.prepareWithMultivariantPlaylistInfo(new TrackGroup[]{new TrackGroup(sampleStreamWrapperUid, renditionFormats)}, 0, new int[0]);
        }
    }

    private HlsSampleStreamWrapper buildSampleStreamWrapper(String uid, int trackType, Uri[] playlistUrls, Format[] playlistFormats, @Nullable Format muxedAudioFormat, @Nullable List<Format> muxedCaptionFormats, Map<String, DrmInitData> overridingDrmInitData, long positionUs) {
        HlsChunkSource defaultChunkSource = new HlsChunkSource(this.extractorFactory, this.playlistTracker, playlistUrls, playlistFormats, this.dataSourceFactory, this.mediaTransferListener, this.timestampAdjusterProvider, muxedCaptionFormats, this.playerId);
        return new HlsSampleStreamWrapper(uid, trackType, this, defaultChunkSource, overridingDrmInitData, this.allocator, positionUs, muxedAudioFormat, this.drmSessionManager, this.drmEventDispatcher, this.loadErrorHandlingPolicy, this.eventDispatcher, this.metadataType);
    }

    private static Map<String, DrmInitData> deriveOverridingDrmInitData(List<DrmInitData> sessionKeyDrmInitData) {
        ArrayList<DrmInitData> mutableSessionKeyDrmInitData = new ArrayList<DrmInitData>(sessionKeyDrmInitData);
        HashMap<String, DrmInitData> drmInitDataBySchemeType = new HashMap<String, DrmInitData>();
        for (int i = 0; i < mutableSessionKeyDrmInitData.size(); ++i) {
            DrmInitData drmInitData = sessionKeyDrmInitData.get(i);
            String scheme = drmInitData.schemeType;
            int j = i + 1;
            while (j < mutableSessionKeyDrmInitData.size()) {
                DrmInitData nextDrmInitData = mutableSessionKeyDrmInitData.get(j);
                if (TextUtils.equals((CharSequence)nextDrmInitData.schemeType, (CharSequence)scheme)) {
                    drmInitData = drmInitData.merge(nextDrmInitData);
                    mutableSessionKeyDrmInitData.remove(j);
                    continue;
                }
                ++j;
            }
            drmInitDataBySchemeType.put(scheme, drmInitData);
        }
        return drmInitDataBySchemeType;
    }

    private static Format deriveVideoFormat(Format variantFormat) {
        String codecs = Util.getCodecsOfType((String)variantFormat.codecs, (int)2);
        String sampleMimeType = MimeTypes.getMediaMimeType((String)codecs);
        return new Format.Builder().setId(variantFormat.id).setLabel(variantFormat.label).setContainerMimeType(variantFormat.containerMimeType).setSampleMimeType(sampleMimeType).setCodecs(codecs).setMetadata(variantFormat.metadata).setAverageBitrate(variantFormat.averageBitrate).setPeakBitrate(variantFormat.peakBitrate).setWidth(variantFormat.width).setHeight(variantFormat.height).setFrameRate(variantFormat.frameRate).setSelectionFlags(variantFormat.selectionFlags).setRoleFlags(variantFormat.roleFlags).build();
    }

    private static Format deriveAudioFormat(Format variantFormat, @Nullable Format mediaTagFormat, boolean isPrimaryTrackInVariant) {
        Metadata metadata;
        String codecs;
        int channelCount = -1;
        int selectionFlags = 0;
        int roleFlags = 0;
        String language = null;
        String label = null;
        if (mediaTagFormat != null) {
            codecs = mediaTagFormat.codecs;
            metadata = mediaTagFormat.metadata;
            channelCount = mediaTagFormat.channelCount;
            selectionFlags = mediaTagFormat.selectionFlags;
            roleFlags = mediaTagFormat.roleFlags;
            language = mediaTagFormat.language;
            label = mediaTagFormat.label;
        } else {
            codecs = Util.getCodecsOfType((String)variantFormat.codecs, (int)1);
            metadata = variantFormat.metadata;
            if (isPrimaryTrackInVariant) {
                channelCount = variantFormat.channelCount;
                selectionFlags = variantFormat.selectionFlags;
                roleFlags = variantFormat.roleFlags;
                language = variantFormat.language;
                label = variantFormat.label;
            }
        }
        String sampleMimeType = MimeTypes.getMediaMimeType((String)codecs);
        int averageBitrate = isPrimaryTrackInVariant ? variantFormat.averageBitrate : -1;
        int peakBitrate = isPrimaryTrackInVariant ? variantFormat.peakBitrate : -1;
        return new Format.Builder().setId(variantFormat.id).setLabel(label).setContainerMimeType(variantFormat.containerMimeType).setSampleMimeType(sampleMimeType).setCodecs(codecs).setMetadata(metadata).setAverageBitrate(averageBitrate).setPeakBitrate(peakBitrate).setChannelCount(channelCount).setSelectionFlags(selectionFlags).setRoleFlags(roleFlags).setLanguage(language).build();
    }
}

