/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.ads;

import android.content.Context;
import android.os.RemoteException;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresPermission;
import com.google.android.gms.ads.AdListener;
import com.google.android.gms.ads.AdRequest;
import com.google.android.gms.ads.AdSize;
import com.google.android.gms.ads.VideoOptions;
import com.google.android.gms.ads.admanager.AdManagerAdRequest;
import com.google.android.gms.ads.formats.AdManagerAdViewOptions;
import com.google.android.gms.ads.formats.OnAdManagerAdViewLoadedListener;
import com.google.android.gms.ads.formats.zzd;
import com.google.android.gms.ads.formats.zze;
import com.google.android.gms.ads.formats.zzg;
import com.google.android.gms.ads.internal.client.zzbb;
import com.google.android.gms.ads.internal.client.zzbd;
import com.google.android.gms.ads.internal.client.zzbq;
import com.google.android.gms.ads.internal.client.zzbt;
import com.google.android.gms.ads.internal.client.zzek;
import com.google.android.gms.ads.internal.client.zzfi;
import com.google.android.gms.ads.internal.client.zzga;
import com.google.android.gms.ads.internal.client.zzq;
import com.google.android.gms.ads.internal.client.zzr;
import com.google.android.gms.ads.internal.util.client.zzb;
import com.google.android.gms.ads.internal.util.client.zzo;
import com.google.android.gms.ads.nativead.NativeAd;
import com.google.android.gms.ads.nativead.NativeAdOptions;
import com.google.android.gms.ads.nativead.NativeCustomFormatAd;
import com.google.android.gms.ads.zza;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.internal.ads.zzbbz;
import com.google.android.gms.internal.ads.zzbci;
import com.google.android.gms.internal.ads.zzbeg;
import com.google.android.gms.internal.ads.zzbfl;
import com.google.android.gms.internal.ads.zzbhw;
import com.google.android.gms.internal.ads.zzbhy;
import com.google.android.gms.internal.ads.zzbhz;
import com.google.android.gms.internal.ads.zzbot;
import com.google.android.gms.internal.ads.zzbsj;
import com.google.android.gms.internal.ads.zzbsl;

public class AdLoader {
    private final zzq zza;
    private final Context zzb;
    private final zzbq zzc;

    /*
     * WARNING - void declaration
     */
    @RequiresPermission(value="android.permission.INTERNET")
    public void loadAd(@NonNull AdRequest adRequest) {
        void var1_1;
        this.zzb(var1_1.zza);
    }

    /*
     * WARNING - void declaration
     */
    public void loadAd(@NonNull AdManagerAdRequest adManagerAdRequest) {
        void var1_1;
        this.zzb(var1_1.zza);
    }

    /*
     * WARNING - void declaration
     */
    @RequiresPermission(value="android.permission.INTERNET")
    public void loadAds(@NonNull AdRequest adRequest, int maxNumberOfAds) {
        zzek zzek2 = adRequest.zza;
        try {
            void var2_3;
            this.zzc.zzi(this.zza.zza(this.zzb, zzek2), (int)var2_3);
            return;
        }
        catch (RemoteException remoteException) {
            zzo.zzg("Failed to load ads.", remoteException);
            return;
        }
    }

    public boolean isLoading() {
        try {
            boolean bl = this.zzc.zzg();
            return bl;
        }
        catch (RemoteException remoteException) {
            zzo.zzj("Failed to check if ad is loading.", remoteException);
            return false;
        }
    }

    AdLoader(Context context, zzbq zzbq2, zzq zzq2) {
        this.zzb = context;
        this.zzc = zzbq2;
        this.zza = zzq2;
    }

    private final void zzb(zzek zzek2) {
        block5: {
            Object object;
            Context context;
            block4: {
                context = ((AdLoader)((Object)zzq2)).zzb;
                zzbci.zza(context);
                if (!((Boolean)zzbeg.zzc.zze()).booleanValue()) break block4;
                object = zzbci.zzlX;
                if (((Boolean)zzbd.zzc().zzd((zzbbz)object)).booleanValue()) break block5;
            }
            try {
                object = ((AdLoader)((Object)zzq2)).zzc;
                zzq zzq2 = ((AdLoader)((Object)zzq2)).zza;
                object.zze(zzq2.zza(context, zzek2));
                return;
            }
            catch (RemoteException remoteException) {
                zzo.zzg("Failed to load ad.", remoteException);
                return;
            }
        }
        com.google.android.gms.ads.internal.util.client.zzb.zzb.execute(new zza((AdLoader)((Object)zzq2), zzek2));
    }

    final /* synthetic */ void zza(zzek zzek2) {
        try {
            this.zzc.zze(this.zza.zza(this.zzb, zzek2));
            return;
        }
        catch (RemoteException remoteException) {
            zzo.zzg("Failed to load ad.", remoteException);
            return;
        }
    }

    public static class Builder {
        private final Context zza;
        private final zzbt zzb;

        /*
         * WARNING - void declaration
         */
        public Builder(@NonNull Context context, @NonNull String adUnitID) {
            void var2_2;
            void var1_1;
            Context context2 = (Context)Preconditions.checkNotNull((Object)context, (Object)"context cannot be null");
            zzbt zzbt2 = zzbb.zzb().zzc((Context)var1_1, (String)var2_2, new zzbot());
            this.zza = context2;
            this.zzb = zzbt2;
        }

        /*
         * WARNING - void declaration
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @NonNull
        public Builder forNativeAd(@NonNull NativeAd.OnNativeAdLoadedListener listener) {
            try {
                void var1_1;
                zzbt zzbt2 = this.zzb;
                zzbt2.zzm(new zzbsl((NativeAd.OnNativeAdLoadedListener)var1_1));
                return this;
            }
            catch (RemoteException remoteException) {
                zzo.zzj("Failed to add google native ad listener", remoteException);
                return this;
            }
        }

        /*
         * WARNING - void declaration
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @NonNull
        public Builder forCustomFormatAd(@NonNull String customFormatId, @NonNull NativeCustomFormatAd.OnCustomFormatAdLoadedListener adLoadedListener, @Nullable NativeCustomFormatAd.OnCustomClickListener customClickListener) {
            void var3_4;
            void var2_3;
            zzbsj zzbsj2 = new zzbsj((NativeCustomFormatAd.OnCustomFormatAdLoadedListener)var2_3, (NativeCustomFormatAd.OnCustomClickListener)var3_4);
            try {
                void var1_1;
                this.zzb.zzi((String)var1_1, zzbsj2.zza(), zzbsj2.zzb());
                return this;
            }
            catch (RemoteException remoteException) {
                zzo.zzj("Failed to add custom format ad listener", remoteException);
                return this;
            }
        }

        /*
         * WARNING - void declaration
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @NonNull
        public Builder forAdManagerAdView(@NonNull OnAdManagerAdViewLoadedListener listener, AdSize ... adSizes) {
            zzbt zzbt2;
            if (adSizes == null || ((void)zzbt2).length <= 0) {
                throw new IllegalArgumentException("The supported ad sizes must contain at least one valid ad size.");
            }
            try {
                void var1_1;
                zzr zzr2 = new zzr(this.zza, (AdSize[])zzbt2);
                zzbt2 = this.zzb;
                zzbt2.zzk(new zzbhy((OnAdManagerAdViewLoadedListener)var1_1), zzr2);
                return this;
            }
            catch (RemoteException remoteException) {
                zzo.zzj("Failed to add Google Ad Manager banner ad listener", remoteException);
                return this;
            }
        }

        /*
         * WARNING - void declaration
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @NonNull
        public Builder withAdListener(@NonNull AdListener listener) {
            try {
                void var1_1;
                zzbt zzbt2 = this.zzb;
                zzbt2.zzf(new com.google.android.gms.ads.internal.client.zzg((AdListener)var1_1));
                return this;
            }
            catch (RemoteException remoteException) {
                zzo.zzj("Failed to set AdListener.", remoteException);
                return this;
            }
        }

        /*
         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
         * WARNING - void declaration
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @NonNull
        public Builder withNativeAdOptions(@NonNull NativeAdOptions options) {
            int n;
            boolean bl;
            int n2;
            int n3;
            boolean bl2;
            int n4;
            boolean bl3;
            boolean bl4;
            zzbt zzbt2;
            try {
                void var1_1;
                zzbt2 = this.zzb;
                bl4 = var1_1.shouldReturnUrlsForImageAssets();
                bl3 = var1_1.shouldRequestMultipleImages();
                n4 = var1_1.getAdChoicesPlacement();
                VideoOptions videoOptions = var1_1.getVideoOptions();
                if (videoOptions != null) {
                    zzga zzga2 = new zzga(var1_1.getVideoOptions());
                } else {
                    Object var2_12 = null;
                }
                bl2 = var1_1.zza();
                n3 = var1_1.getMediaAspectRatio();
                n2 = var1_1.zzb();
                bl = var1_1.zzc();
                n = var1_1.zzd();
            }
            catch (RemoteException remoteException) {
                zzo.zzj("Failed to specify native ad options", remoteException);
                return this;
            }
            {
                void var2_11;
                zzbfl zzbfl2 = new zzbfl(4, bl4, -1, bl3, n4, (zzga)var2_11, bl2, n3, n2, bl, --n);
                zzbt2.zzj(zzbfl2);
                return this;
            }
        }

        /*
         * WARNING - void declaration
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @NonNull
        public Builder withAdManagerAdViewOptions(@NonNull AdManagerAdViewOptions options) {
            try {
                void var1_1;
                this.zzb.zzp((AdManagerAdViewOptions)var1_1);
                return this;
            }
            catch (RemoteException remoteException) {
                zzo.zzj("Failed to specify Ad Manager banner ad options", remoteException);
                return this;
            }
        }

        @NonNull
        public AdLoader build() {
            try {
                Context context = builder.zza;
                zzbq zzbq2 = builder.zzb.zze();
                AdLoader adLoader = new AdLoader(context, zzbq2, zzq.zza);
                return adLoader;
            }
            catch (RemoteException remoteException) {
                zzo.zzg("Failed to build AdLoader.", remoteException);
                zzfi zzfi2 = new zzfi();
                Builder builder = builder.zza;
                return new AdLoader((Context)builder, zzfi2.zzb(), zzq.zza);
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Deprecated
        public final Builder zza(zzg zzg2) {
            try {
                zzbt zzbt2 = this.zzb;
                zzbt2.zzm(new zzbhz(zzg2));
                return this;
            }
            catch (RemoteException remoteException) {
                zzo.zzj("Failed to add google native ad listener", remoteException);
                return this;
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Deprecated
        public final Builder zzb(String string, zze zze2, @Nullable zzd zzd2) {
            zzbhw zzbhw2 = new zzbhw(zze2, zzd2);
            try {
                this.zzb.zzi(string, zzbhw2.zza(), zzbhw2.zzb());
                return this;
            }
            catch (RemoteException remoteException) {
                zzo.zzj("Failed to add custom template ad listener", remoteException);
                return this;
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Deprecated
        @NonNull
        public final Builder zzc(@NonNull com.google.android.gms.ads.formats.NativeAdOptions nativeAdOptions) {
            try {
                this.zzb.zzj(new zzbfl(nativeAdOptions));
                return this;
            }
            catch (RemoteException remoteException) {
                zzo.zzj("Failed to specify native ad options", remoteException);
                return this;
            }
        }
    }
}

