/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.ads;

import android.content.Context;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.android.gms.ads.internal.client.zzbb;
import com.google.android.gms.ads.internal.client.zzr;
import com.google.android.gms.ads.internal.util.client.zzf;
import com.google.android.gms.ads.internal.util.client.zzo;

public final class AdSize {
    public static final int FULL_WIDTH = -1;
    public static final int AUTO_HEIGHT = -2;
    @NonNull
    public static final AdSize BANNER;
    @NonNull
    public static final AdSize FULL_BANNER;
    @NonNull
    public static final AdSize LARGE_BANNER;
    @NonNull
    public static final AdSize LEADERBOARD;
    @NonNull
    public static final AdSize MEDIUM_RECTANGLE;
    @NonNull
    public static final AdSize WIDE_SKYSCRAPER;
    @Deprecated
    @NonNull
    public static final AdSize SMART_BANNER;
    @NonNull
    public static final AdSize FLUID;
    @NonNull
    public static final AdSize INVALID;
    @NonNull
    public static final AdSize zza;
    private final int zzb;
    private final int zzc;
    private final String zzd;
    private boolean zze;
    private boolean zzf;
    private int zzg;
    private boolean zzh;
    private int zzi;

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    public AdSize(int width, int height) {
        void var2_2;
        void var1_1;
        String string = width == -1 ? "FULL" : String.valueOf((int)var1_1);
        String string2 = var2_2 == -2 ? "AUTO" : String.valueOf((int)var2_2);
        String string3 = String.valueOf(string2);
        int n = String.valueOf(string).length() + 1 + string3.length();
        StringBuilder stringBuilder = new StringBuilder(n + 3);
        stringBuilder.append(string);
        stringBuilder.append("x");
        stringBuilder.append(string2);
        stringBuilder.append("_as");
        this((int)var1_1, (int)var2_2, stringBuilder.toString());
    }

    AdSize(int n, int n2, String string) {
        if (n >= 0 || n == -1 || n == -3) {
            if (n2 < 0 && n2 != -2 && n2 != -4) {
                int n3 = String.valueOf(n2).length();
                StringBuilder stringBuilder = new StringBuilder(n3 + 27);
                stringBuilder.append("Invalid height for AdSize: ");
                stringBuilder.append(n2);
                throw new IllegalArgumentException(stringBuilder.toString());
            }
        } else {
            int n4 = String.valueOf(n).length();
            StringBuilder stringBuilder = new StringBuilder(n4 + 26);
            stringBuilder.append("Invalid width for AdSize: ");
            stringBuilder.append(n);
            throw new IllegalArgumentException(stringBuilder.toString());
        }
        this.zzb = n;
        this.zzc = n2;
        this.zzd = string;
    }

    /*
     * WARNING - void declaration
     */
    @NonNull
    public static AdSize getPortraitAnchoredAdaptiveBannerAdSize(@NonNull Context context, int width) {
        void var1_1;
        com.google.android.gms.ads.internal.util.client.zzf.zzj(context, (int)var1_1, 50, 1).zze = true;
        return com.google.android.gms.ads.internal.util.client.zzf.zzj(context, (int)var1_1, 50, 1);
    }

    /*
     * WARNING - void declaration
     */
    @NonNull
    public static AdSize getLandscapeAnchoredAdaptiveBannerAdSize(@NonNull Context context, int width) {
        void var1_1;
        com.google.android.gms.ads.internal.util.client.zzf.zzj(context, (int)var1_1, 50, 2).zze = true;
        return com.google.android.gms.ads.internal.util.client.zzf.zzj(context, (int)var1_1, 50, 2);
    }

    /*
     * WARNING - void declaration
     */
    @NonNull
    public static AdSize getCurrentOrientationAnchoredAdaptiveBannerAdSize(@NonNull Context context, int width) {
        void var1_1;
        com.google.android.gms.ads.internal.util.client.zzf.zzj(context, (int)var1_1, 50, 0).zze = true;
        return com.google.android.gms.ads.internal.util.client.zzf.zzj(context, (int)var1_1, 50, 0);
    }

    /*
     * WARNING - void declaration
     */
    @NonNull
    public static AdSize getPortraitInlineAdaptiveBannerAdSize(@NonNull Context context, int width) {
        void var1_2;
        int n = com.google.android.gms.ads.internal.util.client.zzf.zzp(context, 1);
        AdSize adSize = new AdSize((int)var1_2, 0);
        if (n == -1) {
            return INVALID;
        }
        adSize.zzg = n;
        adSize.zzf = true;
        return adSize;
    }

    /*
     * WARNING - void declaration
     */
    @NonNull
    public static AdSize getLandscapeInlineAdaptiveBannerAdSize(@NonNull Context context, int width) {
        void var1_2;
        int n = com.google.android.gms.ads.internal.util.client.zzf.zzp(context, 2);
        AdSize adSize = new AdSize((int)var1_2, 0);
        if (n == -1) {
            return INVALID;
        }
        adSize.zzg = n;
        adSize.zzf = true;
        return adSize;
    }

    /*
     * WARNING - void declaration
     */
    @NonNull
    public static AdSize getCurrentOrientationInlineAdaptiveBannerAdSize(@NonNull Context context, int width) {
        void var1_2;
        int n = com.google.android.gms.ads.internal.util.client.zzf.zzp(context, 0);
        if (n == -1) {
            return INVALID;
        }
        new AdSize((int)var1_2, 0).zzg = n;
        new AdSize((int)var1_2, 0).zzf = true;
        return new AdSize((int)var1_2, 0);
    }

    /*
     * WARNING - void declaration
     */
    @NonNull
    public static AdSize getInlineAdaptiveBannerAdSize(int width, int maxHeight) {
        void var1_1;
        int n;
        AdSize adSize = new AdSize(n, 0);
        adSize.zzg = var1_1;
        adSize.zzf = true;
        if (var1_1 < 32) {
            n = String.valueOf((int)var1_1).length();
            StringBuilder stringBuilder = new StringBuilder(n + 118);
            stringBuilder.append("The maximum height set for the inline adaptive ad size was ");
            stringBuilder.append((int)var1_1);
            stringBuilder.append(" dp, which is below the minimum recommended value of 32 dp.");
            zzo.zzi(stringBuilder.toString());
        }
        return adSize;
    }

    public boolean equals(@Nullable Object other) {
        AdSize adSize;
        if (other == null) {
            return false;
        }
        if (adSize == this) {
            return true;
        }
        if (!(adSize instanceof AdSize)) {
            return false;
        }
        adSize = adSize;
        return this.zzb == adSize.zzb && this.zzc == adSize.zzc && this.zzd.equals(adSize.zzd);
    }

    public int getHeight() {
        return this.zzc;
    }

    /*
     * WARNING - void declaration
     */
    public int getHeightInPixels(@NonNull Context context) {
        void var1_2;
        int n = this.zzc;
        switch (n) {
            default: {
                zzbb.zza();
                return com.google.android.gms.ads.internal.util.client.zzf.zzC((Context)var1_2, n);
            }
            case -4: 
            case -3: {
                return -1;
            }
            case -2: 
        }
        return zzr.zza(var1_2.getResources().getDisplayMetrics());
    }

    public int getWidth() {
        return this.zzb;
    }

    /*
     * WARNING - void declaration
     */
    public int getWidthInPixels(@NonNull Context context) {
        void var1_2;
        int n = this.zzb;
        switch (n) {
            default: {
                zzbb.zza();
                return com.google.android.gms.ads.internal.util.client.zzf.zzC((Context)var1_2, n);
            }
            case -3: {
                return -1;
            }
            case -1: 
        }
        return var1_2.getResources().getDisplayMetrics().widthPixels;
    }

    public int hashCode() {
        return this.zzd.hashCode();
    }

    public boolean isAutoHeight() {
        return this.zzc == -2;
    }

    public boolean isFullWidth() {
        return this.zzb == -1;
    }

    public boolean isFluid() {
        return this.zzb == -3 && this.zzc == -4;
    }

    @NonNull
    public String toString() {
        return this.zzd;
    }

    static {
        String string = "320x50_mb";
        BANNER = new AdSize(320, 50, string);
        string = "468x60_as";
        FULL_BANNER = new AdSize(468, 60, string);
        string = "320x100_as";
        LARGE_BANNER = new AdSize(320, 100, string);
        string = "728x90_as";
        LEADERBOARD = new AdSize(728, 90, string);
        string = "300x250_as";
        MEDIUM_RECTANGLE = new AdSize(300, 250, string);
        string = "160x600_as";
        WIDE_SKYSCRAPER = new AdSize(160, 600, string);
        string = "smart_banner";
        SMART_BANNER = new AdSize(-1, -2, string);
        string = "fluid";
        FLUID = new AdSize(-3, -4, string);
        INVALID = new AdSize(0, 0, "invalid");
        string = "50x50_mb";
        zza = new AdSize(50, 50, string);
        string = "search_v2";
        new AdSize(-3, 0, string);
    }

    final boolean zza() {
        return this.zze;
    }

    final boolean zzb() {
        return this.zzf;
    }

    final void zzc(boolean bl) {
        this.zzf = true;
    }

    final void zzd(int n) {
        this.zzg = n;
    }

    final int zze() {
        return this.zzg;
    }

    final boolean zzf() {
        return this.zzh;
    }

    final void zzg(boolean bl) {
        this.zzh = true;
    }

    final int zzh() {
        return this.zzi;
    }

    final void zzi(int n) {
        this.zzi = n;
    }
}

