/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.ads;

import android.content.Context;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresPermission;
import com.google.android.gms.ads.AdListener;
import com.google.android.gms.ads.AdRequest;
import com.google.android.gms.ads.AdSize;
import com.google.android.gms.ads.OnPaidEventListener;
import com.google.android.gms.ads.ResponseInfo;
import com.google.android.gms.ads.admanager.AppEventListener;
import com.google.android.gms.ads.internal.client.zza;
import com.google.android.gms.ads.internal.client.zzbd;
import com.google.android.gms.ads.internal.client.zzen;
import com.google.android.gms.ads.internal.util.client.zzb;
import com.google.android.gms.ads.internal.util.client.zzo;
import com.google.android.gms.ads.zzd;
import com.google.android.gms.ads.zze;
import com.google.android.gms.ads.zzf;
import com.google.android.gms.ads.zzg;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.internal.ads.zzbbz;
import com.google.android.gms.internal.ads.zzbci;
import com.google.android.gms.internal.ads.zzbeg;
import org.checkerframework.checker.initialization.qual.NotOnlyInitialized;

public abstract class BaseAdView
extends ViewGroup {
    @NotOnlyInitialized
    protected final zzen zza;

    /*
     * WARNING - void declaration
     */
    protected BaseAdView(@NonNull Context context, int adViewType) {
        super((Context)var1_1);
        void var2_2;
        void var1_1;
        this.zza = new zzen(this, (int)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    protected BaseAdView(@NonNull Context context, @NonNull AttributeSet attrs, int adViewType) {
        super((Context)var1_1, (AttributeSet)var2_2);
        void var3_3;
        void var2_2;
        void var1_1;
        this.zza = new zzen(this, (AttributeSet)var2_2, false, (int)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    protected BaseAdView(@NonNull Context context, @NonNull AttributeSet attrs, boolean allowMultipleAdSizes) {
        super((Context)var1_1, (AttributeSet)var2_2);
        void var3_3;
        void var2_2;
        void var1_1;
        this.zza = new zzen(this, (AttributeSet)var2_2, (boolean)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    protected BaseAdView(@NonNull Context context, @NonNull AttributeSet attrs, int defStyle, int adViewType) {
        super((Context)var1_1, (AttributeSet)var2_2, (int)var3_3);
        void var4_4;
        void var3_3;
        void var2_2;
        void var1_1;
        this.zza = new zzen(this, (AttributeSet)var2_2, false, (int)var4_4);
    }

    /*
     * WARNING - void declaration
     */
    protected BaseAdView(@NonNull Context context, @NonNull AttributeSet attrs, int defStyle, int adViewType, boolean allowMultipleAdSizes) {
        super((Context)var1_1, (AttributeSet)var2_2, (int)var3_3);
        void var4_4;
        void var5_5;
        void var3_3;
        void var2_2;
        void var1_1;
        this.zza = new zzen(this, (AttributeSet)var2_2, (boolean)var5_5, (int)var4_4);
    }

    public void destroy() {
        zzbci.zza(this.getContext());
        if (((Boolean)zzbeg.zze.zze()).booleanValue()) {
            zzbbz zzbbz2 = zzbci.zzlU;
            if (((Boolean)zzbd.zzc().zzd(zzbbz2)).booleanValue()) {
                zzb.zzb.execute(new zzg(this));
                return;
            }
        }
        this.zza.zza();
    }

    @NonNull
    public AdListener getAdListener() {
        return this.zza.zzb();
    }

    @Nullable
    public AdSize getAdSize() {
        return this.zza.zzc();
    }

    @NonNull
    public String getAdUnitId() {
        return this.zza.zze();
    }

    /*
     * WARNING - void declaration
     */
    @RequiresPermission(value="android.permission.INTERNET")
    public void loadAd(@NonNull AdRequest adRequest) {
        void var1_1;
        Preconditions.checkMainThread((String)"#008 Must be called on the main UI thread.");
        zzbci.zza(this.getContext());
        if (((Boolean)zzbeg.zzf.zze()).booleanValue()) {
            zzbbz zzbbz2 = zzbci.zzlX;
            if (((Boolean)zzbd.zzc().zzd(zzbbz2)).booleanValue()) {
                zzb.zzb.execute(new zzd(this, (AdRequest)var1_1));
                return;
            }
        }
        this.zza.zzg(var1_1.zza);
    }

    public void pause() {
        zzbci.zza(this.getContext());
        if (((Boolean)zzbeg.zzg.zze()).booleanValue()) {
            zzbbz zzbbz2 = zzbci.zzlV;
            if (((Boolean)zzbd.zzc().zzd(zzbbz2)).booleanValue()) {
                zzb.zzb.execute(new zze(this));
                return;
            }
        }
        this.zza.zzh();
    }

    public void resume() {
        zzbci.zza(this.getContext());
        if (((Boolean)zzbeg.zzh.zze()).booleanValue()) {
            zzbbz zzbbz2 = zzbci.zzlT;
            if (((Boolean)zzbd.zzc().zzd(zzbbz2)).booleanValue()) {
                zzb.zzb.execute(new zzf(this));
                return;
            }
        }
        this.zza.zzj();
    }

    public boolean isCollapsible() {
        return this.zza.zzr();
    }

    public boolean isLoading() {
        return this.zza.zzs();
    }

    /*
     * WARNING - void declaration
     */
    public void setAdListener(@NonNull AdListener adListener) {
        void var1_1;
        zzen this_ = ((BaseAdView)((Object)this_)).zza;
        this_.zzk((AdListener)var1_1);
        if (var1_1 == null) {
            this_.zzl(null);
            return;
        }
        if (var1_1 instanceof zza) {
            this_.zzl((zza)var1_1);
        }
        if (var1_1 instanceof AppEventListener) {
            this_.zzp((AppEventListener)var1_1);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void setAdSize(@NonNull AdSize adSize) {
        void var1_1;
        AdSize[] adSizeArray = new AdSize[]{var1_1};
        this.zza.zzm(adSizeArray);
    }

    /*
     * WARNING - void declaration
     */
    public void setAdUnitId(@NonNull String adUnitId) {
        void var1_1;
        this.zza.zzo((String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    protected void onLayout(boolean bl, int left, int top, int right, int bottom) {
        if ((this = this.getChildAt(0)) != null && this.getVisibility() != 8) {
            void var3_4;
            void var5_6;
            void var2_3;
            void var4_5;
            int n = this.getMeasuredWidth();
            int n2 = this.getMeasuredHeight();
            void v0 = var4_5 - var2_3 - n;
            var2_3 = var5_6 - var3_4 - n2;
            void v1 = v0 / 2;
            void v2 = var2_3 /= 2;
            this.layout((int)v1, (int)v2, (int)(v1 + n), (int)(v2 + n2));
            return;
        }
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int n;
        int n2;
        void var2_3;
        void var1_2;
        View view = this.getChildAt(0);
        if (view != null && view.getVisibility() != 8) {
            this.measureChild(view, (int)var1_2, (int)var2_3);
            n2 = view.getMeasuredWidth();
            n = view.getMeasuredHeight();
        } else {
            AdSize adSize;
            try {
                adSize = this.getAdSize();
            }
            catch (NullPointerException nullPointerException) {
                zzo.zzg("Unable to retrieve ad size.", nullPointerException);
                adSize = null;
            }
            if (adSize != null) {
                AdSize adSize2 = adSize;
                Context context = this.getContext();
                n2 = adSize2.getWidthInPixels(context);
                n = adSize2.getHeightInPixels(context);
            } else {
                n2 = 0;
                n = 0;
            }
        }
        BaseAdView baseAdView = this;
        int n3 = Math.max(n, baseAdView.getSuggestedMinimumHeight());
        baseAdView.setMeasuredDimension(View.resolveSize((int)Math.max(n2, this.getSuggestedMinimumWidth()), (int)var1_2), View.resolveSize((int)n3, (int)var2_3));
    }

    @Nullable
    public ResponseInfo getResponseInfo() {
        return this.zza.zzt();
    }

    /*
     * WARNING - void declaration
     */
    public void setOnPaidEventListener(@Nullable OnPaidEventListener listener) {
        void var1_1;
        this.zza.zzu((OnPaidEventListener)var1_1);
    }

    @Nullable
    public OnPaidEventListener getOnPaidEventListener() {
        return this.zza.zzx();
    }

    public long getPlacementId() {
        return this.zza.zzv();
    }

    /*
     * WARNING - void declaration
     */
    public void setPlacementId(long placementId) {
        void var1_1;
        this.zza.zzw((long)var1_1);
    }
}

