/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.ads;

import android.os.Bundle;
import android.os.RemoteException;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.android.gms.ads.AdapterResponseInfo;
import com.google.android.gms.ads.internal.client.zzbb;
import com.google.android.gms.ads.internal.client.zzea;
import com.google.android.gms.ads.internal.client.zzv;
import com.google.android.gms.ads.internal.util.client.zzo;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public final class ResponseInfo {
    @Nullable
    private final zzea zza;
    private final List zzb;
    @Nullable
    private AdapterResponseInfo zzc;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nullable
    public String getMediationAdapterClassName() {
        try {
            zzea this_ = ((ResponseInfo)((Object)this_)).zza;
            if (this_ == null) return null;
        }
        catch (RemoteException remoteException) {
            zzo.zzg("Could not forward getMediationAdapterClassName to ResponseInfo.", remoteException);
            return null;
        }
        return this_.zze();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nullable
    public String getResponseId() {
        try {
            zzea this_ = ((ResponseInfo)((Object)this_)).zza;
            if (this_ == null) return null;
        }
        catch (RemoteException remoteException) {
            zzo.zzg("Could not forward getResponseId to ResponseInfo.", remoteException);
            return null;
        }
        return this_.zzf();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @NonNull
    public Bundle getResponseExtras() {
        try {
            zzea this_ = ((ResponseInfo)((Object)this_)).zza;
            if (this_ == null) return new Bundle();
        }
        catch (RemoteException remoteException) {
            zzo.zzg("Could not forward getResponseExtras to ResponseInfo.", remoteException);
            return new Bundle();
        }
        return this_.zzi();
    }

    @NonNull
    public List<AdapterResponseInfo> getAdapterResponses() {
        return this.zzb;
    }

    @Nullable
    public AdapterResponseInfo getLoadedAdapterResponseInfo() {
        return this.zzc;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @NonNull
    public String toString() {
        try {
            return ((ResponseInfo)this).zza().toString(2);
        }
        catch (JSONException jSONException) {
            return "Error forming toString output.";
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Lifted jumps to return sites
     */
    private ResponseInfo(@Nullable zzea iterator) {
        block7: {
            this.zza = iterator;
            this.zzb = new ArrayList();
            iterator = this.zza;
            if (iterator != null) {
                try {
                    if ((iterator = iterator.zzg()) == null) break block7;
                    iterator = iterator.iterator();
                }
                catch (RemoteException remoteException) {
                    zzo.zzg("Could not forward getAdapterResponseInfo to ResponseInfo.", remoteException);
                }
                while (iterator.hasNext()) {
                    AdapterResponseInfo adapterResponseInfo = AdapterResponseInfo.zza((zzv)((Object)iterator.next()));
                    if (adapterResponseInfo == null) continue;
                    this.zzb.add(adapterResponseInfo);
                }
            }
        }
        if ((iterator = this.zza) == null) {
            return;
        }
        try {
            if ((iterator = iterator.zzh()) == null) return;
        }
        catch (RemoteException remoteException) {
            zzo.zzg("Could not forward getLoadedAdapterResponse to ResponseInfo.", remoteException);
            return;
        }
        this.zzc = AdapterResponseInfo.zza(iterator);
    }

    /*
     * Enabled aggressive block sorting
     */
    @NonNull
    public final JSONObject zza() throws JSONException {
        JSONObject jSONObject = new JSONObject();
        Object object = responseInfo.getResponseId();
        if (object == null) {
            jSONObject.put("Response ID", (Object)"null");
        } else {
            jSONObject.put("Response ID", object);
        }
        if ((object = responseInfo.getMediationAdapterClassName()) == null) {
            jSONObject.put("Mediation Adapter Class Name", (Object)"null");
        } else {
            jSONObject.put("Mediation Adapter Class Name", object);
        }
        object = new JSONArray();
        Iterator iterator = responseInfo.zzb.iterator();
        while (iterator.hasNext()) {
            object.put((Object)((AdapterResponseInfo)iterator.next()).zzb());
        }
        jSONObject.put("Adapter Responses", object);
        object = responseInfo.zzc;
        if (object != null) {
            jSONObject.put("Loaded Adapter Response", (Object)((AdapterResponseInfo)object).zzb());
        }
        if ((responseInfo = responseInfo.getResponseExtras()) != null) {
            ResponseInfo responseInfo = zzbb.zza().zzm((Bundle)responseInfo);
            jSONObject.put("Response Extras", (Object)responseInfo);
        }
        return jSONObject;
    }

    @Nullable
    public static ResponseInfo zzb(@Nullable zzea zzea2) {
        if (zzea2 != null) {
            return new ResponseInfo(zzea2);
        }
        return null;
    }

    @NonNull
    public static ResponseInfo zzc(@Nullable zzea zzea2) {
        return new ResponseInfo(zzea2);
    }

    @Nullable
    public final zzea zzd() {
        return this.zza;
    }
}

