/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.ads;

import android.content.Context;
import android.net.Uri;
import android.os.RemoteException;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import com.google.android.gms.ads.h5.OnH5AdsEventListener;
import com.google.android.gms.ads.internal.client.zzbb;
import com.google.android.gms.ads.internal.client.zzbd;
import com.google.android.gms.ads.internal.util.client.zzo;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.internal.ads.zzbbz;
import com.google.android.gms.internal.ads.zzbci;
import com.google.android.gms.internal.ads.zzbko;
import com.google.android.gms.internal.ads.zzbot;

@RequiresApi(api=21)
public final class zzbks {
    private final Context zza;
    private final OnH5AdsEventListener zzb;
    @Nullable
    private zzbko zzc;

    public zzbks(Context context, OnH5AdsEventListener onH5AdsEventListener) {
        Preconditions.checkState((boolean)true, (Object)"Android version must be Lollipop or higher");
        Preconditions.checkNotNull((Object)context);
        Preconditions.checkNotNull((Object)onH5AdsEventListener);
        this.zza = context;
        this.zzb = onH5AdsEventListener;
        zzbci.zza(context);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean zza(String string) {
        if (!zzbks.zzc(string)) {
            return false;
        }
        ((zzbks)((Object)zzbko2)).zzd();
        zzbko zzbko2 = ((zzbks)((Object)zzbko2)).zzc;
        if (zzbko2 == null) return false;
        try {
            zzbko2.zze(string);
            return true;
        }
        catch (RemoteException remoteException) {
            zzo.zzl("#007 Could not call remote method.", remoteException);
            return true;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void zzb() {
        block5: {
            block4: {
                zzbbz zzbbz2 = zzbci.zzkK;
                if (!((Boolean)zzbd.zzc().zzd(zzbbz2)).booleanValue()) break block4;
                ((zzbks)((Object)zzbko2)).zzd();
                zzbko zzbko2 = ((zzbks)((Object)zzbko2)).zzc;
                if (zzbko2 != null) break block5;
            }
            return;
        }
        try {
            zzbko2.zzf();
            return;
        }
        catch (RemoteException remoteException) {
            zzo.zzl("#007 Could not call remote method.", remoteException);
            return;
        }
    }

    private final void zzd() {
        if (this.zzc != null) {
            return;
        }
        Context context = this.zza;
        this.zzc = zzbb.zzb().zzl(context, new zzbot(), this.zzb);
    }

    public static final boolean zzc(String string) {
        Object object = zzbci.zzkK;
        if (!((Boolean)zzbd.zzc().zzd((zzbbz)object)).booleanValue()) {
            return false;
        }
        Preconditions.checkNotNull((Object)string);
        object = zzbci.zzkM;
        if (string.length() > (Integer)zzbd.zzc().zzd((zzbbz)object)) {
            zzo.zzd("H5 GMSG exceeds max length");
            return false;
        }
        object = (string = Uri.parse((String)string)).getScheme();
        return "gmsg".equals(object) && "mobileads.google.com".equals(object = string.getHost()) && "/h5ads".equals(string = string.getPath());
    }
}

