/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.ads;

import android.content.Context;
import android.os.RemoteException;
import android.text.TextUtils;
import android.webkit.WebView;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresPermission;
import androidx.browser.customtabs.CustomTabsCallback;
import androidx.browser.customtabs.CustomTabsClient;
import androidx.browser.customtabs.CustomTabsSession;
import com.google.android.gms.ads.OnAdInspectorClosedListener;
import com.google.android.gms.ads.RequestConfiguration;
import com.google.android.gms.ads.VersionInfo;
import com.google.android.gms.ads.initialization.InitializationStatus;
import com.google.android.gms.ads.initialization.OnInitializationCompleteListener;
import com.google.android.gms.ads.internal.client.zzex;
import com.google.android.gms.ads.internal.util.client.zzo;
import com.google.android.gms.ads.mediation.rtb.RtbAdapter;
import com.google.android.gms.ads.preload.PreloadCallback;
import com.google.android.gms.ads.preload.PreloadConfiguration;
import com.google.android.gms.common.annotation.KeepForSdk;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.dynamic.IObjectWrapper;
import com.google.android.gms.dynamic.ObjectWrapper;
import com.google.android.gms.internal.ads.zzbvz;
import com.google.android.gms.internal.ads.zzcas;
import java.util.List;

public class MobileAds {
    @NonNull
    public static final String ERROR_DOMAIN = "com.google.android.gms.ads";

    private MobileAds() {
    }

    @RequiresPermission(value="android.permission.INTERNET")
    public static void initialize(@NonNull Context context) {
        Context context2;
        zzex.zzb().zzc(context2, null, null);
    }

    /*
     * WARNING - void declaration
     */
    public static void initialize(@NonNull Context context, @NonNull OnInitializationCompleteListener listener) {
        void var1_1;
        Context context2;
        zzex.zzb().zzc(context2, null, (OnInitializationCompleteListener)var1_1);
    }

    public static void setAppVolume(float volume) {
        float f;
        zzex.zzb().zze(f);
    }

    public static void setAppMuted(boolean muted) {
        boolean bl;
        zzex.zzb().zzg(bl);
    }

    /*
     * WARNING - void declaration
     */
    public static void openDebugMenu(@NonNull Context context, @NonNull String adUnitId) {
        void var1_1;
        Context context2;
        zzex.zzb().zzi(context2, (String)var1_1);
    }

    @KeepForSdk
    public static void registerRtbAdapter(@NonNull Class<? extends RtbAdapter> adapterClass) {
        Class<? extends RtbAdapter> clazz;
        zzex.zzb().zzj(clazz);
    }

    @Nullable
    public static InitializationStatus getInitializationStatus() {
        return zzex.zzb().zzk();
    }

    @NonNull
    public static RequestConfiguration getRequestConfiguration() {
        return zzex.zzb().zzo();
    }

    public static void setRequestConfiguration(@NonNull RequestConfiguration requestConfiguration) {
        RequestConfiguration requestConfiguration2;
        zzex.zzb().zzp(requestConfiguration2);
    }

    public static void disableMediationAdapterInitialization(@NonNull Context context) {
        Context context2;
        zzex.zzb().zzl(context2);
    }

    /*
     * WARNING - void declaration
     */
    public static void openAdInspector(@NonNull Context context, @NonNull OnAdInspectorClosedListener listener) {
        void var1_1;
        Context context2;
        zzex.zzb().zzm(context2, (OnAdInspectorClosedListener)var1_1);
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @NonNull
    public static VersionInfo getVersion() {
        void var0_2;
        zzex.zzb();
        String[] stringArray = TextUtils.split((String)"24.7.0", (String)"\\.");
        if (stringArray.length != 3) {
            VersionInfo versionInfo = new VersionInfo(0, 0, 0);
            return var0_2;
        }
        try {
            VersionInfo versionInfo;
            VersionInfo versionInfo2 = versionInfo = new VersionInfo(Integer.parseInt(stringArray[0]), Integer.parseInt(stringArray[1]), Integer.parseInt(stringArray[2]));
            return var0_2;
        }
        catch (NumberFormatException numberFormatException) {
            VersionInfo versionInfo = new VersionInfo(0, 0, 0);
            return var0_2;
        }
    }

    @KeepForSdk
    private static String getInternalVersion() {
        return zzex.zzb().zzn();
    }

    public static void registerWebView(@NonNull WebView webview) {
        WebView webView;
        zzex.zzb();
        Preconditions.checkMainThread((String)"#008 Must be called on the main UI thread.");
        if (webView == null) {
            zzo.zzf("The webview to be registered cannot be null.");
            return;
        }
        zzcas zzcas2 = zzbvz.zza(webView.getContext());
        if (zzcas2 == null) {
            zzo.zzf("Internal error, query info generator is null.");
            return;
        }
        try {
            zzcas2.zzj(ObjectWrapper.wrap((Object)webView));
            return;
        }
        catch (RemoteException remoteException) {
            zzo.zzg("", remoteException);
            return;
        }
    }

    public static boolean putPublisherFirstPartyIdEnabled(boolean enabled) {
        boolean bl;
        return zzex.zzb().zzq(bl);
    }

    @KeepForSdk
    private static void setPlugin(String plugin) {
        String string;
        zzex.zzb().zzr(string);
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nullable
    public static CustomTabsSession registerCustomTabsSession(@NonNull Context context, @NonNull CustomTabsClient client, @NonNull String origin, @Nullable CustomTabsCallback callback) {
        Context context2;
        zzex.zzb();
        Preconditions.checkMainThread((String)"#008 Must be called on the main UI thread.");
        zzcas zzcas2 = zzbvz.zza(context2);
        if (zzcas2 == null) {
            zzo.zzf("Internal error, query info generator is null.");
            return null;
        }
        try {
            void var3_4;
            void var2_3;
            void var1_2;
            return (CustomTabsSession)ObjectWrapper.unwrap((IObjectWrapper)zzcas2.zzm(ObjectWrapper.wrap((Object)context2), ObjectWrapper.wrap((Object)var1_2), (String)var2_3, ObjectWrapper.wrap((Object)var3_4)));
        }
        catch (RemoteException | IllegalArgumentException throwable) {
            zzo.zzg("Unable to register custom tabs session. Error: ", throwable);
            return null;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public static void startPreload(@NonNull Context context, @NonNull List<PreloadConfiguration> preloadConfigurations, @NonNull PreloadCallback preloadCallback) {
        void var2_2;
        void var1_1;
        Context context2;
        zzex.zzb().zzd(context2, (List)var1_1, (PreloadCallback)var2_2);
    }
}

