/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.ads;

import androidx.annotation.NonNull;
import com.google.android.gms.ads.internal.util.client.zzo;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nullable;

public class RequestConfiguration {
    public static final int TAG_FOR_CHILD_DIRECTED_TREATMENT_UNSPECIFIED = -1;
    public static final int TAG_FOR_CHILD_DIRECTED_TREATMENT_FALSE = 0;
    public static final int TAG_FOR_CHILD_DIRECTED_TREATMENT_TRUE = 1;
    public static final int TAG_FOR_UNDER_AGE_OF_CONSENT_TRUE = 1;
    public static final int TAG_FOR_UNDER_AGE_OF_CONSENT_FALSE = 0;
    public static final int TAG_FOR_UNDER_AGE_OF_CONSENT_UNSPECIFIED = -1;
    @NonNull
    public static final String MAX_AD_CONTENT_RATING_UNSPECIFIED = "";
    @NonNull
    public static final String MAX_AD_CONTENT_RATING_G = "G";
    @NonNull
    public static final String MAX_AD_CONTENT_RATING_PG = "PG";
    @NonNull
    public static final String MAX_AD_CONTENT_RATING_T = "T";
    @NonNull
    public static final String MAX_AD_CONTENT_RATING_MA = "MA";
    private final int zzb;
    private final int zzc;
    @Nullable
    private final String zzd;
    private final List zze;
    private final PublisherPrivacyPersonalizationState zzf;
    @NonNull
    public static final List zza;

    public int getTagForChildDirectedTreatment() {
        return this.zzb;
    }

    public int getTagForUnderAgeOfConsent() {
        return this.zzc;
    }

    @NonNull
    public String getMaxAdContentRating() {
        String this_ = ((RequestConfiguration)((Object)this_)).zzd;
        if (this_ == null) {
            return MAX_AD_CONTENT_RATING_UNSPECIFIED;
        }
        return this_;
    }

    @NonNull
    public List<String> getTestDeviceIds() {
        return new ArrayList<String>(this.zze);
    }

    @NonNull
    public PublisherPrivacyPersonalizationState getPublisherPrivacyPersonalizationState() {
        return this.zzf;
    }

    @NonNull
    public Builder toBuilder() {
        Builder builder = new Builder();
        builder.setTagForChildDirectedTreatment(this.zzb);
        builder.setTagForUnderAgeOfConsent(this.zzc);
        builder.setMaxAdContentRating(this.zzd);
        builder.setTestDeviceIds(this.zze);
        return builder;
    }

    static {
        String string = MAX_AD_CONTENT_RATING_MA;
        zza = Arrays.asList(string, MAX_AD_CONTENT_RATING_T, MAX_AD_CONTENT_RATING_PG, MAX_AD_CONTENT_RATING_G);
    }

    /* synthetic */ RequestConfiguration(int n, int n2, String string, List list, PublisherPrivacyPersonalizationState publisherPrivacyPersonalizationState, byte[] byArray) {
        this.zzb = n;
        this.zzc = n2;
        this.zzd = string;
        this.zze = list;
        this.zzf = publisherPrivacyPersonalizationState;
    }

    public static enum PublisherPrivacyPersonalizationState {
        DEFAULT(0),
        ENABLED(1),
        DISABLED(2);

        private final int zza;

        private PublisherPrivacyPersonalizationState(int n2) {
            this.zza = n2;
        }

        public int getValue() {
            return this.zza;
        }
    }

    public static class Builder {
        private int zza = -1;
        private int zzb = -1;
        @Nullable
        private String zzc = null;
        private final List zzd = new ArrayList();
        private PublisherPrivacyPersonalizationState zze = PublisherPrivacyPersonalizationState.DEFAULT;

        @NonNull
        public RequestConfiguration build() {
            return new RequestConfiguration(this.zza, this.zzb, this.zzc, this.zzd, this.zze, null);
        }

        /*
         * WARNING - void declaration
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @NonNull
        public Builder setTagForChildDirectedTreatment(int tagForChildDirectedTreatment) {
            void var1_1;
            if (tagForChildDirectedTreatment == -1 || var1_1 == false || var1_1 == true) {
                this.zza = var1_1;
                return this;
            }
            int n = String.valueOf((int)var1_1).length();
            StringBuilder stringBuilder = new StringBuilder(n + 57);
            stringBuilder.append("Invalid value passed to setTagForChildDirectedTreatment: ");
            stringBuilder.append((int)var1_1);
            zzo.zzi(stringBuilder.toString());
            return this;
        }

        /*
         * WARNING - void declaration
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @NonNull
        public Builder setTagForUnderAgeOfConsent(int tagForUnderAgeOfConsent) {
            void var1_1;
            if (tagForUnderAgeOfConsent == -1 || var1_1 == false || var1_1 == true) {
                this.zzb = var1_1;
                return this;
            }
            int n = String.valueOf((int)var1_1).length();
            StringBuilder stringBuilder = new StringBuilder(n + 52);
            stringBuilder.append("Invalid value passed to setTagForUnderAgeOfConsent: ");
            stringBuilder.append((int)var1_1);
            zzo.zzi(stringBuilder.toString());
            return this;
        }

        /*
         * WARNING - void declaration
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @NonNull
        public Builder setMaxAdContentRating(@Nullable String maxAdContentRating) {
            void var1_1;
            if (maxAdContentRating == null || RequestConfiguration.MAX_AD_CONTENT_RATING_UNSPECIFIED.equals(var1_1)) {
                this.zzc = null;
                return this;
            }
            if (RequestConfiguration.MAX_AD_CONTENT_RATING_G.equals(var1_1) || RequestConfiguration.MAX_AD_CONTENT_RATING_PG.equals(var1_1) || RequestConfiguration.MAX_AD_CONTENT_RATING_T.equals(var1_1) || RequestConfiguration.MAX_AD_CONTENT_RATING_MA.equals(var1_1)) {
                this.zzc = var1_1;
                return this;
            }
            zzo.zzi("Invalid value passed to setMaxAdContentRating: ".concat((String)var1_1));
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @NonNull
        public Builder setTestDeviceIds(@Nullable List<String> testDeviceIds) {
            void var1_1;
            List list = this.zzd;
            list.clear();
            if (var1_1 != null) {
                list.addAll(var1_1);
            }
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @NonNull
        public Builder setPublisherPrivacyPersonalizationState(@NonNull PublisherPrivacyPersonalizationState publisherPrivacyPersonalizationState) {
            void var1_1;
            this.zze = var1_1;
            return this;
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface MaxAdContentRating {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface TagForUnderAgeOfConsent {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface TagForChildDirectedTreatment {
    }
}

