/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.ads.rewarded;

import android.app.Activity;
import android.content.Context;
import android.os.Bundle;
import android.os.RemoteException;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.android.gms.ads.AdRequest;
import com.google.android.gms.ads.FullScreenContentCallback;
import com.google.android.gms.ads.OnPaidEventListener;
import com.google.android.gms.ads.OnUserEarnedRewardListener;
import com.google.android.gms.ads.ResponseInfo;
import com.google.android.gms.ads.admanager.AdManagerAdRequest;
import com.google.android.gms.ads.internal.client.zzbd;
import com.google.android.gms.ads.internal.util.client.zzo;
import com.google.android.gms.ads.rewarded.OnAdMetadataChangedListener;
import com.google.android.gms.ads.rewarded.RewardItem;
import com.google.android.gms.ads.rewarded.RewardedAdLoadCallback;
import com.google.android.gms.ads.rewarded.ServerSideVerificationOptions;
import com.google.android.gms.ads.rewarded.zzc;
import com.google.android.gms.ads.zzb;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.internal.ads.zzbel;
import com.google.android.gms.internal.ads.zzbeu;
import com.google.android.gms.internal.ads.zzbgs;
import com.google.android.gms.internal.ads.zzbyo;
import com.google.android.gms.internal.ads.zzbyx;

public abstract class RewardedAd {
    /*
     * WARNING - void declaration
     */
    public static void load(@NonNull Context context, @NonNull String adUnitId, @NonNull AdRequest adRequest, @NonNull RewardedAdLoadCallback loadCallback) {
        Context context2;
        void var3_3;
        void var2_2;
        void var1_1;
        Preconditions.checkNotNull((Object)context, (Object)"Context cannot be null.");
        Preconditions.checkNotNull((Object)var1_1, (Object)"AdUnitId cannot be null.");
        Preconditions.checkNotNull((Object)var2_2, (Object)"AdRequest cannot be null.");
        Preconditions.checkNotNull((Object)var3_3, (Object)"LoadCallback cannot be null.");
        Preconditions.checkMainThread((String)"#008 Must be called on the main UI thread.");
        zzbeu.zza(context2);
        if (((Boolean)zzbgs.zzk.zze()).booleanValue()) {
            zzbel zzbel2 = zzbeu.zzmi;
            if (((Boolean)zzbd.zzc().zzd(zzbel2)).booleanValue()) {
                com.google.android.gms.ads.internal.util.client.zzb.zzb.execute(new zzc(context2, (String)var1_1, (AdRequest)var2_2, (RewardedAdLoadCallback)var3_3));
                return;
            }
        }
        zzo.zzd("Loading on UI thread");
        new zzbyx(context2, (String)var1_1).zza(var2_2.zza(), (RewardedAdLoadCallback)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    public static void load(@NonNull Context context, @NonNull String adUnitId, @NonNull AdManagerAdRequest adManagerAdRequest, @NonNull RewardedAdLoadCallback loadCallback) {
        Context context2;
        void var3_3;
        void var2_2;
        void var1_1;
        Preconditions.checkNotNull((Object)context, (Object)"Context cannot be null.");
        Preconditions.checkNotNull((Object)var1_1, (Object)"AdUnitId cannot be null.");
        Preconditions.checkNotNull((Object)var2_2, (Object)"AdManagerAdRequest cannot be null.");
        Preconditions.checkNotNull((Object)var3_3, (Object)"LoadCallback cannot be null.");
        Preconditions.checkMainThread((String)"#008 Must be called on the main UI thread.");
        zzbeu.zza(context2);
        if (((Boolean)zzbgs.zzk.zze()).booleanValue()) {
            zzbel zzbel2 = zzbeu.zzmi;
            if (((Boolean)zzbd.zzc().zzd(zzbel2)).booleanValue()) {
                zzo.zzd("Loading on background thread");
                com.google.android.gms.ads.internal.util.client.zzb.zzb.execute(new com.google.android.gms.ads.rewarded.zzb(context2, (String)var1_1, (AdManagerAdRequest)var2_2, (RewardedAdLoadCallback)var3_3));
                return;
            }
        }
        zzo.zzd("Loading on UI thread");
        new zzbyx(context2, (String)var1_1).zza(var2_2.zza(), (RewardedAdLoadCallback)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public static boolean isAdAvailable(@NonNull Context context, @NonNull String adUnitId) {
        void var1_3;
        Preconditions.checkNotNull((Object)context, (Object)"Context cannot be null.");
        Preconditions.checkNotNull((Object)var1_3, (Object)"AdUnitId cannot be null.");
        try {
            Context context2;
            boolean bl = zzb.zza(context2).zzf((String)var1_3);
            return bl;
        }
        catch (RemoteException remoteException) {
            zzo.zzl("#007 Could not call remote method.", remoteException);
            return false;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    @Nullable
    public static RewardedAd pollAd(@NonNull Context context, @NonNull String adUnitId) {
        zzbyo zzbyo2;
        Object object;
        void var1_2;
        block4: {
            Preconditions.checkNotNull((Object)context, (Object)"Context cannot be null.");
            Preconditions.checkNotNull((Object)var1_2, (Object)"AdUnitId cannot be null.");
            try {
                zzbyo2 = zzb.zza(object).zzg((String)var1_2);
                if (zzbyo2 != null) break block4;
            }
            catch (RemoteException remoteException) {
                zzo.zzl("#007 Could not call remote method.", remoteException);
                return null;
            }
            object = "Failed to obtain a Rewarded Ad from the preloader.";
            zzo.zzl((String)object, null);
            return null;
        }
        zzbyx zzbyx2 = new zzbyx((Context)object, (String)var1_2, zzbyo2);
        return zzbyx2;
    }

    public abstract void setServerSideVerificationOptions(@Nullable ServerSideVerificationOptions var1);

    public abstract void setOnAdMetadataChangedListener(@Nullable OnAdMetadataChangedListener var1);

    @Nullable
    public abstract OnAdMetadataChangedListener getOnAdMetadataChangedListener();

    @NonNull
    public abstract Bundle getAdMetadata();

    public abstract void show(@NonNull Activity var1, @NonNull OnUserEarnedRewardListener var2);

    @NonNull
    public abstract RewardItem getRewardItem();

    @NonNull
    public abstract ResponseInfo getResponseInfo();

    public abstract void setOnPaidEventListener(@Nullable OnPaidEventListener var1);

    @Nullable
    public abstract OnPaidEventListener getOnPaidEventListener();

    public abstract void setFullScreenContentCallback(@Nullable FullScreenContentCallback var1);

    @Nullable
    public abstract FullScreenContentCallback getFullScreenContentCallback();

    @NonNull
    public abstract String getAdUnitId();

    public abstract void setImmersiveMode(boolean var1);

    public abstract long getPlacementId();

    public abstract void setPlacementId(long var1);
}

