/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.ads.internal.overlay;

import android.content.ActivityNotFoundException;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.text.TextUtils;
import androidx.annotation.Nullable;
import com.google.android.gms.ads.internal.client.zzay;
import com.google.android.gms.ads.internal.overlay.zzc;
import com.google.android.gms.ads.internal.overlay.zzu;
import com.google.android.gms.ads.internal.overlay.zzw;
import com.google.android.gms.ads.internal.util.zze;
import com.google.android.gms.ads.internal.util.zzs;
import com.google.android.gms.ads.internal.zzt;
import com.google.android.gms.internal.ads.zzbhq;
import com.google.android.gms.internal.ads.zzbhy;

public final class zza {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static final boolean zzc(Context context, Uri uri, zzw zzw2, zzu zzu2) {
        int n;
        try {
            n = zzt.zzp().zzk(context, uri);
            if (zzw2 != null) {
                zzw2.zzg();
            }
        }
        catch (ActivityNotFoundException activityNotFoundException) {
            zze.zzj((String)activityNotFoundException.getMessage());
            n = 6;
        }
        if (zzu2 != null) {
            zzu2.zzb(n);
        }
        return n == 5;
    }

    public static final boolean zza(Context context, Intent intent, zzw zzw2, @Nullable zzu zzu2, boolean bl) {
        block7: {
            if (bl) {
                return zza.zzc(context, intent.getData(), zzw2, zzu2);
            }
            try {
                String string2 = intent.toURI();
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append("Launching an intent: ");
                stringBuilder.append(string2);
                string2 = stringBuilder.toString();
                zze.zza(string2);
                zzt.zzp();
                zzs.zzI(context, intent);
                if (zzw2 == null) break block7;
            }
            catch (ActivityNotFoundException activityNotFoundException) {
                zze.zzj((String)activityNotFoundException.getMessage());
                if (zzu2 != null) {
                    zzu2.zza(false);
                }
                return false;
            }
            zzw2.zzg();
        }
        if (zzu2 != null) {
            zzu2.zza(true);
        }
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static final boolean zzb(Context context, @Nullable zzc zzc2, zzw zzw2, @Nullable zzu zzu2) {
        if (zzc2 == null) {
            zze.zzj((String)"No intent data for launcher overlay.");
            return false;
        }
        zzbhy.zzc((Context)context);
        String[] stringArray = zzc2.zzh;
        if (stringArray != null) {
            return zza.zza(context, (Intent)stringArray, zzw2, zzu2, zzc2.zzj);
        }
        Intent intent = new Intent();
        if (TextUtils.isEmpty((CharSequence)zzc2.zzb)) {
            zze.zzj((String)"Open GMSG did not contain a URL.");
            return false;
        }
        if (!TextUtils.isEmpty((CharSequence)zzc2.zzc)) {
            intent.setDataAndType(Uri.parse((String)zzc2.zzb), zzc2.zzc);
        } else {
            intent.setData(Uri.parse((String)zzc2.zzb));
        }
        intent.setAction("android.intent.action.VIEW");
        if (!TextUtils.isEmpty((CharSequence)zzc2.zzd)) {
            intent.setPackage(zzc2.zzd);
        }
        if (!TextUtils.isEmpty((CharSequence)zzc2.zze)) {
            stringArray = zzc2.zze.split("/", 2);
            if (stringArray.length < 2) {
                zze.zzj((String)"Could not parse component name from open GMSG: ".concat(String.valueOf(zzc2.zze)));
                return false;
            }
            intent.setClassName(stringArray[0], stringArray[1]);
        }
        if (!TextUtils.isEmpty((CharSequence)(stringArray = zzc2.zzf))) {
            int n;
            try {
                n = Integer.parseInt((String)stringArray);
            }
            catch (NumberFormatException numberFormatException) {
                zze.zzj((String)"Could not parse intent flags.");
                n = 0;
            }
            intent.addFlags(n);
        }
        zzbhq zzbhq2 = zzbhy.zzdA;
        if (((Boolean)zzay.zzc().zzb(zzbhq2)).booleanValue()) {
            intent.addFlags(0x10000000);
            intent.putExtra("android.support.customtabs.extra.user_opt_out", true);
            return zza.zza(context, intent, zzw2, zzu2, zzc2.zzj);
        }
        zzbhq2 = zzbhy.zzdz;
        if ((Boolean)zzay.zzc().zzb(zzbhq2) == false) return zza.zza(context, intent, zzw2, zzu2, zzc2.zzj);
        zzt.zzp();
        zzs.zzm(context, intent);
        return zza.zza(context, intent, zzw2, zzu2, zzc2.zzj);
    }
}

