/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.ads.internal.util;

import android.os.Bundle;
import android.os.Parcelable;
import android.util.JsonReader;
import android.util.JsonToken;
import android.util.JsonWriter;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.android.gms.ads.internal.util.zzbs;
import com.google.android.gms.ads.internal.util.zzbt;
import com.google.android.gms.ads.internal.util.zze;
import com.google.android.gms.internal.ads.zzfbl;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public final class zzbu {
    public static final zzbt zza;

    /*
     * Enabled aggressive block sorting
     */
    @Nullable
    public static Bundle zza(JSONObject jSONObject) {
        if (jSONObject == null) {
            return null;
        }
        Iterator iterator = jSONObject.keys();
        Bundle bundle = new Bundle();
        while (true) {
            String[] stringArray;
            int n;
            JSONArray jSONArray;
            String string2;
            block23: {
                Bundle[] bundleArray;
                if (!iterator.hasNext()) {
                    return bundle;
                }
                string2 = (String)iterator.next();
                Object object = jSONObject.opt(string2);
                if (object == null) continue;
                if (object instanceof Boolean) {
                    bundle.putBoolean(string2, ((Boolean)object).booleanValue());
                    continue;
                }
                if (object instanceof Double) {
                    bundle.putDouble(string2, ((Double)object).doubleValue());
                    continue;
                }
                if (object instanceof Integer) {
                    bundle.putInt(string2, ((Integer)object).intValue());
                    continue;
                }
                if (object instanceof Long) {
                    bundle.putLong(string2, ((Long)object).longValue());
                    continue;
                }
                if (object instanceof String) {
                    bundle.putString(string2, (String)object);
                    continue;
                }
                if (object instanceof JSONArray) {
                    jSONArray = (JSONArray)object;
                    if (jSONArray.length() == 0) continue;
                    n = jSONArray.length();
                    object = null;
                } else {
                    if (object instanceof JSONObject) {
                        bundle.putBundle(string2, zzbu.zza((JSONObject)object));
                        continue;
                    }
                    zze.zzj((String)"Unsupported type for key:".concat(String.valueOf(string2)));
                    continue;
                }
                for (int i = 0; object == null && i < n; ++i) {
                    object = !jSONArray.isNull(i) ? jSONArray.opt(i) : null;
                }
                if (object == null) {
                    zze.zzj((String)"Expected JSONArray with at least 1 non-null element for key:".concat(String.valueOf(string2)));
                    continue;
                }
                if (object instanceof JSONObject) {
                    bundleArray = new Bundle[n];
                } else {
                    if (object instanceof Number) {
                        double[] dArray = new double[jSONArray.length()];
                        for (int i = 0; i < n; ++i) {
                            dArray[i] = jSONArray.optDouble(i);
                        }
                        bundle.putDoubleArray(string2, dArray);
                        continue;
                    }
                    if (object instanceof CharSequence) {
                        stringArray = new String[n];
                        break block23;
                    } else {
                        if (object instanceof Boolean) {
                            boolean[] blArray = new boolean[n];
                            for (int i = 0; i < n; ++i) {
                                blArray[i] = jSONArray.optBoolean(i);
                            }
                            bundle.putBooleanArray(string2, blArray);
                            continue;
                        }
                        Object[] objectArray = new Object[]{object.getClass().getCanonicalName(), string2};
                        zze.zzj((String)String.format("JSONArray with unsupported type %s for key:%s", objectArray));
                        continue;
                    }
                }
                for (int i = 0; i < n; ++i) {
                    Bundle bundle2 = !jSONArray.isNull(i) ? zzbu.zza(jSONArray.optJSONObject(i)) : null;
                    bundleArray[i] = bundle2;
                }
                bundle.putParcelableArray(string2, (Parcelable[])bundleArray);
                continue;
            }
            for (int i = 0; i < n; ++i) {
                String string3 = !jSONArray.isNull(i) ? jSONArray.optString(i) : null;
                stringArray[i] = string3;
            }
            bundle.putStringArray(string2, stringArray);
        }
    }

    public static String zzb(String string2, JSONObject object, String ... stringArray) {
        string2 = zzbu.zzm(object, stringArray);
        object = "";
        if (string2 == null) {
            return object;
        }
        return string2.optString(stringArray[0], (String)object);
    }

    @NonNull
    public static List zzc(@Nullable JSONArray jSONArray, @Nullable List arrayList) throws JSONException {
        if (arrayList == null) {
            arrayList = new ArrayList<String>();
        }
        if (jSONArray != null) {
            for (int i = 0; i < jSONArray.length(); ++i) {
                arrayList.add(jSONArray.getString(i));
            }
            return arrayList;
        }
        return arrayList;
    }

    public static List zzd(JsonReader jsonReader) throws IllegalStateException, IOException {
        ArrayList<String> arrayList = new ArrayList<String>();
        jsonReader.beginArray();
        while (jsonReader.hasNext()) {
            arrayList.add(jsonReader.nextString());
        }
        jsonReader.endArray();
        return arrayList;
    }

    public static JSONArray zze(JsonReader object) throws IllegalStateException, IOException, JSONException {
        JSONArray jSONArray = new JSONArray();
        object.beginArray();
        while (object.hasNext()) {
            JsonToken jsonToken = object.peek();
            if (JsonToken.BEGIN_ARRAY.equals((Object)jsonToken)) {
                jSONArray.put((Object)zzbu.zze(object));
                continue;
            }
            if (JsonToken.BEGIN_OBJECT.equals((Object)jsonToken)) {
                jSONArray.put((Object)zzbu.zzh(object));
                continue;
            }
            if (JsonToken.BOOLEAN.equals((Object)jsonToken)) {
                jSONArray.put(object.nextBoolean());
                continue;
            }
            if (JsonToken.NUMBER.equals((Object)jsonToken)) {
                jSONArray.put(object.nextDouble());
                continue;
            }
            if (JsonToken.STRING.equals((Object)jsonToken)) {
                jSONArray.put((Object)object.nextString());
                continue;
            }
            object = new IllegalStateException("unexpected json token: ".concat(String.valueOf(String.valueOf(jsonToken))));
            throw object;
        }
        object.endArray();
        return jSONArray;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static JSONObject zzf(JSONObject jSONObject, String string2) throws JSONException {
        try {
            JSONObject jSONObject2 = jSONObject.getJSONObject(string2);
            return jSONObject2;
        }
        catch (JSONException jSONException) {
            JSONObject jSONObject3 = new JSONObject();
            jSONObject.put(string2, (Object)jSONObject3);
            return jSONObject3;
        }
    }

    @Nullable
    public static JSONObject zzg(JSONObject jSONObject, String ... stringArray) {
        if ((jSONObject = zzbu.zzm(jSONObject, stringArray)) == null) {
            return null;
        }
        return jSONObject.optJSONObject(stringArray[1]);
    }

    @Nullable
    private static JSONObject zzm(JSONObject jSONObject, String[] stringArray) {
        for (int i = 0; i < stringArray.length + -1; ++i) {
            if (jSONObject == null) {
                return null;
            }
            jSONObject = jSONObject.optJSONObject(stringArray[i]);
        }
        return jSONObject;
    }

    public static JSONObject zzh(JsonReader object) throws IllegalStateException, IOException, JSONException {
        JSONObject jSONObject = new JSONObject();
        object.beginObject();
        while (object.hasNext()) {
            String string2 = object.nextName();
            JsonToken jsonToken = object.peek();
            if (JsonToken.BEGIN_ARRAY.equals((Object)jsonToken)) {
                jSONObject.put(string2, (Object)zzbu.zze(object));
                continue;
            }
            if (JsonToken.BEGIN_OBJECT.equals((Object)jsonToken)) {
                jSONObject.put(string2, (Object)zzbu.zzh(object));
                continue;
            }
            if (JsonToken.BOOLEAN.equals((Object)jsonToken)) {
                jSONObject.put(string2, object.nextBoolean());
                continue;
            }
            if (JsonToken.NUMBER.equals((Object)jsonToken)) {
                jSONObject.put(string2, object.nextDouble());
                continue;
            }
            if (JsonToken.STRING.equals((Object)jsonToken)) {
                jSONObject.put(string2, (Object)object.nextString());
                continue;
            }
            object = new IllegalStateException("unexpected json token: ".concat(String.valueOf(String.valueOf(jsonToken))));
            throw object;
        }
        object.endObject();
        return jSONObject;
    }

    static {
        zzbs zzbs2 = new zzbs();
        zza = zzbs2;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void zzi(JsonWriter object, JSONArray object2) throws IOException {
        try {
            int n;
            object.beginArray();
            for (int i = 0; i < (n = object2.length()); ++i) {
                Object object3 = object2.get(i);
                boolean bl = object3 instanceof String;
                if (bl) {
                    object.value((String)object3);
                    continue;
                }
                bl = object3 instanceof Number;
                if (bl) {
                    object.value((Number)object3);
                    continue;
                }
                bl = object3 instanceof Boolean;
                if (bl) {
                    object.value(((Boolean)object3).booleanValue());
                    continue;
                }
                bl = object3 instanceof JSONObject;
                if (bl) {
                    zzbu.zzj(object, (JSONObject)object3);
                    continue;
                }
                bl = object3 instanceof JSONArray;
                if (!bl) {
                    object2 = String.valueOf(object3);
                    StringBuilder stringBuilder = new StringBuilder();
                    stringBuilder.append("unable to write field: ");
                    stringBuilder.append((String)object2);
                    object = new JSONException(stringBuilder.toString());
                    throw object;
                }
                zzbu.zzi(object, (JSONArray)object3);
            }
            object.endArray();
            return;
        }
        catch (JSONException jSONException) {
            object2 = new IOException(jSONException);
            throw object2;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void zzj(JsonWriter object, JSONObject object2) throws IOException {
        try {
            boolean bl;
            object.beginObject();
            Object object3 = object2.keys();
            while (bl = object3.hasNext()) {
                String string2 = (String)object3.next();
                Object object4 = object2.get(string2);
                boolean bl2 = object4 instanceof String;
                if (bl2) {
                    object.name(string2).value((String)object4);
                    continue;
                }
                bl2 = object4 instanceof Number;
                if (bl2) {
                    object.name(string2).value((Number)object4);
                    continue;
                }
                bl2 = object4 instanceof Boolean;
                if (bl2) {
                    object.name(string2).value(((Boolean)object4).booleanValue());
                    continue;
                }
                bl2 = object4 instanceof JSONObject;
                if (bl2) {
                    zzbu.zzj(object.name(string2), (JSONObject)object4);
                    continue;
                }
                bl2 = object4 instanceof JSONArray;
                if (!bl2) {
                    object2 = String.valueOf(object4);
                    object3 = new StringBuilder();
                    ((StringBuilder)object3).append("unable to write field: ");
                    ((StringBuilder)object3).append((String)object2);
                    object = new JSONException(((StringBuilder)object3).toString());
                    throw object;
                }
                zzbu.zzi(object.name(string2), (JSONArray)object4);
            }
        }
        catch (JSONException jSONException) {
            object2 = new IOException(jSONException);
            throw object2;
        }
        {
            object.endObject();
            return;
        }
    }

    private static void zzn(JsonWriter jsonWriter, Object iterator) throws IOException {
        if (iterator == null) {
            jsonWriter.nullValue();
            return;
        }
        if (iterator instanceof Number) {
            jsonWriter.value((Number)((Object)iterator));
            return;
        }
        if (iterator instanceof Boolean) {
            jsonWriter.value(((Boolean)((Object)iterator)).booleanValue());
            return;
        }
        if (iterator instanceof String) {
            jsonWriter.value((String)((Object)iterator));
            return;
        }
        if (iterator instanceof zzfbl) {
            zzbu.zzj(jsonWriter, ((zzfbl)((Object)iterator)).zzd);
            return;
        }
        if (iterator instanceof Map) {
            jsonWriter.beginObject();
            for (Map.Entry entry : ((Map)((Object)iterator)).entrySet()) {
                Object k = entry.getKey();
                if (!(k instanceof String)) continue;
                entry = entry.getValue();
                zzbu.zzn(jsonWriter.name((String)k), entry);
            }
            jsonWriter.endObject();
            return;
        }
        if (iterator instanceof List) {
            jsonWriter.beginArray();
            iterator = ((List)((Object)iterator)).iterator();
            while (iterator.hasNext()) {
                zzbu.zzn(jsonWriter, iterator.next());
            }
            jsonWriter.endArray();
            return;
        }
        jsonWriter.nullValue();
    }

    public static boolean zzk(boolean bl, JSONObject jSONObject, String ... stringArray) {
        JSONObject jSONObject2 = zzbu.zzm(jSONObject, stringArray);
        if (jSONObject2 == null) {
            return false;
        }
        return jSONObject2.optBoolean(stringArray[stringArray.length + -1], false);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String zzl(zzfbl object) {
        if (object == null) {
            return null;
        }
        StringWriter stringWriter = new StringWriter();
        try {
            JsonWriter jsonWriter = new JsonWriter((Writer)stringWriter);
            zzbu.zzn(jsonWriter, object);
            jsonWriter.close();
            return stringWriter.toString();
        }
        catch (IOException iOException) {
            zze.zzh((String)"Error when writing JSON.", (Throwable)iOException);
            return null;
        }
    }
}

