/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.ads.internal.util;

import android.app.Activity;
import android.app.ActivityManager;
import android.app.KeyguardManager;
import android.content.ActivityNotFoundException;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.pm.PackageManager;
import android.content.res.Resources;
import android.graphics.Rect;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Looper;
import android.os.PowerManager;
import android.os.Process;
import android.text.TextUtils;
import android.util.DisplayMetrics;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.Window;
import android.view.WindowManager;
import android.webkit.WebResourceResponse;
import android.webkit.WebSettings;
import androidx.annotation.Nullable;
import androidx.browser.customtabs.CustomTabsIntent;
import com.google.android.gms.ads.formats.zzg;
import com.google.android.gms.ads.impl.R;
import com.google.android.gms.ads.internal.client.zzaw;
import com.google.android.gms.ads.internal.client.zzay;
import com.google.android.gms.ads.internal.util.zzbo;
import com.google.android.gms.ads.internal.util.zzbp;
import com.google.android.gms.ads.internal.util.zzbr;
import com.google.android.gms.ads.internal.util.zzby;
import com.google.android.gms.ads.internal.util.zzcb;
import com.google.android.gms.ads.internal.util.zzcc;
import com.google.android.gms.ads.internal.util.zzcd;
import com.google.android.gms.ads.internal.util.zzce;
import com.google.android.gms.ads.internal.util.zze;
import com.google.android.gms.ads.internal.util.zzf;
import com.google.android.gms.ads.internal.util.zzl;
import com.google.android.gms.ads.internal.util.zzn;
import com.google.android.gms.ads.internal.util.zzp;
import com.google.android.gms.ads.internal.util.zzr;
import com.google.android.gms.ads.internal.zzt;
import com.google.android.gms.ads.nativead.NativeAdView;
import com.google.android.gms.common.GooglePlayServicesUtilLight;
import com.google.android.gms.common.util.ClientLibraryUtils;
import com.google.android.gms.common.util.CrashUtils;
import com.google.android.gms.common.wrappers.Wrappers;
import com.google.android.gms.internal.ads.zzbhq;
import com.google.android.gms.internal.ads.zzbhw;
import com.google.android.gms.internal.ads.zzbhy;
import com.google.android.gms.internal.ads.zzbiu;
import com.google.android.gms.internal.ads.zzbiw;
import com.google.android.gms.internal.ads.zzbjw;
import com.google.android.gms.internal.ads.zzcai;
import com.google.android.gms.internal.ads.zzcfh;
import com.google.android.gms.internal.ads.zzcfv;
import com.google.android.gms.internal.ads.zzckz;
import com.google.android.gms.internal.ads.zzcmf;
import com.google.android.gms.internal.ads.zzdtr;
import com.google.android.gms.internal.ads.zzfbg;
import com.google.android.gms.internal.ads.zzfbj;
import com.google.android.gms.internal.ads.zzfnu;
import com.google.android.gms.internal.ads.zzfva;
import com.google.android.gms.internal.ads.zzfvj;
import com.google.android.gms.internal.ads.zzgqi;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.annotation.concurrent.GuardedBy;

public final class zzs {
    public static final zzfnu zza;
    private final AtomicReference zzb;
    private final AtomicReference zzc;
    private boolean zzd;
    private final Object zze;
    @GuardedBy(value="userAgentLock")
    private String zzf;
    private boolean zzg;
    private boolean zzh;
    private final Executor zzi;

    public static int zza(int n) {
        if (n >= 5000) {
            return n;
        }
        if (n > 0) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("HTTP timeout too low: ");
            stringBuilder.append(n);
            stringBuilder.append(" milliseconds. Reverting to default timeout: 60000 milliseconds.");
            com.google.android.gms.ads.internal.util.zze.zzj((String)stringBuilder.toString());
        }
        return 60000;
    }

    @Nullable
    private static KeyguardManager zzS(Context object) {
        if ((object = object.getSystemService("keyguard")) != null && object instanceof KeyguardManager) {
            return (KeyguardManager)object;
        }
        return null;
    }

    @Nullable
    private static Bundle zzT(Context context) {
        try {
            context = Wrappers.packageManager((Context)context).getApplicationInfo((String)context.getPackageName(), (int)128).metaData;
            return context;
        }
        catch (PackageManager.NameNotFoundException | NullPointerException throwable) {
            com.google.android.gms.ads.internal.util.zze.zzb("Error getting metadata", throwable);
            return null;
        }
    }

    public final zzfvj zzb(Uri uri) {
        zzl zzl2 = new zzl(uri);
        return zzfva.zzk(zzl2, this.zzi);
    }

    private static String zzU(Bundle object) {
        if (object == null) {
            return "";
        }
        if (TextUtils.isEmpty((CharSequence)(object = object.getString("com.google.android.gms.ads.APPLICATION_ID")))) {
            return "";
        }
        if (((String)object).matches("^ca-app-pub-[0-9]{16}~[0-9]{10}$") || ((String)object).matches("^/\\d+~.+$")) {
            return object;
        }
        return "";
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final String zzc(Context context, String charSequence) {
        Object object = ((zzs)this).zze;
        synchronized (object) {
            boolean bl;
            Object object2;
            String string2 = ((zzs)this).zzf;
            if (string2 != null) {
                return string2;
            }
            if (charSequence == null) {
                return zzs.zzp();
            }
            try {
                object2 = zzce.zza();
                boolean bl2 = TextUtils.isEmpty((CharSequence)((zzce)object2).zza);
                if (bl2) {
                    Object object3;
                    bl2 = ClientLibraryUtils.isPackageSide();
                    if (bl2) {
                        object3 = new zzcc(context);
                        object3 = (String)zzcb.zza((Context)context, (Callable)object3);
                    } else {
                        object3 = GooglePlayServicesUtilLight.getRemoteContext((Context)context);
                        zzcd zzcd2 = new zzcd((Context)object3, context);
                        object3 = (String)zzcb.zza((Context)context, (Callable)zzcd2);
                    }
                    ((zzce)object2).zza = object3;
                }
                ((zzs)this).zzf = string2 = ((zzce)object2).zza;
            }
            catch (Exception exception) {}
            if (bl = TextUtils.isEmpty((CharSequence)((zzs)this).zzf)) {
                ((zzs)this).zzf = WebSettings.getDefaultUserAgent((Context)context);
            }
            if (bl = TextUtils.isEmpty((CharSequence)((zzs)this).zzf)) {
                ((zzs)this).zzf = zzs.zzp();
            }
            String string3 = ((zzs)this).zzf;
            object2 = new StringBuilder();
            ((StringBuilder)object2).append(string3);
            ((StringBuilder)object2).append(" (Mobile; ");
            ((StringBuilder)object2).append((String)charSequence);
            ((zzs)this).zzf = ((StringBuilder)object2).toString();
            try {
                boolean bl3 = Wrappers.packageManager((Context)context).isCallerInstantApp();
                if (bl3) {
                    String string4 = ((zzs)this).zzf;
                    charSequence = new StringBuilder();
                    ((StringBuilder)charSequence).append(string4);
                    ((StringBuilder)charSequence).append(";aia");
                    ((zzs)this).zzf = ((StringBuilder)charSequence).toString();
                }
            }
            catch (Exception exception) {
                zzt.zzo().zzt(exception, "AdUtil.getUserAgent");
            }
            String string5 = ((zzs)this).zzf;
            charSequence = new StringBuilder();
            ((StringBuilder)charSequence).append(string5);
            ((StringBuilder)charSequence).append(")");
            ((zzs)this).zzf = ((StringBuilder)charSequence).toString();
            return ((zzs)this).zzf;
        }
    }

    static /* bridge */ /* synthetic */ void zzd(zzs zzs2, boolean bl) {
        zzs2.zzd = bl;
    }

    static {
        zzf zzf2 = new zzf(Looper.getMainLooper());
        zza = zzf2;
    }

    public zzs() {
        Object object = new AtomicReference(null);
        this.zzb = object;
        object = new AtomicReference(null);
        this.zzc = object;
        this.zzd = true;
        this.zze = object = new Object();
        this.zzg = false;
        this.zzh = false;
        this.zzi = Executors.newSingleThreadExecutor();
    }

    /*
     * WARNING - void declaration
     */
    public final void zze(Context context, String string2, boolean bl, HttpURLConnection httpURLConnection, boolean bl2, int n) {
        void var4_5;
        void var6_8;
        int n2 = zzs.zza((int)var6_8);
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("HTTP timeout: ");
        stringBuilder.append(n2);
        stringBuilder.append(" milliseconds.");
        com.google.android.gms.ads.internal.util.zze.zzi((String)stringBuilder.toString());
        var4_5.setConnectTimeout(n2);
        var4_5.setInstanceFollowRedirects(false);
        var4_5.setReadTimeout(n2);
        var4_5.setRequestProperty("User-Agent", this.zzc(context, string2));
        var4_5.setUseCaches(false);
    }

    public static void zzf(Runnable runnable) {
        if (Looper.getMainLooper().getThread() != Thread.currentThread()) {
            runnable.run();
            return;
        }
        zzcfv.zza.execute(runnable);
    }

    public final boolean zzg(String string2) {
        AtomicReference atomicReference = ((zzs)((Object)atomicReference)).zzb;
        zzbhq zzbhq2 = zzbhy.zzZ;
        return zzs.zzV(string2, atomicReference, (String)zzay.zzc().zzb(zzbhq2));
    }

    public final boolean zzh(String string2) {
        AtomicReference atomicReference = ((zzs)((Object)atomicReference)).zzc;
        zzbhq zzbhq2 = zzbhy.zzaa;
        return zzs.zzV(string2, atomicReference, (String)zzay.zzc().zzb(zzbhq2));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean zzV(String string2, AtomicReference object, String object2) {
        Pattern pattern;
        block7: {
            block6: {
                if (TextUtils.isEmpty((CharSequence)string2)) {
                    return false;
                }
                try {
                    pattern = (Pattern)((AtomicReference)object).get();
                    if (pattern == null) break block6;
                }
                catch (PatternSyntaxException patternSyntaxException) {
                    return false;
                }
                boolean bl = ((String)object2).equals(pattern.pattern());
                if (bl) break block7;
            }
            object2 = Pattern.compile((String)object2);
            ((AtomicReference)object).set(object2);
            object = object2;
            return ((Pattern)object).matcher(string2).matches();
        }
        object = pattern;
        return ((Pattern)object).matcher(string2).matches();
    }

    public final boolean zzi(Context context) {
        if (this.zzh) {
            return false;
        }
        IntentFilter intentFilter = new IntentFilter();
        intentFilter.addAction("com.google.android.ads.intent.DEBUG_LOGGING_ENABLEMENT_CHANGED");
        context = context.getApplicationContext();
        zzp zzp2 = new zzp(this, null);
        context.registerReceiver((BroadcastReceiver)zzp2, intentFilter);
        this.zzh = true;
        return true;
    }

    public final boolean zzj(Context context) {
        if (this.zzg) {
            return false;
        }
        IntentFilter intentFilter = new IntentFilter();
        intentFilter.addAction("android.intent.action.USER_PRESENT");
        intentFilter.addAction("android.intent.action.SCREEN_OFF");
        context = context.getApplicationContext();
        zzr zzr2 = new zzr(this, null);
        context.registerReceiver((BroadcastReceiver)zzr2, intentFilter);
        this.zzg = true;
        return true;
    }

    /*
     * Enabled aggressive block sorting
     */
    public final int zzk(Context context, Uri uri) {
        zzs zzs2;
        int n;
        if (context == null) {
            com.google.android.gms.ads.internal.util.zze.zza("Trying to open chrome custom tab on a null context");
            return 3;
        }
        if (!(context instanceof Activity)) {
            com.google.android.gms.ads.internal.util.zze.zza("Chrome Custom Tabs can only work with Activity context.");
            n = 2;
        } else {
            n = 0;
        }
        Object object = zzbhy.zzdC;
        zzbhw zzbhw2 = zzay.zzc();
        object = zzbhw2.zzb((zzbhq)object);
        object = (Boolean)object;
        zzbhw2 = zzbhy.zzdD;
        if (((Boolean)object).equals(zzay.zzc().zzb((zzbhq)zzbhw2))) {
            n = 9;
        }
        if (n != 0) {
            zzs2 = new Intent("android.intent.action.VIEW");
            zzs2.setData(uri);
            zzs2.addFlags(0x10000000);
            context.startActivity((Intent)zzs2);
            return n;
        }
        Object object2 = zzbhy.zzdC;
        if (((Boolean)zzay.zzc().zzb((zzbhq)object2)).booleanValue()) {
            object2 = new zzbiw();
            object = new zzn(zzs2, (zzbiw)object2, context, uri);
            ((zzbiw)object2).zze((zzbiu)object);
            ((zzbiw)object2).zzb((Activity)context);
        }
        zzs2 = zzbhy.zzdD;
        if (((Boolean)zzay.zzc().zzb((zzbhq)zzs2)).booleanValue()) {
            zzs2 = new CustomTabsIntent.Builder();
            zzs2 = zzs2.build();
            ((CustomTabsIntent)zzs2).intent.setPackage(zzgqi.zza(context));
            zzs2.launchUrl(context, uri);
        }
        return 5;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static final boolean zzl(View view) {
        if ((view = view.getRootView()) == null) {
            return false;
        }
        if (!((view = view.getContext()) instanceof Activity)) return false;
        view = (Activity)view;
        if (view == null) {
            return false;
        }
        if ((view = view.getWindow()) == null) {
            return false;
        }
        view = view.getAttributes();
        if (view == null) return false;
        if ((view.flags & 0x80000) == 0) return false;
        return true;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static final void zzm(Context context, Intent intent) {
        if (intent == null) {
            return;
        }
        Bundle bundle = intent.getExtras() != null ? intent.getExtras() : new Bundle();
        bundle.putBinder("android.support.customtabs.extra.SESSION", null);
        bundle.putString("com.android.browser.application_id", context.getPackageName());
        intent.putExtras(bundle);
    }

    public static final ViewGroup.LayoutParams zzn() {
        ViewGroup.LayoutParams layoutParams = new ViewGroup.LayoutParams(-1, -1);
        return layoutParams;
    }

    public static final String zzo(Context context) {
        if (context.getApplicationContext() != null) {
            context = context.getApplicationContext();
        }
        return zzs.zzU(zzs.zzT(context));
    }

    static final String zzp() {
        StringBuilder stringBuilder = new StringBuilder(256);
        stringBuilder.append("Mozilla/5.0 (Linux; U; Android");
        if (Build.VERSION.RELEASE != null) {
            stringBuilder.append(" ");
            stringBuilder.append(Build.VERSION.RELEASE);
        }
        stringBuilder.append("; ");
        stringBuilder.append(Locale.getDefault());
        if (Build.DEVICE != null) {
            stringBuilder.append("; ");
            stringBuilder.append(Build.DEVICE);
            if (Build.DISPLAY != null) {
                stringBuilder.append(" Build/");
                stringBuilder.append(Build.DISPLAY);
            }
        }
        stringBuilder.append(") AppleWebKit/533 Version/4.0 Safari/533");
        return stringBuilder.toString();
    }

    public static final String zzq() {
        String string2 = Build.MODEL;
        String string3 = Build.MANUFACTURER;
        if (string2.startsWith(string3)) {
            return string2;
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(string3);
        stringBuilder.append(" ");
        stringBuilder.append(string2);
        return stringBuilder.toString();
    }

    public static final DisplayMetrics zzr(WindowManager windowManager) {
        DisplayMetrics displayMetrics = new DisplayMetrics();
        windowManager.getDefaultDisplay().getMetrics(displayMetrics);
        return displayMetrics;
    }

    protected static final int[] zzs() {
        int[] nArray = new int[]{0, 0};
        return nArray;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static final long zzt(View view) {
        float f;
        block2: {
            float f2 = Float.MAX_VALUE;
            while (view instanceof View) {
                f2 = Math.min(f2, view.getAlpha());
                view = view.getParent();
                if (!(f2 <= 0.0f)) continue;
                f = f2;
                break block2;
            }
            f = f2;
        }
        if (f < 0.0f) {
            f = 0.0f;
        }
        return Math.round(f * 100.0f);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nullable
    public static final WebResourceResponse zzu(Context object, String object2, String object3) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("User-Agent", zzt.zzp().zzc((Context)object, (String)object2));
        hashMap.put("Cache-Control", "max-stale=3600");
        object2 = new zzbo((Context)object);
        object = ((zzbo)object2).zzb(0, (String)object3, hashMap, null);
        object = (String)object.get(60L, TimeUnit.SECONDS);
        if (object == null) return null;
        try {
            object3 = new ByteArrayInputStream(((String)object).getBytes("UTF-8"));
            return new WebResourceResponse("application/javascript", "UTF-8", (InputStream)object3);
        }
        catch (IOException | InterruptedException | ExecutionException | TimeoutException exception) {
            com.google.android.gms.ads.internal.util.zze.zzk((String)"Could not fetch MRAID JS.", (Throwable)exception);
            return null;
        }
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final String zzv() {
        void var0_2;
        Resources resources = zzt.zzo().zzd();
        if (resources == null) return var0_2;
        String string2 = resources.getString(R.string.s7);
        return var0_2;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nullable
    public static final zzbr zzw(Context object) {
        void var0_4;
        Object obj;
        try {
            obj = object.getClassLoader().loadClass("com.google.android.gms.ads.internal.util.WorkManagerUtil").getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception exception) {
            zzt.zzo().zzt(exception, "Failed to instantiate WorkManagerUtil");
            return null;
        }
        if (!(obj instanceof IBinder)) {
            com.google.android.gms.ads.internal.util.zze.zzg((String)"Instantiated WorkManagerUtil not instance of IBinder.");
            return null;
        }
        IBinder iBinder = (IBinder)obj;
        if (iBinder == null) {
            return var0_4;
        }
        IInterface iInterface = iBinder.queryLocalInterface("com.google.android.gms.ads.internal.util.IWorkManagerUtil");
        if (iInterface instanceof zzbr) {
            zzbr zzbr2 = (zzbr)iInterface;
            return var0_4;
        }
        IInterface iInterface2 = iInterface = new zzbp(iBinder);
        return var0_4;
    }

    public static final boolean zzx(Context context, String string2) {
        context = zzcai.zza(context);
        String string3 = context.getPackageName();
        return Wrappers.packageManager((Context)context).checkPermission(string2, string3) == 0;
    }

    public static final boolean zzy(String string2) {
        int n;
        String[] stringArray;
        if (!zzcfh.zzl()) {
            return false;
        }
        Object object = zzbhy.zzdW;
        if (!((Boolean)zzay.zzc().zzb((zzbhq)object)).booleanValue()) {
            return false;
        }
        object = zzbhy.zzdY;
        object = (String)zzay.zzc().zzb((zzbhq)object);
        if (!((String)object).isEmpty()) {
            stringArray = ((String)object).split(";");
            n = stringArray.length;
            for (int i = 0; i < n; ++i) {
                if (!stringArray[i].equals(string2)) continue;
                return false;
            }
        }
        Object object2 = zzbhy.zzdX;
        object2 = (String)zzay.zzc().zzb((zzbhq)object2);
        if (((String)object2).isEmpty()) {
            return true;
        }
        stringArray = ((String)object2).split(";");
        n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            if (!stringArray[i].equals(string2)) continue;
            return true;
        }
        return false;
    }

    public static final boolean zzz(Context context) {
        if (context == null) {
            return false;
        }
        return (context = zzs.zzS(context)) != null && context.isKeyguardLocked();
    }

    public static final boolean zzA(Context object) {
        try {
            object = object.getClassLoader();
            String string2 = "com.google.android.gms.ads.internal.ClientApi";
            ((ClassLoader)object).loadClass(string2);
            return false;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return true;
        }
        catch (Throwable throwable) {
            com.google.android.gms.ads.internal.util.zze.zzh((String)"Error loading class.", (Throwable)throwable);
            zzt.zzo().zzt(throwable, "AdUtil.isLiteSdk");
            return false;
        }
    }

    public static final boolean zzB() {
        int n = Process.myUid();
        return n == 0 || n == 1000;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static final boolean zzC(Context context) {
        try {
            block5: {
                boolean bl;
                Object object = (ActivityManager)context.getSystemService("activity");
                KeyguardManager keyguardManager = (KeyguardManager)context.getSystemService("keyguard");
                if (object == null || keyguardManager == null) {
                    return false;
                }
                if ((object = object.getRunningAppProcesses()) == null) {
                    return false;
                }
                object = object.iterator();
                while (bl = object.hasNext()) {
                    boolean bl2;
                    int n;
                    ActivityManager.RunningAppProcessInfo runningAppProcessInfo = (ActivityManager.RunningAppProcessInfo)object.next();
                    int n2 = Process.myPid();
                    if (n2 != (n = runningAppProcessInfo.pid)) continue;
                    int n3 = runningAppProcessInfo.importance;
                    if (n3 == 100 && (n3 = (int)(keyguardManager.inKeyguardRestrictedInputMode() ? 1 : 0)) == 0 && (context = (PowerManager)context.getSystemService("power")) != null && (bl2 = context.isScreenOn())) break block5;
                }
                return true;
            }
            return false;
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    public static final boolean zzD(Context context) {
        context = zzs.zzT(context);
        String string2 = context.getString("com.google.android.gms.ads.INTEGRATION_MANAGER");
        return TextUtils.isEmpty((CharSequence)zzs.zzU((Bundle)context)) && !TextUtils.isEmpty((CharSequence)string2);
    }

    public static final boolean zzE(Context context) {
        if (!(context instanceof Activity)) {
            return false;
        }
        if ((context = ((Activity)context).getWindow()) == null || context.getDecorView() == null) {
            return false;
        }
        Rect rect = new Rect();
        Rect rect2 = new Rect();
        context.getDecorView().getGlobalVisibleRect(rect, null);
        context.getDecorView().getWindowVisibleDisplayFrame(rect2);
        return rect.bottom != 0 && rect2.bottom != 0 && rect.top == rect2.top;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static final void zzF(View object, int n, MotionEvent motionEvent) {
        int[] nArray = new int[2];
        Rect rect = new Rect();
        try {
            CharSequence charSequence;
            Object object2;
            int n2;
            int n3;
            int n4;
            String string2;
            String string3 = object.getContext().getPackageName();
            boolean bl = object instanceof zzdtr;
            if (bl) {
                object = ((zzdtr)((Object)object)).getChildAt(0);
            }
            if ((bl = object instanceof zzg) || (bl = object instanceof NativeAdView)) {
                string2 = "NATIVE";
                n4 = 1;
            } else {
                string2 = "UNKNOWN";
                n4 = 0;
            }
            if ((n3 = object.getLocalVisibleRect(rect)) != 0) {
                n3 = rect.width();
                int n5 = rect.height();
                n2 = n3;
                n3 = n5;
            } else {
                n2 = 0;
                n3 = 0;
            }
            zzt.zzp();
            long l = zzs.zzt((View)object);
            object.getLocationOnScreen(nArray);
            int n6 = nArray[0];
            int n7 = nArray[1];
            boolean bl2 = object instanceof zzcmf;
            String string4 = "none";
            if (bl2) {
                object2 = ((zzcmf)object).zzR();
                if (object2 != null) {
                    object2 = ((zzfbj)object2).zzb;
                    int n8 = object.hashCode();
                    charSequence = new StringBuilder();
                    ((StringBuilder)charSequence).append((String)object2);
                    ((StringBuilder)charSequence).append(":");
                    ((StringBuilder)charSequence).append(n8);
                    object.setContentDescription((CharSequence)((StringBuilder)charSequence).toString());
                } else {
                    object2 = string4;
                }
            } else {
                object2 = string4;
            }
            int n9 = object instanceof zzckz;
            charSequence = "none";
            if (n9 != 0) {
                zzfbg zzfbg2 = ((zzckz)object).zzF();
                if (zzfbg2 != null) {
                    string2 = zzfbg.zza(zzfbg2.zzb);
                    n4 = zzfbg2.zzf;
                    charSequence = zzfbg2.zzF;
                    n9 = n4;
                } else {
                    n9 = n4;
                }
            } else {
                n9 = n4;
            }
            Locale locale = Locale.US;
            Object[] objectArray = new Object[]{object.hashCode(), string3, charSequence, object2, string2, n9, object.getClass().getName(), n6, n7, object.getWidth(), object.getHeight(), n2, n3, l, Integer.toString(n, 2)};
            object = String.format(locale, "<Ad hashCode=%d, package=%s, adNetCls=%s, gwsQueryId=%s, format=%s, impType=%d, class=%s, x=%d, y=%d, width=%d, height=%d, vWidth=%d, vHeight=%d, alpha=%d, state=%s>", objectArray);
            com.google.android.gms.ads.internal.util.zze.zzi((String)object);
            return;
        }
        catch (Exception exception) {
            com.google.android.gms.ads.internal.util.zze.zzh((String)"Failure getting view location.", (Throwable)exception);
            return;
        }
    }

    public static final void zzG(Context context, String string2, String object) {
        Object object2 = new ArrayList();
        object2.add(object);
        object = object2.iterator();
        while (object.hasNext()) {
            object2 = object.next();
            object2 = (String)object2;
            zzby zzby2 = new zzby(context, string2, (String)object2);
            zzby2.zzb();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final void zzH(Context context, Throwable throwable) {
        if (context == null) return;
        try {
            boolean bl = (Boolean)zzbjw.zzb.zze();
            if (!bl) return;
        }
        catch (IllegalStateException illegalStateException) {
            return;
        }
        CrashUtils.addDynamiteErrorToDropBox((Context)context, (Throwable)throwable);
    }

    public static final void zzI(Context context, Intent intent) {
        try {
            context.startActivity(intent);
            return;
        }
        catch (Throwable throwable) {
            intent.addFlags(0x10000000);
            context.startActivity(intent);
            return;
        }
    }

    public static final int zzJ(String string2) {
        try {
            int n = Integer.parseInt(string2);
            return n;
        }
        catch (NumberFormatException numberFormatException) {
            com.google.android.gms.ads.internal.util.zze.zzj((String)"Could not parse value:".concat(((Object)numberFormatException).toString()));
            return 0;
        }
    }

    @Nullable
    public static final Map zzK(Uri uri) {
        if (uri == null) {
            return null;
        }
        HashMap<String, String> hashMap = new HashMap<String, String>();
        for (String string2 : uri.getQueryParameterNames()) {
            if (TextUtils.isEmpty((CharSequence)string2)) continue;
            hashMap.put(string2, uri.getQueryParameter(string2));
        }
        return hashMap;
    }

    /*
     * Could not resolve type clashes
     * Unable to fully structure code
     */
    public static final WebResourceResponse zzL(HttpURLConnection var0) throws IOException {
        block5: {
            zzt.zzp();
            var1_1 = var0.getContentType();
            if (!TextUtils.isEmpty((CharSequence)var1_1)) break block5;
            var1_1 = "";
lbl6:
            // 2 sources

            while (true) {
                block6: {
                    zzt.zzp();
                    var2_2 = var0.getContentType();
                    if (TextUtils.isEmpty((CharSequence)var2_2)) {
                        var2_2 = "";
lbl12:
                        // 4 sources

                        while (true) {
                            var3_4 = var0.getHeaderFields();
                            var4_5 = new HashMap(var3_4.size());
                            for (Map.Entry var5_6 : var3_4.entrySet()) {
                                if (var5_6.getKey() == null || var5_6.getValue() == null || ((List)var5_6.getValue()).size() <= 0) continue;
                                var4_5.put((String)var5_6.getKey(), (String)((List)var5_6.getValue()).get(0));
                            }
                            return zzt.zzq().zzc(var1_1, var2_2, var0.getResponseCode(), var0.getResponseMessage(), (Map)var4_5, var0.getInputStream());
                        }
                    }
                    var3_4 = var2_2.split(";");
                    if (((String[])var3_4).length != 1) break block6;
                    var2_2 = "";
                    ** GOTO lbl12
                }
                for (var2_3 = 1; var2_3 < ((Object)var3_4).length; ++var2_3) {
                    if (!var3_4[var2_3].trim().startsWith("charset") || (var4_5 = var3_4[var2_3].trim().split("=")).length <= 1) continue;
                    var2_2 = var4_5[1].trim();
                    ** GOTO lbl12
                }
                var2_2 = "";
                ** continue;
                break;
            }
        }
        var1_1 = var1_1.split(";")[0].trim();
        ** while (true)
    }

    public static final int[] zzM(Activity activity) {
        if ((activity = activity.getWindow()) != null && (activity = activity.findViewById(0x1020002)) != null) {
            int[] nArray = new int[]{activity.getWidth(), activity.getHeight()};
            return nArray;
        }
        return zzs.zzs();
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    public static final int[] zzN(Activity activity) {
        void var1_4;
        int[] nArray;
        View view;
        Window window = activity.getWindow();
        if (window != null && (view = window.findViewById(0x1020002)) != null) {
            nArray = new int[]{view.getTop(), view.getBottom()};
            int[] nArray2 = nArray;
        } else {
            int[] nArray3 = zzs.zzs();
        }
        nArray = new int[]{zzaw.zzb().zzb((Context)activity, (int)var1_4[0]), zzaw.zzb().zzb((Context)activity, (int)var1_4[1])};
        return nArray;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static final boolean zzO(View view, PowerManager powerManager, KeyguardManager keyguardManager) {
        boolean bl = !zzt.zzp().zzd ? (keyguardManager == null ? true : (keyguardManager.inKeyguardRestrictedInputMode() ? zzs.zzl(view) : true)) : true;
        long l = zzs.zzt(view);
        if (view.getVisibility() != 0) {
            return false;
        }
        if (!view.isShown()) {
            return false;
        }
        if (powerManager != null && !powerManager.isScreenOn()) {
            return false;
        }
        if (!bl) {
            return false;
        }
        powerManager = zzbhy.zzbe;
        if (((Boolean)zzay.zzc().zzb((zzbhq)powerManager)).booleanValue() && !view.getLocalVisibleRect((Rect)(powerManager = new Rect())) && !view.getGlobalVisibleRect((Rect)(powerManager = new Rect()))) {
            return false;
        }
        view = zzbhy.zzhW;
        if ((Boolean)zzay.zzc().zzb((zzbhq)view) == false) return true;
        view = zzbhy.zzhY;
        if (l >= (long)((Integer)zzay.zzc().zzb((zzbhq)view)).intValue()) return true;
        return false;
    }

    public static final void zzP(Context object, Uri object2) {
        try {
            Intent intent = new Intent("android.intent.action.VIEW", (Uri)object2);
            Bundle bundle = new Bundle();
            intent.putExtras(bundle);
            zzs.zzm(object, intent);
            bundle.putString("com.android.browser.application_id", object.getPackageName());
            object.startActivity(intent);
            object = object2.toString();
            object2 = new StringBuilder();
            ((StringBuilder)object2).append("Opening ");
            ((StringBuilder)object2).append((String)object);
            ((StringBuilder)object2).append(" in a new browser.");
            object = ((StringBuilder)object2).toString();
            com.google.android.gms.ads.internal.util.zze.zze((String)object);
            return;
        }
        catch (ActivityNotFoundException activityNotFoundException) {
            com.google.android.gms.ads.internal.util.zze.zzh((String)"No browser is found.", (Throwable)activityNotFoundException);
            return;
        }
    }

    public static final int[] zzQ(Activity activity) {
        int[] nArray = zzs.zzM(activity);
        int[] nArray2 = new int[]{zzaw.zzb().zzb((Context)activity, nArray[0]), zzaw.zzb().zzb((Context)activity, nArray[1])};
        return nArray2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean zzR(View view, Context context) {
        Context context2 = context.getApplicationContext();
        if (context2 != null) {
            context2 = (PowerManager)context2.getSystemService("power");
            return zzs.zzO(view, (PowerManager)context2, zzs.zzS(context));
        }
        context2 = null;
        return zzs.zzO(view, (PowerManager)context2, zzs.zzS(context));
    }
}

