/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.ads;

import android.content.Context;
import android.graphics.SurfaceTexture;
import android.media.MediaPlayer;
import android.net.Uri;
import android.os.Build;
import android.view.Surface;
import android.view.TextureView;
import android.view.View;
import com.google.android.gms.ads.internal.client.zzay;
import com.google.android.gms.ads.internal.util.zze;
import com.google.android.gms.ads.internal.util.zzs;
import com.google.android.gms.ads.internal.zzt;
import com.google.android.gms.internal.ads.zzbcx;
import com.google.android.gms.internal.ads.zzbhq;
import com.google.android.gms.internal.ads.zzbhy;
import com.google.android.gms.internal.ads.zzcgm;
import com.google.android.gms.internal.ads.zzcgn;
import com.google.android.gms.internal.ads.zzcgo;
import com.google.android.gms.internal.ads.zzcgp;
import com.google.android.gms.internal.ads.zzcgq;
import com.google.android.gms.internal.ads.zzcgr;
import com.google.android.gms.internal.ads.zzcgs;
import com.google.android.gms.internal.ads.zzcgt;
import com.google.android.gms.internal.ads.zzcgu;
import com.google.android.gms.internal.ads.zzcgw;
import com.google.android.gms.internal.ads.zzcgx;
import com.google.android.gms.internal.ads.zzchp;
import com.google.android.gms.internal.ads.zzchq;
import com.google.android.gms.internal.ads.zzchr;
import com.google.android.gms.internal.ads.zzchs;
import com.google.android.gms.internal.ads.zzfnu;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public final class zzcgv
extends zzcgx
implements TextureView.SurfaceTextureListener,
MediaPlayer.OnBufferingUpdateListener,
MediaPlayer.OnCompletionListener,
MediaPlayer.OnErrorListener,
MediaPlayer.OnInfoListener,
MediaPlayer.OnPreparedListener,
MediaPlayer.OnVideoSizeChangedListener {
    private static final Map zzc;
    private final zzchr zzd;
    private final zzchs zze;
    private final boolean zzf;
    private int zzg = 0;
    private int zzh = 0;
    private MediaPlayer zzi;
    private Uri zzj;
    private int zzk;
    private int zzl;
    private int zzm;
    private zzchp zzn;
    private final boolean zzo;
    private int zzp;
    private zzcgw zzq;
    private boolean zzr = false;
    private Integer zzs = null;

    @Override
    public final int zza() {
        if (this.zzG()) {
            return this.zzi.getCurrentPosition();
        }
        return 0;
    }

    @Override
    public final int zzb() {
        if (Build.VERSION.SDK_INT >= 26 && this.zzG()) {
            return this.zzi.getMetrics().getInt("android.media.mediaplayer.dropped");
        }
        return -1;
    }

    @Override
    public final int zzc() {
        if (this.zzG()) {
            return this.zzi.getDuration();
        }
        return -1;
    }

    @Override
    public final int zzd() {
        zzcgv zzcgv2 = zzcgv2.zzi;
        if (zzcgv2 != null) {
            return zzcgv2.getVideoHeight();
        }
        return 0;
    }

    @Override
    public final int zze() {
        zzcgv zzcgv2 = zzcgv2.zzi;
        if (zzcgv2 != null) {
            return zzcgv2.getVideoWidth();
        }
        return 0;
    }

    @Override
    public final long zzf() {
        return 0L;
    }

    @Override
    public final long zzg() {
        if (this.zzs != null) {
            return this.zzh() * (long)this.zzm / 100L;
        }
        return -1L;
    }

    @Override
    public final long zzh() {
        if (this.zzs != null) {
            return (long)this.zzc() * (long)this.zzs.intValue();
        }
        return -1L;
    }

    static /* bridge */ /* synthetic */ zzcgw zzi(zzcgv zzcgv2) {
        return zzcgv2.zzq;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public final String zzj() {
        Object object;
        if (!((zzcgv)object).zzo) {
            object = "";
            return "MediaPlayer".concat((String)object);
        }
        object = " spherical";
        return "MediaPlayer".concat((String)object);
    }

    public final String toString() {
        String string2 = this.getClass().getName();
        int n = this.hashCode();
        String string3 = Integer.toHexString(n);
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(string2);
        stringBuilder.append("@");
        stringBuilder.append(string3);
        return stringBuilder.toString();
    }

    static /* bridge */ /* synthetic */ void zzk(zzcgv zzcgv2, boolean bl) {
        zzcgv2.zzr = true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Lifted jumps to return sites
     */
    static /* bridge */ /* synthetic */ void zzl(zzcgv zzcgv2, MediaPlayer mediaPlayer) {
        MediaPlayer.TrackInfo[] trackInfoArray = zzbhy.zzbB;
        if ((Boolean)zzay.zzc().zzb((zzbhq)trackInfoArray) == false) return;
        if (zzcgv2.zzd == null) return;
        if (mediaPlayer == null) {
            return;
        }
        trackInfoArray = mediaPlayer.getTrackInfo();
        if (trackInfoArray == null) return;
        HashMap<String, String> hashMap = new HashMap<String, String>();
        int n = trackInfoArray.length;
        int n2 = 0;
        while (true) {
            if (n2 >= n) {
                if (hashMap.isEmpty()) return;
                zzcgv2.zzd.zzd("onMetadataEvent", hashMap);
                return;
            }
            MediaPlayer.TrackInfo trackInfo = trackInfoArray[n2];
            if (trackInfo != null) {
                switch (trackInfo.getTrackType()) {
                    default: {
                        break;
                    }
                    case 2: {
                        if ((trackInfo = trackInfo.getFormat()) == null) break;
                        if (trackInfo.containsKey("mime")) {
                            hashMap.put("audioMime", trackInfo.getString("mime"));
                        }
                        if (Build.VERSION.SDK_INT < 30 || !trackInfo.containsKey("codecs-string")) break;
                        hashMap.put("audioCodec", trackInfo.getString("codecs-string"));
                        break;
                    }
                    case 1: {
                        if ((trackInfo = trackInfo.getFormat()) == null) break;
                        if (trackInfo.containsKey("frame-rate")) {
                            try {
                                hashMap.put("frameRate", String.valueOf(trackInfo.getFloat("frame-rate")));
                            }
                            catch (ClassCastException classCastException) {
                                hashMap.put("frameRate", String.valueOf(trackInfo.getInteger("frame-rate")));
                            }
                        }
                        if (trackInfo.containsKey("bitrate")) {
                            zzcgv2.zzs = trackInfo.getInteger("bitrate");
                            hashMap.put("bitRate", String.valueOf(zzcgv2.zzs));
                        }
                        if (trackInfo.containsKey("width") && trackInfo.containsKey("height")) {
                            int n3 = trackInfo.getInteger("width");
                            int n4 = trackInfo.getInteger("height");
                            StringBuilder stringBuilder = new StringBuilder();
                            stringBuilder.append(n3);
                            stringBuilder.append("x");
                            stringBuilder.append(n4);
                            hashMap.put("resolution", stringBuilder.toString());
                        }
                        if (trackInfo.containsKey("mime")) {
                            hashMap.put("videoMime", trackInfo.getString("mime"));
                        }
                        if (Build.VERSION.SDK_INT < 30 || !trackInfo.containsKey("codecs-string")) break;
                        hashMap.put("videoCodec", trackInfo.getString("codecs-string"));
                    }
                }
            }
            ++n2;
        }
    }

    static {
        Map<Integer, String> map = new Map<Integer, String>();
        zzc = map;
        zzc.put(-1004, "MEDIA_ERROR_IO");
        zzc.put(-1007, "MEDIA_ERROR_MALFORMED");
        zzc.put(-1010, "MEDIA_ERROR_UNSUPPORTED");
        zzc.put(-110, "MEDIA_ERROR_TIMED_OUT");
        zzc.put(3, "MEDIA_INFO_VIDEO_RENDERING_START");
        zzc.put(100, "MEDIA_ERROR_SERVER_DIED");
        map = zzc;
        Integer n = 1;
        map.put(n, "MEDIA_ERROR_UNKNOWN");
        zzc.put(n, "MEDIA_INFO_UNKNOWN");
        zzc.put(700, "MEDIA_INFO_VIDEO_TRACK_LAGGING");
        zzc.put(701, "MEDIA_INFO_BUFFERING_START");
        zzc.put(702, "MEDIA_INFO_BUFFERING_END");
        zzc.put(800, "MEDIA_INFO_BAD_INTERLEAVING");
        zzc.put(801, "MEDIA_INFO_NOT_SEEKABLE");
        zzc.put(802, "MEDIA_INFO_METADATA_UPDATE");
        zzc.put(901, "MEDIA_INFO_UNSUPPORTED_SUBTITLE");
        zzc.put(902, "MEDIA_INFO_SUBTITLE_TIMED_OUT");
    }

    public zzcgv(Context context, zzchr zzchr2, boolean bl, boolean bl2, zzchq zzchq2, zzchs zzchs2) {
        super(context);
        this.setSurfaceTextureListener(this);
        this.zzd = zzchr2;
        this.zze = zzchs2;
        this.zzo = bl;
        this.zzf = bl2;
        this.zze.zza(this);
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void zzC() {
        com.google.android.gms.ads.internal.util.zze.zza("AdMediaPlayerView init MediaPlayer");
        SurfaceTexture surfaceTexture = this.getSurfaceTexture();
        if (this.zzj == null || surfaceTexture == null) {
            return;
        }
        this.zzD(false);
        try {
            void var1_3;
            MediaPlayer mediaPlayer;
            zzt.zzk();
            this.zzi = mediaPlayer = new MediaPlayer();
            this.zzi.setOnBufferingUpdateListener((MediaPlayer.OnBufferingUpdateListener)this);
            this.zzi.setOnCompletionListener((MediaPlayer.OnCompletionListener)this);
            this.zzi.setOnErrorListener((MediaPlayer.OnErrorListener)this);
            this.zzi.setOnInfoListener((MediaPlayer.OnInfoListener)this);
            this.zzi.setOnPreparedListener((MediaPlayer.OnPreparedListener)this);
            this.zzi.setOnVideoSizeChangedListener((MediaPlayer.OnVideoSizeChangedListener)this);
            this.zzm = 0;
            boolean bl = this.zzo;
            if (bl) {
                zzchp zzchp2;
                this.zzn = zzchp2 = new zzchp(this.getContext());
                this.zzn.zzd(surfaceTexture, this.getWidth(), this.getHeight());
                this.zzn.start();
                zzchp2 = this.zzn.zzb();
                if (zzchp2 != null) {
                    zzchp zzchp3 = zzchp2;
                } else {
                    this.zzn.zze();
                    this.zzn = null;
                }
            }
            this.zzi.setDataSource(this.getContext(), this.zzj);
            zzt.zzl();
            Surface surface = new Surface((SurfaceTexture)var1_3);
            this.zzi.setSurface(surface);
            this.zzi.setAudioStreamType(3);
            this.zzi.setScreenOnWhilePlaying(true);
            this.zzi.prepareAsync();
            this.zzE(1);
            return;
        }
        catch (IOException | IllegalArgumentException | IllegalStateException exception) {
            com.google.android.gms.ads.internal.util.zze.zzk((String)"Failed to initialize MediaPlayer at ".concat(String.valueOf(String.valueOf(this.zzj))), (Throwable)exception);
            this.onError(this.zzi, 1, 0);
            return;
        }
    }

    final /* synthetic */ void zzm(int n) {
        zzcgw zzcgw2 = ((zzcgv)((Object)zzcgw2)).zzq;
        if (zzcgw2 != null) {
            zzcgw2.onWindowVisibilityChanged(n);
            return;
        }
    }

    public final void onBufferingUpdate(MediaPlayer mediaPlayer, int n) {
        this.zzm = n;
    }

    public final void onCompletion(MediaPlayer mediaPlayer) {
        com.google.android.gms.ads.internal.util.zze.zza("AdMediaPlayerView completion");
        this.zzE(5);
        this.zzh = 5;
        mediaPlayer = com.google.android.gms.ads.internal.util.zzs.zza;
        zzcgo zzcgo2 = new zzcgo(this);
        mediaPlayer.post((Runnable)zzcgo2);
    }

    /*
     * Enabled aggressive block sorting
     */
    protected final void onMeasure(int n, int n2) {
        block21: {
            int n3;
            int n4;
            block23: {
                block24: {
                    block25: {
                        int n5;
                        int n6;
                        block30: {
                            block29: {
                                block28: {
                                    block26: {
                                        block27: {
                                            n4 = zzcgv.getDefaultSize((int)((zzcgv)((Object)zzchp2)).zzk, (int)n);
                                            n3 = zzcgv.getDefaultSize((int)((zzcgv)((Object)zzchp2)).zzl, (int)n2);
                                            if (((zzcgv)((Object)zzchp2)).zzk <= 0) break block23;
                                            if (((zzcgv)((Object)zzchp2)).zzl <= 0) break block24;
                                            if (((zzcgv)((Object)zzchp2)).zzn != null) break block25;
                                            n4 = View.MeasureSpec.getMode((int)n);
                                            n3 = View.MeasureSpec.getSize((int)n);
                                            n6 = View.MeasureSpec.getMode((int)n2);
                                            n5 = View.MeasureSpec.getSize((int)n2);
                                            if (n4 != 0x40000000) break block26;
                                            if (n6 != 0x40000000) break block27;
                                            n = ((zzcgv)((Object)zzchp2)).zzk;
                                            n2 = n * n5;
                                            n4 = ((zzcgv)((Object)zzchp2)).zzl;
                                            n6 = n3 * n4;
                                            if (n2 < n6) {
                                                n = n2 / n4;
                                                n2 = n5;
                                                break block21;
                                            } else if (n2 > n6) {
                                                n2 = n6 / n;
                                                n = n3;
                                                break block21;
                                            } else {
                                                n = n3;
                                                n2 = n5;
                                            }
                                            break block21;
                                        }
                                        n = 0x40000000;
                                        break block28;
                                    }
                                    n = n4;
                                }
                                if (n != 0x40000000) break block29;
                                n2 = n3 * ((zzcgv)((Object)zzchp2)).zzl / ((zzcgv)((Object)zzchp2)).zzk;
                                if (n6 == Integer.MIN_VALUE) {
                                    if (n2 > n5) {
                                        n = n3;
                                        n2 = n5;
                                        break block21;
                                    } else {
                                        n = n3;
                                    }
                                    break block21;
                                } else {
                                    n = n3;
                                }
                                break block21;
                            }
                            if (n6 != 0x40000000) break block30;
                            n2 = n5 * ((zzcgv)((Object)zzchp2)).zzk / ((zzcgv)((Object)zzchp2)).zzl;
                            if (n == Integer.MIN_VALUE) {
                                if (n2 > n3) {
                                    n = n3;
                                    n2 = n5;
                                    break block21;
                                } else {
                                    n = n2;
                                    n2 = n5;
                                }
                                break block21;
                            } else {
                                n = n2;
                                n2 = n5;
                            }
                            break block21;
                        }
                        int n7 = ((zzcgv)((Object)zzchp2)).zzk;
                        int n8 = ((zzcgv)((Object)zzchp2)).zzl;
                        if (n6 == Integer.MIN_VALUE) {
                            if (n8 > n5) {
                                n2 = n5 * n7 / n8;
                                n4 = n5;
                            } else {
                                n2 = n7;
                                n4 = n8;
                            }
                        } else {
                            n2 = n7;
                            n4 = n8;
                        }
                        if (n == Integer.MIN_VALUE) {
                            if (n2 > n3) {
                                n2 = n3 * n8 / n7;
                                n = n3;
                                break block21;
                            } else {
                                n = n2;
                                n2 = n4;
                            }
                            break block21;
                        } else {
                            n = n2;
                            n2 = n4;
                        }
                        break block21;
                    }
                    n = n4;
                    n2 = n3;
                    break block21;
                }
                n = n4;
                n2 = n3;
                break block21;
            }
            n = n4;
            n2 = n3;
        }
        zzchp2.setMeasuredDimension(n, n2);
        zzchp zzchp2 = ((zzcgv)((Object)zzchp2)).zzn;
        if (zzchp2 != null) {
            zzchp2.zzc(n, n2);
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public final void onPrepared(MediaPlayer mediaPlayer) {
        com.google.android.gms.ads.internal.util.zze.zza("AdMediaPlayerView prepared");
        this.zzE(2);
        this.zze.zzb();
        zzfnu zzfnu2 = com.google.android.gms.ads.internal.util.zzs.zza;
        Object object = new zzcgn(this, mediaPlayer);
        zzfnu2.post((Runnable)object);
        this.zzk = mediaPlayer.getVideoWidth();
        this.zzl = mediaPlayer.getVideoHeight();
        int n = this.zzp;
        if (n != 0) {
            this.zzq(n);
        }
        if (this.zzf && this.zzG() && this.zzi.getCurrentPosition() > 0 && this.zzh != 3) {
            com.google.android.gms.ads.internal.util.zze.zza("AdMediaPlayerView nudging MediaPlayer");
            this.zzF(0.0f);
            this.zzi.start();
            n = this.zzi.getCurrentPosition();
            long l = zzt.zzA().currentTimeMillis();
            while (this.zzG() && this.zzi.getCurrentPosition() == n && zzt.zzA().currentTimeMillis() - l <= 250L) {
            }
            this.zzi.pause();
            this.zzn();
        }
        n = this.zzk;
        int n2 = this.zzl;
        object = new StringBuilder();
        ((StringBuilder)object).append("AdMediaPlayerView stream dimensions: ");
        ((StringBuilder)object).append(n);
        ((StringBuilder)object).append(" x ");
        ((StringBuilder)object).append(n2);
        com.google.android.gms.ads.internal.util.zze.zzi((String)((StringBuilder)object).toString());
        if (this.zzh == 3) {
            this.zzp();
        }
        this.zzn();
    }

    public final void onSurfaceTextureAvailable(SurfaceTexture surfaceTexture, int n, int n2) {
        com.google.android.gms.ads.internal.util.zze.zza("AdMediaPlayerView surface created");
        this.zzC();
        surfaceTexture = com.google.android.gms.ads.internal.util.zzs.zza;
        zzcgq zzcgq2 = new zzcgq(this);
        surfaceTexture.post((Runnable)zzcgq2);
    }

    /*
     * Enabled aggressive block sorting
     */
    public final void onSurfaceTextureSizeChanged(SurfaceTexture surfaceTexture, int n, int n2) {
        zzchp zzchp2;
        com.google.android.gms.ads.internal.util.zze.zza("AdMediaPlayerView surface changed");
        int n3 = this.zzh;
        int n4 = this.zzk == n ? (this.zzl == n2 ? 1 : 0) : 0;
        if (this.zzi != null && n3 == 3 && n4 != 0) {
            n4 = this.zzp;
            if (n4 != 0) {
                this.zzq(n4);
            }
            this.zzp();
        }
        if ((zzchp2 = this.zzn) != null) {
            zzchp2.zzc(n, n2);
        }
        zzchp2 = com.google.android.gms.ads.internal.util.zzs.zza;
        zzcgr zzcgr2 = new zzcgr(this, n, n2);
        zzchp2.post(zzcgr2);
    }

    public final void onSurfaceTextureUpdated(SurfaceTexture surfaceTexture) {
        this.zze.zzf(this);
        this.zza.zza(surfaceTexture, this.zzq);
    }

    @Override
    public final void zzn() {
        this.zzF(this.zzb.zza());
    }

    public final void onVideoSizeChanged(MediaPlayer mediaPlayer, int n, int n2) {
        int n3;
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("AdMediaPlayerView size changed: ");
        stringBuilder.append(n);
        stringBuilder.append(" x ");
        stringBuilder.append(n2);
        com.google.android.gms.ads.internal.util.zze.zza(stringBuilder.toString());
        this.zzk = mediaPlayer.getVideoWidth();
        this.zzl = n3 = mediaPlayer.getVideoHeight();
        if (this.zzk != 0 && n3 != 0) {
            this.requestLayout();
            return;
        }
    }

    protected final void onWindowVisibilityChanged(int n) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("AdMediaPlayerView window visibility changed to ");
        stringBuilder.append(n);
        com.google.android.gms.ads.internal.util.zze.zza(stringBuilder.toString());
        stringBuilder = com.google.android.gms.ads.internal.util.zzs.zza;
        zzcgm zzcgm2 = new zzcgm(this, n);
        stringBuilder.post(zzcgm2);
        super.onWindowVisibilityChanged(n);
    }

    @Override
    public final void zzo() {
        com.google.android.gms.ads.internal.util.zze.zza("AdMediaPlayerView pause");
        if (this.zzG() && this.zzi.isPlaying()) {
            this.zzi.pause();
            this.zzE(4);
            zzfnu zzfnu2 = com.google.android.gms.ads.internal.util.zzs.zza;
            zzcgu zzcgu2 = new zzcgu(this);
            zzfnu2.post((Runnable)zzcgu2);
        }
        this.zzh = 4;
    }

    @Override
    public final void zzp() {
        com.google.android.gms.ads.internal.util.zze.zza("AdMediaPlayerView play");
        if (this.zzG()) {
            this.zzi.start();
            this.zzE(3);
            this.zza.zzb();
            zzfnu zzfnu2 = com.google.android.gms.ads.internal.util.zzs.zza;
            zzcgt zzcgt2 = new zzcgt(this);
            zzfnu2.post((Runnable)zzcgt2);
        }
        this.zzh = 3;
    }

    private final void zzD(boolean bl) {
        com.google.android.gms.ads.internal.util.zze.zza("AdMediaPlayerView release");
        zzchp zzchp2 = this.zzn;
        if (zzchp2 != null) {
            zzchp2.zze();
            this.zzn = null;
        }
        if ((zzchp2 = this.zzi) != null) {
            zzchp2.reset();
            this.zzi.release();
            this.zzi = null;
            this.zzE(0);
            if (bl) {
                this.zzh = 0;
                return;
            }
        }
    }

    @Override
    public final void zzq(int n) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("AdMediaPlayerView seek ");
        stringBuilder.append(n);
        com.google.android.gms.ads.internal.util.zze.zza(stringBuilder.toString());
        if (this.zzG()) {
            this.zzi.seekTo(n);
            this.zzp = 0;
            return;
        }
        this.zzp = n;
    }

    /*
     * Enabled aggressive block sorting
     */
    private final void zzE(int n) {
        if (n == 3) {
            this.zze.zzc();
            this.zzb.zzb();
        } else if (this.zzg == 3) {
            this.zze.zze();
            this.zzb.zzc();
        }
        this.zzg = n;
    }

    @Override
    public final void zzr(zzcgw zzcgw2) {
        this.zzq = zzcgw2;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void zzF(float f) {
        zzcgv zzcgv2;
        zzcgv2 = zzcgv2.zzi;
        if (zzcgv2 == null) {
            com.google.android.gms.ads.internal.util.zze.zzj((String)"AdMediaPlayerView setMediaPlayerVolume() called before onPrepared().");
            return;
        }
        try {
            zzcgv2.setVolume(f, f);
            return;
        }
        catch (IllegalStateException illegalStateException) {
            return;
        }
    }

    @Override
    public final void zzs(String string2) {
        zzbcx zzbcx2 = zzbcx.zza((Uri)(string2 = Uri.parse((String)string2)));
        if (zzbcx2 == null || zzbcx2.zza != null) {
            if (zzbcx2 != null) {
                string2 = Uri.parse((String)zzbcx2.zza);
            }
            this.zzj = string2;
            this.zzp = 0;
            this.zzC();
            this.requestLayout();
            this.invalidate();
            return;
        }
    }

    @Override
    public final void zzt() {
        com.google.android.gms.ads.internal.util.zze.zza("AdMediaPlayerView stop");
        MediaPlayer mediaPlayer = this.zzi;
        if (mediaPlayer != null) {
            mediaPlayer.stop();
            this.zzi.release();
            this.zzi = null;
            this.zzE(0);
            this.zzh = 0;
        }
        this.zze.zzd();
    }

    @Override
    public final void zzu(float f, float f2) {
        zzchp zzchp2 = ((zzcgv)((Object)zzchp2)).zzn;
        if (zzchp2 != null) {
            zzchp2.zzf(f, f2);
            return;
        }
    }

    static /* bridge */ /* synthetic */ boolean zzv(zzcgv zzcgv2) {
        return zzcgv2.zzr;
    }

    private final boolean zzG() {
        int n;
        return this.zzi != null && (n = this.zzg) != -1 && n != 0 && n != 1;
    }

    public final boolean onError(MediaPlayer object, int n, int n2) {
        object = (String)zzc.get(n);
        String string2 = (String)zzc.get(n2);
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("AdMediaPlayerView MediaPlayer error: ");
        stringBuilder.append((String)object);
        stringBuilder.append(":");
        stringBuilder.append(string2);
        com.google.android.gms.ads.internal.util.zze.zzj((String)stringBuilder.toString());
        this.zzE(-1);
        this.zzh = -1;
        stringBuilder = com.google.android.gms.ads.internal.util.zzs.zza;
        zzcgp zzcgp2 = new zzcgp(this, (String)object, string2);
        stringBuilder.post(zzcgp2);
        return true;
    }

    public final boolean onInfo(MediaPlayer object, int n, int n2) {
        Object object2 = zzc;
        object = n;
        object2 = object2.get(object);
        object2 = (String)object2;
        object = zzc;
        Comparable<Integer> comparable = n2;
        object = object.get(comparable);
        object = (String)object;
        comparable = new Comparable<Integer>();
        ((StringBuilder)comparable).append("AdMediaPlayerView MediaPlayer info: ");
        ((StringBuilder)comparable).append((String)object2);
        ((StringBuilder)comparable).append(":");
        ((StringBuilder)comparable).append((String)object);
        com.google.android.gms.ads.internal.util.zze.zza(((StringBuilder)comparable).toString());
        return true;
    }

    public final boolean onSurfaceTextureDestroyed(SurfaceTexture object) {
        com.google.android.gms.ads.internal.util.zze.zza("AdMediaPlayerView surface destroyed");
        object = this.zzi;
        if (object != null && this.zzp == 0) {
            this.zzp = object.getCurrentPosition();
        }
        if ((object = this.zzn) != null) {
            ((zzchp)object).zze();
        }
        object = com.google.android.gms.ads.internal.util.zzs.zza;
        zzcgs zzcgs2 = new zzcgs(this);
        object.post((Runnable)zzcgs2);
        this.zzD(true);
        return true;
    }
}

