/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.ads;

import android.net.Uri;
import android.text.TextUtils;
import androidx.annotation.Nullable;
import com.google.android.gms.ads.internal.util.zze;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.internal.ads.zzayi;
import com.google.android.gms.internal.ads.zzayk;
import com.google.android.gms.internal.ads.zzayo;
import com.google.android.gms.internal.ads.zzayq;
import com.google.android.gms.internal.ads.zzayr;
import com.google.android.gms.internal.ads.zzayx;
import com.google.android.gms.internal.ads.zzayy;
import com.google.android.gms.internal.ads.zzciz;
import com.google.android.gms.internal.ads.zzcjb;
import com.google.android.gms.internal.ads.zzcjc;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.SequenceInputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayDeque;
import java.util.Map;
import java.util.Queue;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

final class zzcjd
implements zzayr {
    private static final Pattern zzb = Pattern.compile("^bytes (\\d+)-(\\d+)/(\\d+)$");
    private final int zzc;
    private final int zzd;
    private final String zze;
    private final zzayq zzf;
    private final zzayx zzg;
    private zzayk zzh;
    private HttpURLConnection zzi;
    private final Queue zzj;
    private InputStream zzk;
    private boolean zzl;
    private long zzm;
    private long zzn;
    private long zzo;
    private long zzp;
    private long zzq;
    private final long zzr;
    private final long zzs;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public final int zza(byte[] byArray, int n, int n2) throws zzayo {
        if (n2 == 0) {
            return 0;
        }
        try {
            long l = this.zzm;
            long l2 = this.zzn;
            if (l - l2 == 0L) {
                return -1;
            }
            long l3 = this.zzo;
            long l4 = n2;
            l3 = l3 + l2 + l4;
            long l5 = this.zzs;
            long l6 = this.zzq;
            long l7 = l6 + 1L;
            if ((l3 += l5) > l7) {
                long l8 = this.zzp;
                if (l6 < l8) {
                    l3 = this.zzr;
                    l3 = l7 + l3;
                    l3 = Math.min(l8, Math.max(l3 - l5 + -1L, l7 + l4 + -1L));
                    this.zzf(l7, l3, 2);
                    this.zzq = l3;
                } else {
                    l3 = l6;
                }
            } else {
                l3 = l6;
            }
            ++l3;
            l = this.zzo;
            l3 -= l;
            l3 = Math.min(l4, l3 - this.zzn);
            n2 = (int)l3;
            int n3 = this.zzk.read(byArray, n, n2);
            if (n3 == -1) {
                EOFException eOFException = new EOFException();
                throw eOFException;
            }
            this.zzn += (long)n3;
            zzayx zzayx2 = this.zzg;
            if (zzayx2 == null) return n3;
            ((zzciz)zzayx2).zzW(this, n3);
            return n3;
        }
        catch (IOException iOException) {
            zzayo zzayo2 = new zzayo(iOException, this.zzh, 2);
            throw zzayo2;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public final long zzb(zzayk zzayk2) throws zzayo {
        Object object;
        Object object2;
        block6: {
            Matcher matcher;
            ((zzcjd)object).zzh = zzayk2;
            ((zzcjd)object).zzn = 0L;
            long l = zzayk2.zzc;
            long l2 = zzayk2.zzd;
            long l3 = l2 == -1L ? ((zzcjd)object).zzr : Math.min(((zzcjd)object).zzr, l2);
            ((zzcjd)object).zzo = l;
            ((zzcjd)object).zzi = ((zzcjd)object).zzf(l, l + l3 + -1L, 1);
            object2 = ((zzcjd)object).zzi.getHeaderField("Content-Range");
            if (!TextUtils.isEmpty((CharSequence)object2) && (matcher = zzb.matcher((CharSequence)object2)).find()) {
                long l4;
                try {
                    Long.parseLong(matcher.group(1));
                    l4 = Long.parseLong(matcher.group(2));
                    l3 = Long.parseLong(matcher.group(3));
                }
                catch (NumberFormatException numberFormatException) {
                    object = new StringBuilder();
                    ((StringBuilder)object).append("Unexpected Content-Range [");
                    ((StringBuilder)object).append((String)object2);
                    ((StringBuilder)object).append("]");
                    com.google.android.gms.ads.internal.util.zze.zzg((String)((StringBuilder)object).toString());
                    break block6;
                }
                l = zzayk2.zzd;
                if (l != -1L) {
                    ((zzcjd)object).zzm = l;
                    ((zzcjd)object).zzp = Math.max(l4, ((zzcjd)object).zzo + l + -1L);
                } else {
                    ((zzcjd)object).zzm = l3 - ((zzcjd)object).zzo;
                    ((zzcjd)object).zzp = l3 + -1L;
                }
                ((zzcjd)object).zzq = l4;
                ((zzcjd)object).zzl = true;
                object2 = ((zzcjd)object).zzg;
                if (object2 != null) {
                    ((zzciz)object2).zzX((zzayi)object, zzayk2);
                }
                return ((zzcjd)object).zzm;
            }
        }
        object = new zzcjb((String)object2, zzayk2);
        throw object;
    }

    @Override
    @Nullable
    public final Uri zzc() {
        HttpURLConnection httpURLConnection = ((zzcjd)((Object)httpURLConnection)).zzi;
        if (httpURLConnection == null) {
            return null;
        }
        return Uri.parse((String)httpURLConnection.getURL().toString());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @VisibleForTesting
    final HttpURLConnection zzf(long l, long l2, int n) throws zzayo {
        Object object;
        Object object2;
        Object object3 = this.zzh.zza.toString();
        try {
            boolean bl;
            object2 = new URL((String)object3);
            object2 = (HttpURLConnection)((URL)object2).openConnection();
            ((URLConnection)object2).setConnectTimeout(this.zzc);
            ((URLConnection)object2).setReadTimeout(this.zzd);
            object = this.zzf.zza().entrySet().iterator();
            while (bl = object.hasNext()) {
                Map.Entry entry = object.next();
                ((URLConnection)object2).setRequestProperty((String)entry.getKey(), (String)entry.getValue());
            }
            object = new StringBuilder();
            ((StringBuilder)object).append("bytes=");
            ((StringBuilder)object).append(l);
            ((StringBuilder)object).append("-");
            ((StringBuilder)object).append(l2);
            ((URLConnection)object2).setRequestProperty("Range", ((StringBuilder)object).toString());
            ((URLConnection)object2).setRequestProperty("User-Agent", this.zze);
            ((URLConnection)object2).setRequestProperty("Accept-Encoding", "identity");
            ((HttpURLConnection)object2).setRequestMethod("GET");
            ((URLConnection)object2).connect();
            this.zzj.add(object2);
        }
        catch (IOException iOException) {
            zzayo zzayo2 = new zzayo("Unable to connect to ".concat(String.valueOf(object3)), iOException, this.zzh, n);
            throw zzayo2;
        }
        object3 = this.zzh.zza.toString();
        try {}
        catch (IOException iOException) {
            this.zzg();
            object = new zzayo("Unable to connect to ".concat(String.valueOf(object3)), iOException, this.zzh, n);
            throw object;
        }
        int n2 = ((HttpURLConnection)object2).getResponseCode();
        if (n2 < 200 || n2 > 299) {
            object3 = ((URLConnection)object2).getHeaderFields();
            this.zzg();
            object2 = new zzcjc(n2, (Map)object3, this.zzh, n);
            throw object2;
        }
        try {
            object3 = ((URLConnection)object2).getInputStream();
            InputStream inputStream = this.zzk;
            if (inputStream != null) {
                inputStream = new SequenceInputStream(this.zzk, (InputStream)object3);
                object3 = inputStream;
            }
            this.zzk = object3;
            return object2;
        }
        catch (IOException iOException) {
            this.zzg();
            object2 = new zzayo(iOException, this.zzh, n);
            throw object2;
        }
    }

    @Override
    @Nullable
    public final Map zze() {
        HttpURLConnection httpURLConnection = ((zzcjd)((Object)httpURLConnection)).zzi;
        if (httpURLConnection == null) {
            return null;
        }
        return httpURLConnection.getHeaderFields();
    }

    zzcjd(String arrayDeque, zzayx zzayx2, int n, int n2, long l, long l2) {
        zzayy.zzb((String)((Object)arrayDeque));
        this.zze = arrayDeque;
        this.zzg = zzayx2;
        arrayDeque = new ArrayDeque();
        this.zzf = arrayDeque;
        this.zzc = n;
        this.zzd = n2;
        this.zzj = arrayDeque = new ArrayDeque();
        this.zzr = l;
        this.zzs = l2;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public final void zzd() throws zzayo {
        try {
            InputStream inputStream = this.zzk;
            if (inputStream != null) {
                inputStream.close();
            }
            this.zzk = null;
            this.zzg();
            if (this.zzl) {
                this.zzl = false;
                return;
            }
            return;
            catch (IOException iOException) {}
            zzayo zzayo2 = new zzayo(iOException, this.zzh, 3);
            throw zzayo2;
        }
        catch (Throwable throwable) {
            this.zzk = null;
            this.zzg();
            if (this.zzl) {
                this.zzl = false;
            }
            throw throwable;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void zzg() {
        while (true) {
            if (this.zzj.isEmpty()) {
                this.zzi = null;
                return;
            }
            HttpURLConnection httpURLConnection = (HttpURLConnection)this.zzj.remove();
            try {
                httpURLConnection.disconnect();
                continue;
            }
            catch (Exception exception) {
                com.google.android.gms.ads.internal.util.zze.zzh((String)"Unexpected error while disconnecting", (Throwable)exception);
                continue;
            }
            break;
        }
    }
}

