/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.ads;

import android.os.RemoteException;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewTreeObserver;
import androidx.annotation.Nullable;
import com.google.android.gms.ads.internal.client.zzdk;
import com.google.android.gms.ads.internal.util.zze;
import com.google.android.gms.ads.internal.zzt;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.dynamic.IObjectWrapper;
import com.google.android.gms.dynamic.ObjectWrapper;
import com.google.android.gms.internal.ads.zzbkl;
import com.google.android.gms.internal.ads.zzbkx;
import com.google.android.gms.internal.ads.zzbqt;
import com.google.android.gms.internal.ads.zzbqx;
import com.google.android.gms.internal.ads.zzcgi;
import com.google.android.gms.internal.ads.zzcxw;
import com.google.android.gms.internal.ads.zzdnb;
import com.google.android.gms.internal.ads.zzdng;
import com.google.android.gms.internal.ads.zzdrc;
import java.util.Collections;

public final class zzdrd
extends zzbqt
implements ViewTreeObserver.OnGlobalLayoutListener,
ViewTreeObserver.OnScrollChangedListener,
zzbkl {
    private View zza;
    private zzdk zzb;
    private zzdnb zzc;
    private boolean zzd;
    private boolean zze;

    @Nullable
    public final zzdk zzb() throws RemoteException {
        Preconditions.checkMainThread((String)"#008 Must be called on the main UI thread.");
        if (this.zzd) {
            com.google.android.gms.ads.internal.util.zze.zzg((String)"getVideoController: Instream ad should not be used after destroyed");
            return null;
        }
        return this.zzb;
    }

    @Nullable
    public final zzbkx zzc() {
        Preconditions.checkMainThread((String)"#008 Must be called on the main UI thread.");
        if (((zzdrd)((Object)zzdnb2)).zzd) {
            com.google.android.gms.ads.internal.util.zze.zzg((String)"getVideoController: Instream ad should not be used after destroyed");
            return null;
        }
        zzdnb zzdnb2 = ((zzdrd)((Object)zzdnb2)).zzc;
        if (zzdnb2 != null && zzdnb2.zza() != null) {
            return zzdnb2.zza().zza();
        }
        return null;
    }

    public zzdrd(zzdnb zzdnb2, zzdng zzdng2) {
        this.zza = zzdng2.zzf();
        this.zzb = zzdng2.zzj();
        this.zzc = zzdnb2;
        this.zzd = false;
        this.zze = false;
        if (zzdng2.zzr() != null) {
            zzdng2.zzr().zzao(this);
            return;
        }
    }

    public final void zzd() throws RemoteException {
        Preconditions.checkMainThread((String)"#008 Must be called on the main UI thread.");
        this.zzh();
        zzdnb zzdnb2 = this.zzc;
        if (zzdnb2 != null) {
            ((zzcxw)zzdnb2).zzV();
        }
        this.zzc = null;
        this.zza = null;
        this.zzb = null;
        this.zzd = true;
    }

    private final void zzg() {
        View view;
        zzdnb zzdnb2 = this.zzc;
        if (zzdnb2 != null && (view = this.zza) != null) {
            zzdnb2.zzv(view, Collections.emptyMap(), Collections.emptyMap(), zzdnb.zzP(this.zza));
            return;
        }
    }

    private final void zzh() {
        View view = this.zza;
        if (view == null) {
            return;
        }
        if ((view = view.getParent()) instanceof ViewGroup) {
            ((ViewGroup)view).removeView(this.zza);
            return;
        }
    }

    public final void onGlobalLayout() {
        this.zzg();
    }

    public final void onScrollChanged() {
        this.zzg();
    }

    public final void zze(IObjectWrapper iObjectWrapper) throws RemoteException {
        Preconditions.checkMainThread((String)"#008 Must be called on the main UI thread.");
        zzdrc zzdrc2 = new zzdrc(this);
        this.zzf(iObjectWrapper, (zzbqx)zzdrc2);
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void zzf(IObjectWrapper object, zzbqx zzbqx2) throws RemoteException {
        void var2_5;
        Preconditions.checkMainThread((String)"#008 Must be called on the main UI thread.");
        if (((zzdrd)((Object)string2)).zzd) {
            com.google.android.gms.ads.internal.util.zze.zzg((String)"Instream ad can not be shown after destroy().");
            zzdrd.zzi((zzbqx)var2_5, 2);
            return;
        }
        View view = ((zzdrd)((Object)string2)).zza;
        if (view == null || ((zzdrd)((Object)string2)).zzb == null) {
            String string2 = view == null ? "can not get video view." : "can not get video controller.";
            com.google.android.gms.ads.internal.util.zze.zzg((String)"Instream internal error: ".concat(string2));
            zzdrd.zzi((zzbqx)var2_5, 0);
            return;
        }
        if (((zzdrd)((Object)string2)).zze) {
            com.google.android.gms.ads.internal.util.zze.zzg((String)"Instream ad should not be used again.");
            zzdrd.zzi((zzbqx)var2_5, 1);
            return;
        }
        ((zzdrd)((Object)string2)).zze = true;
        super.zzh();
        Object object2 = ObjectWrapper.unwrap((IObjectWrapper)object);
        ViewGroup viewGroup = (ViewGroup)object2;
        view = ((zzdrd)((Object)string2)).zza;
        ViewGroup.LayoutParams layoutParams = new ViewGroup.LayoutParams(-1, -1);
        viewGroup.addView(view, layoutParams);
        zzt.zzx();
        zzcgi.zza(((zzdrd)((Object)string2)).zza, (ViewTreeObserver.OnGlobalLayoutListener)string2);
        zzt.zzx();
        zzcgi.zzb(((zzdrd)((Object)string2)).zza, (ViewTreeObserver.OnScrollChangedListener)string2);
        super.zzg();
        try {
            var2_5.zzf();
            return;
        }
        catch (RemoteException remoteException) {
            com.google.android.gms.ads.internal.util.zze.zzl((String)"#007 Could not call remote method.", (Throwable)remoteException);
            return;
        }
    }

    private static final void zzi(zzbqx zzbqx2, int n) {
        try {
            zzbqx2.zze(n);
            return;
        }
        catch (RemoteException remoteException) {
            com.google.android.gms.ads.internal.util.zze.zzl((String)"#007 Could not call remote method.", (Throwable)remoteException);
            return;
        }
    }
}

