/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.ads;

import android.os.Build;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.internal.ads.zzaie;
import com.google.android.gms.internal.ads.zzaih;
import java.io.File;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.MessageDigest;
import java.security.cert.X509Certificate;
import java.util.Arrays;

@VisibleForTesting
public final class zzfkn {
    @VisibleForTesting
    protected static final byte[] zza;
    @VisibleForTesting
    protected static final byte[] zzb;
    private final byte[] zzc = zzb;
    private final byte[] zzd = zza;

    static {
        byte[] byArray = new byte[]{61, 122, 18, 35, 1, -102, -93, -99, -98, -96, -29, 67, 106, -73, -64, -119, 107, -5, 79, -74, 121, -12, -34, 95, -25, -62, 63, 50, 108, -113, -103, 74};
        zza = byArray;
        byArray = new byte[]{16, 57, 56, -18, 69, 55, -27, -98, -114, -25, -110, -10, 84, 80, 79, -72, 52, 111, -58, -77, 70, -48, -69, -60, 65, 95, -61, 57, -4, -4, -114, -63};
        zzb = byArray;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean zza(File object) throws GeneralSecurityException {
        X509Certificate[][] x509CertificateArray;
        String string2 = ((File)object).getAbsolutePath();
        try {
            x509CertificateArray = zzaih.zza(string2);
        }
        catch (IOException | RuntimeException exception) {
            GeneralSecurityException generalSecurityException = new GeneralSecurityException("Failed to verify signatures", exception);
            throw generalSecurityException;
        }
        catch (zzaie zzaie2) {
            GeneralSecurityException generalSecurityException = new GeneralSecurityException("Package is not signed", zzaie2);
            throw generalSecurityException;
        }
        if (x509CertificateArray.length != 1) {
            Object object2 = new GeneralSecurityException("APK has more than one signature.");
            throw object2;
        }
        X509Certificate[] x509CertificateArray2 = x509CertificateArray[0];
        X509Certificate x509Certificate = x509CertificateArray2[0];
        byte[] byArray = MessageDigest.getInstance("SHA-256").digest(x509Certificate.getEncoded());
        if (Arrays.equals(((zzfkn)object2).zzd, byArray)) return true;
        if ("user".equals(Build.TYPE)) return false;
        if (!Arrays.equals(((zzfkn)object2).zzc, byArray)) return false;
        return true;
    }
}

