/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.ads;

import android.content.Context;
import android.content.pm.PackageManager;
import android.util.Base64;
import androidx.annotation.NonNull;
import com.google.android.gms.ads.identifier.AdvertisingIdClient;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.internal.ads.zzali;
import com.google.android.gms.internal.ads.zzaly;
import com.google.android.gms.internal.ads.zzfks;
import com.google.android.gms.internal.ads.zzfku;
import com.google.android.gms.internal.ads.zzfla;
import com.google.android.gms.internal.ads.zzflf;
import com.google.android.gms.internal.ads.zzflg;
import com.google.android.gms.internal.ads.zzflh;
import com.google.android.gms.internal.ads.zzfli;
import com.google.android.gms.internal.ads.zzflj;
import com.google.android.gms.internal.ads.zzflk;
import com.google.android.gms.tasks.Task;
import com.google.android.gms.tasks.Tasks;
import java.nio.ByteBuffer;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.Executor;

public final class zzfll {
    private final Context zza;
    private final Executor zzb;
    private final zzfks zzc;
    private final zzfku zzd;
    private final zzflk zze;
    private final zzflk zzf;
    private Task zzg;
    private Task zzh;

    public final zzaly zza() {
        return zzfll.zzg(this.zzg, this.zze.zza());
    }

    public final zzaly zzb() {
        return zzfll.zzg(this.zzh, this.zzf.zza());
    }

    private static zzaly zzg(@NonNull Task task, @NonNull zzaly zzaly2) {
        if (!task.isSuccessful()) {
            return zzaly2;
        }
        return (zzaly)task.getResult();
    }

    final /* synthetic */ zzaly zzc() throws Exception {
        Object object = ((zzfll)object).zza;
        zzali zzali2 = zzaly.zza();
        AdvertisingIdClient.Info info = AdvertisingIdClient.getAdvertisingIdInfo((Context)object);
        if ((object = info.getId()) != null && ((String)object).matches("^[a-fA-F0-9]{8}-([a-fA-F0-9]{4}-){3}[a-fA-F0-9]{12}$")) {
            object = UUID.fromString((String)object);
            byte[] byArray = new byte[16];
            ByteBuffer byteBuffer = ByteBuffer.wrap(byArray);
            byteBuffer.putLong(((UUID)object).getMostSignificantBits());
            byteBuffer.putLong(((UUID)object).getLeastSignificantBits());
            object = Base64.encodeToString((byte[])byArray, (int)11);
        }
        if (object != null) {
            zzali2.zzr((String)object);
            zzali2.zzq(info.isLimitAdTrackingEnabled());
            zzali2.zzY(6);
        }
        return (zzaly)zzali2.zzaj();
    }

    final /* synthetic */ zzaly zzd() throws Exception {
        zzfll zzfll2 = zzfll2.zza;
        PackageManager packageManager = zzfll2.getPackageManager();
        String string2 = zzfll2.getPackageName();
        packageManager = packageManager.getPackageInfo(string2, 0);
        return zzfla.zza((Context)zzfll2, zzfll2.getPackageName(), Integer.toString(packageManager.versionCode));
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    public static zzfll zze(@NonNull Context object, @NonNull Executor executor, @NonNull zzfks zzfks2, @NonNull zzfku zzfku2) {
        void var3_6;
        void var2_5;
        void var1_4;
        zzfli zzfli2 = new zzfli();
        zzflj zzflj2 = new zzflj();
        zzfll zzfll2 = new zzfll((Context)object, (Executor)var1_4, (zzfks)var2_5, (zzfku)var3_6, zzfli2, zzflj2);
        if (zzfll2.zzd.zzd()) {
            zzflf zzflf2 = new zzflf(zzfll2);
            zzfll2.zzg = zzfll2.zzh(zzflf2);
        } else {
            zzfll2.zzg = Tasks.forResult((Object)zzfll2.zze.zza());
        }
        zzflg zzflg2 = new zzflg(zzfll2);
        zzfll2.zzh = zzfll2.zzh(zzflg2);
        return zzfll2;
    }

    private final Task zzh(@NonNull Callable callable) {
        Executor executor = this.zzb;
        callable = Tasks.call((Executor)executor, (Callable)callable);
        executor = this.zzb;
        zzflh zzflh2 = new zzflh(this);
        return callable.addOnFailureListener(executor, zzflh2);
    }

    @VisibleForTesting
    zzfll(Context context, Executor executor, zzfks zzfks2, zzfku zzfku2, zzfli zzfli2, zzflj zzflj2) {
        this.zza = context;
        this.zzb = executor;
        this.zzc = zzfks2;
        this.zzd = zzfku2;
        this.zze = zzfli2;
        this.zzf = zzflj2;
    }

    final /* synthetic */ void zzf(Exception exception) {
        if (exception instanceof InterruptedException) {
            Thread.currentThread().interrupt();
        }
        this.zzc.zzc(2025, -1L, exception);
    }
}

