/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.ads;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.IntentFilter;
import android.media.AudioManager;
import android.os.Handler;
import androidx.annotation.Nullable;
import com.google.android.gms.internal.ads.zzcw;
import com.google.android.gms.internal.ads.zzdm;
import com.google.android.gms.internal.ads.zzdn;
import com.google.android.gms.internal.ads.zzeg;
import com.google.android.gms.internal.ads.zzie;
import com.google.android.gms.internal.ads.zzif;
import com.google.android.gms.internal.ads.zzij;
import com.google.android.gms.internal.ads.zzin;
import com.google.android.gms.internal.ads.zzkb;
import com.google.android.gms.internal.ads.zzke;
import com.google.android.gms.internal.ads.zzr;

final class zzkf {
    private final Context zza;
    private final Handler zzb;
    private final zzkb zzc;
    private final AudioManager zzd;
    @Nullable
    private zzke zze;
    private int zzf;
    private int zzg;
    private boolean zzh;

    public final int zza() {
        return this.zzd.getStreamMaxVolume(this.zzf);
    }

    public final int zzb() {
        if (zzeg.zza >= 28) {
            return this.zzd.getStreamMinVolume(this.zzf);
        }
        return 0;
    }

    private static int zzg(AudioManager audioManager, int n) {
        try {
            int n2 = audioManager.getStreamVolume(n);
            return n2;
        }
        catch (RuntimeException runtimeException) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("Could not retrieve stream volume for stream type ");
            stringBuilder.append(n);
            zzdn.zzb("StreamVolumeManager", stringBuilder.toString(), runtimeException);
            return audioManager.getStreamMaxVolume(n);
        }
    }

    static /* bridge */ /* synthetic */ Handler zzc(zzkf zzkf2) {
        return zzkf2.zzb;
    }

    static /* bridge */ /* synthetic */ void zzd(zzkf zzkf2) {
        zzkf2.zzh();
    }

    public zzkf(Context object, Handler handler, zzkb zzkb2) {
        this.zza = object.getApplicationContext();
        this.zzb = handler;
        this.zzc = zzkb2;
        object = (AudioManager)this.zza.getSystemService("audio");
        zzcw.zzb(object);
        this.zzd = object;
        this.zzf = 3;
        this.zzg = zzkf.zzg(this.zzd, 3);
        this.zzh = zzkf.zzi(this.zzd, this.zzf);
        super(this, null);
        super("android.media.VOLUME_CHANGED_ACTION");
        try {
            this.zza.registerReceiver((BroadcastReceiver)object, (IntentFilter)handler);
            this.zze = object;
            return;
        }
        catch (RuntimeException runtimeException) {
            zzdn.zzb("StreamVolumeManager", "Error registering stream volume receiver", runtimeException);
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void zze() {
        zzke zzke2 = this.zze;
        if (zzke2 == null) {
            return;
        }
        try {
            Context context = this.zza;
            context.unregisterReceiver((BroadcastReceiver)zzke2);
        }
        catch (RuntimeException runtimeException) {
            zzdn.zzb("StreamVolumeManager", "Error unregistering stream volume receiver", runtimeException);
        }
        this.zze = null;
    }

    public final void zzf(int n) {
        if (((zzkf)object).zzf == 3) {
            return;
        }
        ((zzkf)object).zzf = 3;
        ((zzkf)object).zzh();
        Object object = ((zzkf)object).zzc;
        zzr zzr2 = zzin.zzy(zzin.zzB(((zzij)object).zza));
        if (!zzr2.equals(zzin.zzx(((zzij)object).zza))) {
            zzin.zzG(((zzij)object).zza, zzr2);
            object = zzin.zzz(((zzij)object).zza);
            zzif zzif2 = new zzif(zzr2);
            ((zzdm)object).zzd(29, zzif2);
            ((zzdm)object).zzc();
            return;
        }
    }

    private final void zzh() {
        int n = zzkf.zzg(((zzkf)((Object)zzdm2)).zzd, ((zzkf)((Object)zzdm2)).zzf);
        boolean bl = zzkf.zzi(((zzkf)((Object)zzdm2)).zzd, ((zzkf)((Object)zzdm2)).zzf);
        if (((zzkf)((Object)zzdm2)).zzg != n || ((zzkf)((Object)zzdm2)).zzh != bl) {
            ((zzkf)((Object)zzdm2)).zzg = n;
            ((zzkf)((Object)zzdm2)).zzh = bl;
            zzdm zzdm2 = zzin.zzz(((zzij)((zzkf)((Object)zzdm2)).zzc).zza);
            zzie zzie2 = new zzie(n, bl);
            zzdm2.zzd(30, zzie2);
            zzdm2.zzc();
            return;
        }
    }

    private static boolean zzi(AudioManager audioManager, int n) {
        if (zzeg.zza >= 23) {
            return audioManager.isStreamMute(n);
        }
        return zzkf.zzg(audioManager, n) == 0;
    }
}

