/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.ads.nonagon.signalgeneration;

import android.annotation.TargetApi;
import android.content.Context;
import android.net.Uri;
import android.os.Bundle;
import android.text.TextUtils;
import android.util.Pair;
import android.view.MotionEvent;
import android.view.View;
import android.webkit.CookieManager;
import android.webkit.JavascriptInterface;
import android.webkit.WebView;
import com.google.ads.mediation.admob.AdMobAdapter;
import com.google.android.gms.ads.AdFormat;
import com.google.android.gms.ads.AdRequest;
import com.google.android.gms.ads.internal.client.zzba;
import com.google.android.gms.ads.internal.zzt;
import com.google.android.gms.ads.nonagon.signalgeneration.zzan;
import com.google.android.gms.ads.nonagon.signalgeneration.zzao;
import com.google.android.gms.ads.nonagon.signalgeneration.zzap;
import com.google.android.gms.ads.nonagon.signalgeneration.zzaq;
import com.google.android.gms.ads.nonagon.signalgeneration.zzar;
import com.google.android.gms.ads.nonagon.signalgeneration.zzf;
import com.google.android.gms.ads.query.QueryInfo;
import com.google.android.gms.ads.query.QueryInfoGenerationCallback;
import com.google.android.gms.common.annotation.KeepForSdk;
import com.google.android.gms.internal.ads.zzavi;
import com.google.android.gms.internal.ads.zzavj;
import com.google.android.gms.internal.ads.zzbfu;
import com.google.android.gms.internal.ads.zzbgc;
import com.google.android.gms.internal.ads.zzcec;
import com.google.android.gms.internal.ads.zzcep;
import com.google.android.gms.internal.ads.zzdwk;
import com.google.android.gms.internal.ads.zzfhl;
import com.google.android.gms.internal.ads.zzfny;
import com.google.android.gms.internal.ads.zzgey;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.json.JSONException;
import org.json.JSONObject;

final class TaggingLibraryJsInterface {
    private final Context zza;
    private final WebView zzb;
    private final zzavi zzc;
    private final zzfhl zzd;
    private final int zze;
    private final zzdwk zzf;
    private final boolean zzg;
    private final zzgey zzh = zzcep.zze;
    private final zzfny zzi;

    @JavascriptInterface
    @KeepForSdk
    @TargetApi(value=21)
    public String getClickSignals(String clickString) {
        String string2;
        block4: {
            long l;
            try {
                l = zzt.zzB().currentTimeMillis();
                string2 = this.zzc.zzc().zze(this.zza, string2, (View)this.zzb);
                boolean bl = this.zzg;
                if (!bl) break block4;
            }
            catch (RuntimeException runtimeException) {
                zzcec.zzh((String)"Exception getting click signals. ", (Throwable)runtimeException);
                string2 = "TaggingLibraryJsInterface.getClickSignals";
                zzt.zzo().zzw(runtimeException, string2);
                return "";
            }
            long l2 = zzt.zzB().currentTimeMillis();
            long l3 = l2 - l;
            com.google.android.gms.ads.nonagon.signalgeneration.zzf.zzc(this.zzf, null, "csg", new Pair((Object)"clat", (Object)String.valueOf(l3)));
        }
        return string2;
    }

    /*
     * WARNING - void declaration
     */
    @JavascriptInterface
    @KeepForSdk
    @TargetApi(value=21)
    public String getClickSignalsWithTimeout(String clickString, int timeoutMs) {
        String string2;
        void var2_3;
        if (timeoutMs <= 0) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("Invalid timeout for getting click signals. Timeout=");
            stringBuilder.append((int)var2_3);
            zzcec.zzg((String)stringBuilder.toString());
            return "";
        }
        Object object = zzcep.zza.zzb(new zzap((TaggingLibraryJsInterface)object, string2));
        long l = Math.min((int)var2_3, ((TaggingLibraryJsInterface)object).zze);
        try {
            object = (String)object.get(l, TimeUnit.MILLISECONDS);
            return object;
        }
        catch (InterruptedException | ExecutionException | TimeoutException exception) {
            zzcec.zzh((String)"Exception getting click signals with timeout. ", (Throwable)exception);
            string2 = "TaggingLibraryJsInterface.getClickSignalsWithTimeout";
            zzt.zzo().zzw(exception, string2);
            if (exception instanceof TimeoutException) {
                return "17";
            }
            return "";
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @JavascriptInterface
    @KeepForSdk
    @TargetApi(value=21)
    public String getQueryInfo() {
        zzt.zzp();
        String string2 = UUID.randomUUID().toString();
        Bundle bundle = new Bundle();
        bundle.putString("query_info_type", "requester_type_6");
        zzar zzar2 = new zzar(this, string2);
        zzbfu zzbfu2 = zzbgc.zzjt;
        if (((Boolean)zzba.zzc().zza(zzbfu2)).booleanValue()) {
            this.zzh.execute(new zzaq(this, bundle, zzar2));
            return string2;
        }
        QueryInfo.generate((Context)this.zza, (AdFormat)AdFormat.BANNER, (AdRequest)((AdRequest.Builder)new AdRequest.Builder().addNetworkExtrasBundle(AdMobAdapter.class, bundle)).build(), (QueryInfoGenerationCallback)zzar2);
        return string2;
    }

    @JavascriptInterface
    @KeepForSdk
    @TargetApi(value=21)
    public String getViewSignals() {
        String string2;
        block4: {
            long l;
            try {
                l = zzt.zzB().currentTimeMillis();
                string2 = this.zzc.zzc().zzh(this.zza, (View)this.zzb, null);
                boolean bl = this.zzg;
                if (!bl) break block4;
            }
            catch (RuntimeException runtimeException) {
                zzcec.zzh((String)"Exception getting view signals. ", (Throwable)runtimeException);
                string2 = "TaggingLibraryJsInterface.getViewSignals";
                zzt.zzo().zzw(runtimeException, string2);
                return "";
            }
            long l2 = zzt.zzB().currentTimeMillis();
            long l3 = l2 - l;
            com.google.android.gms.ads.nonagon.signalgeneration.zzf.zzc(this.zzf, null, "vsg", new Pair((Object)"vlat", (Object)String.valueOf(l3)));
        }
        return string2;
    }

    /*
     * WARNING - void declaration
     */
    @JavascriptInterface
    @KeepForSdk
    @TargetApi(value=21)
    public String getViewSignalsWithTimeout(int timeoutMs) {
        void var1_2;
        if (timeoutMs <= 0) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("Invalid timeout for getting view signals. Timeout=");
            stringBuilder.append((int)var1_2);
            zzcec.zzg((String)stringBuilder.toString());
            return "";
        }
        Object object = zzcep.zza.zzb(new zzan((TaggingLibraryJsInterface)object));
        long l = Math.min((int)var1_2, ((TaggingLibraryJsInterface)object).zze);
        try {
            object = (String)object.get(l, TimeUnit.MILLISECONDS);
            return object;
        }
        catch (InterruptedException | ExecutionException | TimeoutException exception) {
            zzcec.zzh((String)"Exception getting view signals with timeout. ", (Throwable)exception);
            String string2 = "TaggingLibraryJsInterface.getViewSignalsWithTimeout";
            zzt.zzo().zzw(exception, string2);
            if (exception instanceof TimeoutException) {
                return "17";
            }
            return "";
        }
    }

    /*
     * WARNING - void declaration
     */
    @JavascriptInterface
    @KeepForSdk
    @TargetApi(value=21)
    public void recordClick(String clickUrl) {
        void var1_1;
        zzbfu zzbfu2 = zzbgc.zzjv;
        if (!((Boolean)zzba.zzc().zza(zzbfu2)).booleanValue() || TextUtils.isEmpty((CharSequence)var1_1)) {
            return;
        }
        zzcep.zza.execute(new zzao(this, (String)var1_1));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @JavascriptInterface
    @KeepForSdk
    @TargetApi(value=21)
    public void reportTouchEvent(String touchJson) {
        String string2;
        JSONObject jSONObject = new JSONObject(string2);
        int n = jSONObject.getInt("x");
        int n2 = jSONObject.getInt("y");
        int n3 = jSONObject.getInt("duration_ms");
        double d = jSONObject.getDouble("force");
        float f = (float)d;
        int n4 = jSONObject.getInt("type");
        switch (n4) {
            default: {
                n4 = -1;
                break;
            }
            case 3: {
                n4 = 3;
                break;
            }
            case 2: {
                n4 = 2;
                break;
            }
            case 1: {
                n4 = 1;
                break;
            }
            case 0: {
                n4 = 0;
            }
        }
        try {
            MotionEvent motionEvent = MotionEvent.obtain((long)0L, (long)n3, (int)n4, (float)n, (float)n2, (float)f, (float)1.0f, (int)0, (float)1.0f, (float)1.0f, (int)0, (int)0);
            this.zzc.zzd(motionEvent);
            return;
        }
        catch (RuntimeException | JSONException throwable) {
            zzcec.zzh((String)"Failed to parse the touch string. ", (Throwable)throwable);
            string2 = "TaggingLibraryJsInterface.reportTouchEvent";
            zzt.zzo().zzw(throwable, string2);
            return;
        }
    }

    static /* bridge */ /* synthetic */ WebView zza(TaggingLibraryJsInterface taggingLibraryJsInterface) {
        return taggingLibraryJsInterface.zzb;
    }

    TaggingLibraryJsInterface(WebView webView, zzavi zzavi2, zzdwk zzdwk2, zzfny zzfny2, zzfhl zzfhl2) {
        this.zzb = webView;
        this.zza = webView.getContext();
        this.zzc = zzavi2;
        this.zzf = zzdwk2;
        zzbgc.zza((Context)this.zza);
        webView = zzbgc.zzjq;
        this.zze = (Integer)zzba.zzc().zza((zzbfu)webView);
        webView = zzbgc.zzjr;
        this.zzg = (Boolean)zzba.zzc().zza((zzbfu)webView);
        this.zzi = zzfny2;
        this.zzd = zzfhl2;
    }

    /*
     * Enabled aggressive block sorting
     */
    final /* synthetic */ void zzb(Bundle bundle, QueryInfoGenerationCallback queryInfoGenerationCallback) {
        CookieManager cookieManager = zzt.zzq().zza(this.zza);
        boolean bl = cookieManager != null ? cookieManager.acceptThirdPartyCookies(this.zzb) : false;
        bundle.putBoolean("accept_3p_cookie", bl);
        QueryInfo.generate((Context)this.zza, (AdFormat)AdFormat.BANNER, (AdRequest)((AdRequest.Builder)new AdRequest.Builder().addNetworkExtrasBundle(AdMobAdapter.class, bundle)).build(), (QueryInfoGenerationCallback)queryInfoGenerationCallback);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    final /* synthetic */ void zzc(String string2) {
        string2 = Uri.parse((String)string2);
        try {
            zzfhl zzfhl2;
            zzbfu zzbfu2 = zzbgc.zzlr;
            Object object = zzba.zzc().zza(zzbfu2);
            boolean bl = (Boolean)object;
            if (bl && (zzfhl2 = this.zzd) != null) {
                string2 = zzfhl2.zza((Uri)string2, this.zza, (View)this.zzb, null);
            } else {
                zzavi zzavi2 = this.zzc;
                Context context = this.zza;
                WebView webView = this.zzb;
                string2 = zzavi2.zza((Uri)string2, context, (View)webView, null);
            }
        }
        catch (zzavj zzavj2) {
            zzcec.zzf((String)"Failed to append the click signal to URL: ", (Throwable)zzavj2);
            String string3 = "TaggingLibraryJsInterface.recordClick";
            zzt.zzo().zzw(zzavj2, string3);
        }
        this.zzi.zzc(string2.toString(), null);
    }
}

