/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.ads;

import android.content.Context;
import android.net.Uri;
import android.os.Bundle;
import android.text.TextUtils;
import androidx.annotation.VisibleForTesting;
import androidx.browser.customtabs.CustomTabsCallback;
import androidx.browser.customtabs.CustomTabsClient;
import androidx.browser.customtabs.CustomTabsSession;
import com.google.ads.mediation.admob.AdMobAdapter;
import com.google.android.gms.ads.AdFormat;
import com.google.android.gms.ads.AdRequest;
import com.google.android.gms.ads.internal.client.zzba;
import com.google.android.gms.ads.internal.util.zze;
import com.google.android.gms.ads.internal.zzt;
import com.google.android.gms.ads.query.QueryInfo;
import com.google.android.gms.ads.query.QueryInfoGenerationCallback;
import com.google.android.gms.internal.ads.zzbfu;
import com.google.android.gms.internal.ads.zzbgc;
import com.google.android.gms.internal.ads.zzbhe;
import com.google.android.gms.internal.ads.zzbhf;
import com.google.android.gms.internal.ads.zzbhg;
import com.google.android.gms.internal.ads.zzcec;
import java.util.Date;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public final class zzbhh {
    private final ScheduledExecutorService zza;
    private Runnable zzb;
    private zzbhe zzc;
    private CustomTabsSession zzd;
    private String zze;
    private long zzf = 0L;
    private long zzg;
    private JSONArray zzh;
    private Context zzi;

    static /* bridge */ /* synthetic */ CustomTabsSession zza(zzbhh zzbhh2) {
        return zzbhh2.zzd;
    }

    @Nullable
    public final CustomTabsSession zzb() {
        return this.zzd;
    }

    @VisibleForTesting
    final JSONObject zzc(String string2, String string3) throws JSONException {
        JSONObject jSONObject = new JSONObject();
        jSONObject.put("paw_id", (Object)string2);
        jSONObject.put("error", (Object)string3);
        this.zzk(jSONObject);
        return jSONObject;
    }

    @VisibleForTesting
    final JSONObject zzd(String string2, String string3) throws JSONException {
        JSONObject jSONObject = new JSONObject();
        jSONObject.put("paw_id", (Object)string2);
        jSONObject.put("signal", (Object)string3);
        this.zzk(jSONObject);
        return jSONObject;
    }

    public static /* synthetic */ void zze(zzbhh zzbhh2) {
        zzbhh2.zzj();
    }

    @VisibleForTesting
    public zzbhh(ScheduledExecutorService scheduledExecutorService) {
        this.zza = scheduledExecutorService;
    }

    final void zzf() {
        zzbfu zzbfu2 = zzbgc.zzjA;
        this.zzf = zzt.zzB().elapsedRealtime() + (long)((Integer)zzba.zzc().zza(zzbfu2)).intValue();
        if (this.zzb == null) {
            this.zzb = new zzbhf(this);
        }
        this.zzj();
    }

    public final void zzg(@Nonnull Context context, @Nonnull CustomTabsClient customTabsClient, @Nonnull String string2, @Nullable CustomTabsCallback customTabsCallback) {
        if (context == null) {
            throw new IllegalArgumentException("App Context parameter is null");
        }
        if (TextUtils.isEmpty((CharSequence)string2)) {
            throw new IllegalArgumentException("Origin parameter is empty or null");
        }
        if (customTabsClient != null) {
            this.zzi = context;
            this.zze = string2;
            this.zzc = new zzbhe(this, customTabsCallback);
            this.zzd = customTabsClient.newSession((CustomTabsCallback)this.zzc);
            if (this.zzd == null) {
                zzcec.zzg((String)"CustomTabsClient failed to create new session.");
                return;
            }
        } else {
            throw new IllegalArgumentException("CustomTabsClient parameter is null");
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private final void zzj() {
        block5: {
            block6: {
                zzbhe zzbhe2 = zzbhh2.zzc;
                if (zzbhe2 == null) {
                    zzcec.zzg((String)"PACT callback is not present, please initialize the PawCustomTabsImpl.");
                    return;
                }
                if (zzbhe2.zza().booleanValue()) {
                    return;
                }
                if (zzbhh2.zze == null || zzbhh2.zzd == null || zzbhh2.zza == null) break block5;
                if (zzbhh2.zzf != 0L && zzt.zzB().elapsedRealtime() <= zzbhh2.zzf) break block6;
                zzbhe2 = zzbgc.zzjB;
                if (!((Boolean)zzba.zzc().zza((zzbfu)zzbhe2)).booleanValue()) break block5;
            }
            zzbhh2.zzd.requestPostMessageChannel(Uri.parse((String)zzbhh2.zze));
            zzbhh zzbhh2 = zzbgc.zzjC;
            zzbhh2.zza.schedule(zzbhh2.zzb, (long)((Long)zzba.zzc().zza((zzbfu)zzbhh2)), TimeUnit.MILLISECONDS);
            return;
        }
        com.google.android.gms.ads.internal.util.zze.zza("PACT max retry connection duration timed out");
    }

    final void zzh(String string2) {
        try {
            CustomTabsSession customTabsSession = this.zzd;
            Object object = new JSONObject();
            object.put("gsppack", true);
            object.put("fpt", (Object)new Date(this.zzg).toString());
            this.zzk((JSONObject)object);
            customTabsSession.postMessage(object.toString(), null);
            customTabsSession = new Bundle();
            customTabsSession.putString("query_info_type", "requester_type_6");
            object = new zzbhg(this, string2);
            QueryInfo.generate((Context)this.zzi, (AdFormat)AdFormat.BANNER, (AdRequest)((AdRequest.Builder)new AdRequest.Builder().addNetworkExtrasBundle(AdMobAdapter.class, (Bundle)customTabsSession)).build(), (QueryInfoGenerationCallback)object);
            return;
        }
        catch (JSONException jSONException) {
            zzcec.zzh((String)"Error creating JSON: ", (Throwable)jSONException);
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void zzk(JSONObject jSONObject) {
        try {
            JSONArray jSONArray = this.zzh;
            if (jSONArray == null) {
                zzbfu zzbfu2 = zzbgc.zzjE;
                Object object = zzba.zzc().zza(zzbfu2);
                this.zzh = jSONArray = new JSONArray((String)object);
            }
            jSONObject.put("eids", (Object)this.zzh);
            return;
        }
        catch (JSONException jSONException) {
            zzcec.zzh((String)"Error fetching the PACT active eids JSON: ", (Throwable)jSONException);
            return;
        }
    }

    public final void zzi(long l) {
        this.zzg = l;
    }
}

