/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.ads;

import android.os.RemoteException;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewTreeObserver;
import androidx.annotation.Nullable;
import com.google.android.gms.ads.internal.client.zzdq;
import com.google.android.gms.ads.internal.zzt;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.dynamic.IObjectWrapper;
import com.google.android.gms.dynamic.ObjectWrapper;
import com.google.android.gms.internal.ads.zzbiy;
import com.google.android.gms.internal.ads.zzbjj;
import com.google.android.gms.internal.ads.zzbpr;
import com.google.android.gms.internal.ads.zzbpv;
import com.google.android.gms.internal.ads.zzcec;
import com.google.android.gms.internal.ads.zzcfc;
import com.google.android.gms.internal.ads.zzcwh;
import com.google.android.gms.internal.ads.zzdmv;
import com.google.android.gms.internal.ads.zzdna;
import com.google.android.gms.internal.ads.zzdqz;
import java.util.Collections;

public final class zzdra
extends zzbpr
implements ViewTreeObserver.OnGlobalLayoutListener,
ViewTreeObserver.OnScrollChangedListener,
zzbiy {
    private View zza;
    private zzdq zzb;
    private zzdmv zzc;
    private boolean zzd;
    private boolean zze;

    @Nullable
    public final zzdq zzb() throws RemoteException {
        Preconditions.checkMainThread((String)"#008 Must be called on the main UI thread.");
        if (this.zzd) {
            zzcec.zzg((String)"getVideoController: Instream ad should not be used after destroyed");
            return null;
        }
        return this.zzb;
    }

    @Nullable
    public final zzbjj zzc() {
        Preconditions.checkMainThread((String)"#008 Must be called on the main UI thread.");
        if (((zzdra)((Object)zzdmv2)).zzd) {
            zzcec.zzg((String)"getVideoController: Instream ad should not be used after destroyed");
            return null;
        }
        zzdmv zzdmv2 = ((zzdra)((Object)zzdmv2)).zzc;
        if (zzdmv2 != null && zzdmv2.zzc() != null) {
            return zzdmv2.zzc().zza();
        }
        return null;
    }

    public zzdra(zzdmv zzdmv2, zzdna zzdna2) {
        this.zza = zzdna2.zzf();
        this.zzb = zzdna2.zzj();
        this.zzc = zzdmv2;
        this.zzd = false;
        this.zze = false;
        if (zzdna2.zzs() != null) {
            zzdna2.zzs().zzan(this);
            return;
        }
    }

    public final void zzd() throws RemoteException {
        Preconditions.checkMainThread((String)"#008 Must be called on the main UI thread.");
        this.zzh();
        zzdmv zzdmv2 = this.zzc;
        if (zzdmv2 != null) {
            ((zzcwh)zzdmv2).zzb();
        }
        this.zzc = null;
        this.zza = null;
        this.zzb = null;
        this.zzd = true;
    }

    private final void zzg() {
        View view;
        zzdmv zzdmv2 = this.zzc;
        if (zzdmv2 != null && (view = this.zza) != null) {
            zzdmv2.zzA(view, Collections.emptyMap(), Collections.emptyMap(), zzdmv.zzW(this.zza));
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private final void zzh() {
        View view = this.zza;
        if (view == null || !((view = view.getParent()) instanceof ViewGroup)) {
            return;
        }
        ((ViewGroup)view).removeView(this.zza);
    }

    public final void onGlobalLayout() {
        this.zzg();
    }

    public final void onScrollChanged() {
        this.zzg();
    }

    public final void zze(IObjectWrapper iObjectWrapper) throws RemoteException {
        Preconditions.checkMainThread((String)"#008 Must be called on the main UI thread.");
        this.zzf(iObjectWrapper, (zzbpv)new zzdqz(this));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void zzf(IObjectWrapper iObjectWrapper, zzbpv zzbpv2) throws RemoteException {
        Preconditions.checkMainThread((String)"#008 Must be called on the main UI thread.");
        if (((zzdra)((Object)string2)).zzd) {
            zzcec.zzg((String)"Instream ad can not be shown after destroy().");
            zzdra.zzi(zzbpv2, 2);
            return;
        }
        View view = ((zzdra)((Object)string2)).zza;
        if (view == null || ((zzdra)((Object)string2)).zzb == null) {
            String string2 = view == null ? "can not get video view." : "can not get video controller.";
            zzcec.zzg((String)"Instream internal error: ".concat(string2));
            zzdra.zzi(zzbpv2, 0);
            return;
        }
        if (((zzdra)((Object)string2)).zze) {
            zzcec.zzg((String)"Instream ad should not be used again.");
            zzdra.zzi(zzbpv2, 1);
            return;
        }
        ((zzdra)((Object)string2)).zze = true;
        super.zzh();
        ((ViewGroup)ObjectWrapper.unwrap((IObjectWrapper)iObjectWrapper)).addView(((zzdra)((Object)string2)).zza, new ViewGroup.LayoutParams(-1, -1));
        zzt.zzx();
        zzcfc.zza(((zzdra)((Object)string2)).zza, (ViewTreeObserver.OnGlobalLayoutListener)string2);
        zzt.zzx();
        zzcfc.zzb(((zzdra)((Object)string2)).zza, (ViewTreeObserver.OnScrollChangedListener)string2);
        super.zzg();
        try {
            zzbpv2.zzf();
            return;
        }
        catch (RemoteException remoteException) {
            zzcec.zzl((String)"#007 Could not call remote method.", (Throwable)remoteException);
            return;
        }
    }

    private static final void zzi(zzbpv zzbpv2, int n) {
        try {
            zzbpv2.zze(n);
            return;
        }
        catch (RemoteException remoteException) {
            zzcec.zzl((String)"#007 Could not call remote method.", (Throwable)remoteException);
            return;
        }
    }
}

